/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.util.localization;

import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.util.localization.Localizable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Localizer {
    protected Locale _locale;
    protected HashMap _resourceBundles;

    public Localizer() {
        this(Locale.getDefault());
    }

    public Localizer(Locale locale) {
        this._locale = locale;
        this._resourceBundles = new HashMap();
    }

    public Locale getLocale() {
        return this._locale;
    }

    public String localize(Localizable localizable) {
        String string = localizable.getResourceBundleName();
        try {
            Object[] objectArray;
            ResourceBundle resourceBundle = (ResourceBundle)this._resourceBundles.get(string);
            if (resourceBundle == null) {
                block14: {
                    try {
                        resourceBundle = ResourceBundle.getBundle(string, this._locale);
                    }
                    catch (MissingResourceException missingResourceException) {
                        int n = string.lastIndexOf(46);
                        if (n == -1) break block14;
                        objectArray = string.substring(n + 1);
                        try {
                            resourceBundle = ResourceBundle.getBundle((String)objectArray, this._locale);
                        }
                        catch (MissingResourceException missingResourceException2) {
                            return this.getDefaultMessage(localizable);
                        }
                    }
                }
                this._resourceBundles.put(string, resourceBundle);
            }
            if (resourceBundle == null) {
                return this.getDefaultMessage(localizable);
            }
            String string2 = localizable.getKey();
            if (string2 == null) {
                string2 = "undefined";
            }
            String string3 = null;
            try {
                string3 = resourceBundle.getString(string2);
            }
            catch (MissingResourceException missingResourceException) {
                string3 = resourceBundle.getString("undefined");
            }
            objectArray = localizable.getArguments();
            if (objectArray != null) {
                int n = 0;
                while (n < objectArray.length) {
                    if (objectArray[n] instanceof Localizable) {
                        objectArray[n] = this.localize((Localizable)objectArray[n]);
                    }
                    ++n;
                }
            }
            String string4 = MessageFormat.format(string3, objectArray);
            return string4;
        }
        catch (MissingResourceException missingResourceException) {
            return this.getDefaultMessage(localizable);
        }
    }

    protected String getDefaultMessage(Localizable localizable) {
        String string = localizable.getKey();
        Object[] objectArray = localizable.getArguments();
        StringBuffer stringBuffer = new StringBuffer();
        if (!(localizable instanceof LocalizableExceptionAdapter)) {
            stringBuffer.append("[failed to localize] ");
        }
        stringBuffer.append(String.valueOf(string));
        if (objectArray != null) {
            stringBuffer.append('(');
            int n = 0;
            while (n < objectArray.length) {
                if (n != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(String.valueOf(objectArray[n]));
                ++n;
            }
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }
}

