/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.sp;

import com.sun.xml.rpc.sp.ParseException;
import java.io.IOException;

public abstract class StreamingParser {
    public static final int START = 0;
    public static final int END = 1;
    public static final int ATTR = 2;
    public static final int CHARS = 3;
    public static final int IWS = 4;
    public static final int PI = 5;

    protected StreamingParser() {
    }

    public abstract int parse() throws ParseException, IOException;

    public abstract int state();

    public abstract String name();

    public abstract String value();

    public abstract String uriString();

    public abstract int line();

    public abstract int column();

    public abstract String publicId();

    public abstract String systemId();

    public abstract boolean isValidating();

    public abstract boolean isCoalescing();

    public abstract boolean isNamespaceAware();

    private static void quote(StringBuffer stringBuffer, String string, int n) {
        boolean bl = false;
        int n2 = Math.min(string.length(), n);
        if (n2 > n - 3) {
            bl = true;
            n2 = n - 3;
        }
        stringBuffer.append('\"');
        int n3 = 0;
        while (n3 < n2) {
            char c = string.charAt(n3);
            if (c < ' ' || c > '~') {
                if (c <= '\u00ff') {
                    if (c == '\n') {
                        stringBuffer.append("\\n");
                    } else if (c == '\r') {
                        stringBuffer.append("\\r");
                    } else {
                        stringBuffer.append("\\x");
                        if (c < '\u0010') {
                            stringBuffer.append('0');
                        }
                        stringBuffer.append(Integer.toHexString(c));
                    }
                } else if (c == '\"') {
                    stringBuffer.append("\\\"");
                } else {
                    stringBuffer.append("\\u");
                    String string2 = Integer.toHexString(c);
                    int n4 = string2.length();
                    while (n4 < 4) {
                        stringBuffer.append('0');
                        ++n4;
                    }
                    stringBuffer.append(string2);
                }
            } else {
                stringBuffer.append(c);
            }
            ++n3;
        }
        if (bl) {
            stringBuffer.append("...");
        }
        stringBuffer.append('\"');
    }

    public static String describe(int n, String string, String string2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (n) {
            case 0: {
                if (bl) {
                    stringBuffer.append("a ");
                }
                stringBuffer.append("start tag");
                if (string == null) break;
                stringBuffer.append(" for a \"" + string + "\" element");
                break;
            }
            case 1: {
                if (bl) {
                    stringBuffer.append("an ");
                }
                stringBuffer.append("end tag");
                if (string == null) break;
                stringBuffer.append(" for a \"" + string + "\" element");
                break;
            }
            case 2: {
                if (string == null) {
                    if (bl) {
                        stringBuffer.append("an ");
                    }
                    stringBuffer.append("attribute");
                    break;
                }
                if (bl) {
                    stringBuffer.append("the ");
                }
                stringBuffer.append("attribute \"" + string + "\"");
                if (string2 == null) break;
                stringBuffer.append(" with value \"" + string2 + "\"");
                break;
            }
            case 3: {
                if (bl) {
                    stringBuffer.append("some ");
                }
                stringBuffer.append("character data");
                if (string2 == null) break;
                stringBuffer.append(": ");
                StreamingParser.quote(stringBuffer, string2, 40);
                break;
            }
            case 4: {
                if (bl) {
                    stringBuffer.append("some ");
                }
                stringBuffer.append("ignorable whitespace");
                break;
            }
            case 5: {
                if (bl) {
                    stringBuffer.append("a ");
                }
                stringBuffer.append("processing instruction");
                if (string == null) break;
                stringBuffer.append(" with target \"" + string + "\"");
                break;
            }
            case -1: {
                if (bl) {
                    stringBuffer.append("the ");
                }
                stringBuffer.append("end of the document");
                break;
            }
            default: {
                throw new InternalError("Unknown parser state");
            }
        }
        return stringBuffer.toString();
    }

    public abstract String describe(boolean var1);

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[StreamingParser");
        if (this.systemId() != null) {
            stringBuffer.append(" " + this.systemId());
        }
        stringBuffer.append(": " + this.describe(false));
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

