/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.modeler.rmi;

import com.sun.xml.rpc.processor.modeler.ModelerConstants;
import com.sun.xml.rpc.processor.modeler.rmi.ArrayType;
import com.sun.xml.rpc.processor.modeler.rmi.ClassType;
import com.sun.xml.rpc.processor.modeler.rmi.RmiConstants;
import com.sun.xml.rpc.processor.modeler.rmi.RmiUtils;
import java.util.Hashtable;

public class RmiType
implements RmiConstants {
    private static final Hashtable typeHash = new Hashtable(231);
    private String typeSig;
    private int typeCode = 0;
    private Class classObj = null;
    public static final RmiType tVoid = new RmiType(11, "V");
    public static final RmiType tBoolean = new RmiType(0, "Z");
    public static final RmiType tByte = new RmiType(1, "B");
    public static final RmiType tChar = new RmiType(2, "C");
    public static final RmiType tShort = new RmiType(3, "S");
    public static final RmiType tInt = new RmiType(4, "I");
    public static final RmiType tFloat = new RmiType(6, "F");
    public static final RmiType tLong = new RmiType(5, "J");
    public static final RmiType tDouble = new RmiType(7, "D");
    public static final RmiType tObject = RmiType.classType(ModelerConstants.OBJECT_CLASSNAME);
    public static final RmiType tClassDesc = RmiType.classType(ModelerConstants.CLASS_CLASSNAME);
    public static final RmiType tString = RmiType.classType(ModelerConstants.STRING_CLASSNAME);

    protected RmiType() {
    }

    protected RmiType(int n, String string) {
        this.typeCode = n;
        this.typeSig = string;
        typeHash.put(string, this);
    }

    public final String getTypeSignature() {
        return this.typeSig;
    }

    public int getTypeCode() {
        return this.typeCode;
    }

    public RmiType getElementType() {
        throw new UnsupportedOperationException();
    }

    public String getClassName() {
        throw new UnsupportedOperationException();
    }

    public int getArrayDimension() {
        return 0;
    }

    public Class getTypeClass(ClassLoader classLoader) throws ClassNotFoundException {
        if (this.classObj == null) {
            if (this.typeSig.length() == 1) {
                this.classObj = RmiUtils.getClassForName(this.typeString(false), classLoader);
            } else {
                String string = RmiType.getTypeSigClassName(this.typeSig);
                this.classObj = Class.forName(string, true, classLoader);
            }
        }
        return this.classObj;
    }

    private static String getTypeSigClassName(String string) {
        String string2 = string;
        if (string2.charAt(0) == 'L') {
            string2 = string2.substring(1, string2.length() - 1).replace('/', '.');
        }
        return string2;
    }

    public static RmiType classType(String string) {
        String string2 = new String("L" + string + ";");
        RmiType rmiType = (RmiType)typeHash.get(string2);
        if (rmiType == null) {
            rmiType = new ClassType(string2, string);
        }
        return rmiType;
    }

    public static RmiType arrayType(RmiType rmiType) {
        String string = new String("[" + rmiType.getTypeSignature());
        RmiType rmiType2 = (RmiType)typeHash.get(string);
        if (rmiType2 == null) {
            rmiType2 = new ArrayType(string, rmiType);
        }
        return rmiType2;
    }

    public static RmiType getRmiType(Class clazz) {
        String string = clazz.isArray() ? clazz.getName() : RmiUtils.getTypeSig(clazz.getName());
        return RmiType.getRmiType(string);
    }

    public static RmiType getRmiType(String string) {
        RmiType rmiType = (RmiType)typeHash.get(string);
        if (rmiType != null) {
            return rmiType;
        }
        switch (string.charAt(0)) {
            case '[': {
                return RmiType.arrayType(RmiType.getRmiType(string.substring(1)));
            }
            case 'L': {
                return RmiType.classType(string.substring(1, string.length() - 1).replace('/', '.'));
            }
            case '(': {
                System.out.println("SIGC_METHOD");
            }
        }
        return rmiType;
    }

    public String typeString(boolean bl) {
        switch (this.typeCode) {
            case 11: {
                return ModelerConstants.VOID_CLASSNAME;
            }
            case 0: {
                return ModelerConstants.BOOLEAN_CLASSNAME;
            }
            case 1: {
                return ModelerConstants.BYTE_CLASSNAME;
            }
            case 2: {
                return ModelerConstants.CHAR_CLASSNAME;
            }
            case 3: {
                return ModelerConstants.SHORT_CLASSNAME;
            }
            case 4: {
                return ModelerConstants.INT_CLASSNAME;
            }
            case 5: {
                return ModelerConstants.LONG_CLASSNAME;
            }
            case 6: {
                return ModelerConstants.FLOAT_CLASSNAME;
            }
            case 7: {
                return ModelerConstants.DOUBLE_CLASSNAME;
            }
        }
        return "unknown";
    }

    public String toString() {
        return this.typeString(false);
    }
}

