/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator.writer;

import com.sun.xml.rpc.processor.config.TypeMappingInfo;
import com.sun.xml.rpc.processor.generator.GeneratorConstants;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriterBase;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.java.JavaCustomType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.io.IOException;
import javax.naming.OperationNotSupportedException;

public class CustomSerializerWriter
extends SerializerWriterBase
implements GeneratorConstants {
    private String serializerName;
    private String serializerMemberName;
    private String deserializerName;
    private String deserializerMemberName;

    public CustomSerializerWriter(SOAPType sOAPType, Names names) {
        super(sOAPType, names);
        this.serializerName = names.getTypeQName(sOAPType.getName()) + "_Serializer";
        this.serializerMemberName = names.getClassMemberName(this.serializerName);
        this.deserializerName = names.getTypeQName(sOAPType.getName()) + "_Deserializer";
        this.deserializerMemberName = names.getClassMemberName(this.deserializerName);
    }

    public void createSerializer(IndentingWriter indentingWriter, StringBuffer stringBuffer, String string, boolean bl, boolean bl2, String string2) throws IOException {
        throw new GeneratorException("generator.nestedGeneratorError", new LocalizableExceptionAdapter(new OperationNotSupportedException()));
    }

    public void registerSerializer(IndentingWriter indentingWriter, boolean bl, boolean bl2, String string) throws IOException {
        TypeMappingInfo typeMappingInfo = ((JavaCustomType)this.type.getJavaType()).getTypeMappingInfo();
        if (!typeMappingInfo.getEncodingStyle().equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            throw new GeneratorException("generator.unsupported.encoding.encountered", typeMappingInfo.getEncodingStyle().toString());
        }
        String string2 = typeMappingInfo.getSerializerFactoryName();
        String string3 = typeMappingInfo.getDeserializerFactoryName();
        StringBuffer stringBuffer = new StringBuffer("type");
        this.declareType(indentingWriter, stringBuffer, this.type.getName(), false, false);
        indentingWriter.pln(string + ".register(" + this.type.getJavaType().getRealName() + ".class, " + stringBuffer.toString() + ", " + "new " + string2 + "(), " + "new " + string3 + "());");
    }

    public void declareSerializer(IndentingWriter indentingWriter, boolean bl, boolean bl2) throws IOException {
        String string = this.getPrivateModifier(bl, bl2);
        indentingWriter.pln("private JAXRPCSerializer " + this.serializerMemberName + ";");
        indentingWriter.pln("private JAXRPCDeserializer " + this.deserializerMemberName + ";");
    }

    public void initializeSerializer(IndentingWriter indentingWriter, String string, String string2) throws IOException {
        indentingWriter.pln(this.serializerMemberName + " = (JAXRPCSerializer)registry.getSerializer(SOAPConstants.NS_SOAP_ENCODING, " + this.type.getJavaType().getRealName() + ".class, " + string + ");");
        indentingWriter.pln(this.deserializerMemberName + " = (JAXRPCDeserializer)registry.getDeserializer(SOAPConstants.NS_SOAP_ENCODING, " + this.type.getJavaType().getRealName() + ".class, " + string + ");");
    }

    public String serializerName() {
        return this.serializerName;
    }

    public String serializerMemberName() {
        return this.serializerMemberName;
    }

    public String deserializerName() {
        return this.deserializerName;
    }

    public String deserializerMemberName() {
        return this.deserializerMemberName;
    }

    protected String getPrivateModifier(boolean bl, boolean bl2) {
        return "private " + super.getModifier(bl, bl2);
    }

    public AbstractType getElementType() {
        SOAPType sOAPType = ((SOAPArrayType)this.type).getElementType();
        while (sOAPType instanceof SOAPArrayType) {
            sOAPType = ((SOAPArrayType)sOAPType).getElementType();
        }
        return sOAPType;
    }
}

