/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.ProcessorAction;
import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorConstants;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriterFactory;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriterFactoryImpl;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.ModelVisitor;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Request;
import com.sun.xml.rpc.processor.model.Response;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.literal.LiteralAllType;
import com.sun.xml.rpc.processor.model.literal.LiteralArrayType;
import com.sun.xml.rpc.processor.model.literal.LiteralAttributeMember;
import com.sun.xml.rpc.processor.model.literal.LiteralElementMember;
import com.sun.xml.rpc.processor.model.literal.LiteralFragmentType;
import com.sun.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.sun.xml.rpc.processor.model.literal.LiteralSimpleType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.model.literal.LiteralTypeVisitor;
import com.sun.xml.rpc.processor.model.soap.RPCRequestOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCRequestUnorderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCResponseStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPAnyType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPCustomType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.model.soap.SOAPTypeVisitor;
import com.sun.xml.rpc.processor.model.soap.SOAPUnorderedStructureType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.util.localization.Localizable;
import com.sun.xml.rpc.util.localization.LocalizableMessageFactory;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public abstract class GeneratorBase
implements GeneratorConstants,
ProcessorAction,
ModelVisitor,
SOAPTypeVisitor,
LiteralTypeVisitor {
    protected File sourceDir;
    protected File destDir;
    protected File nonclassDestDir;
    protected ProcessorEnvironment env;
    protected Model model;
    protected Service service;
    protected IndentingWriter out;
    protected boolean encodeTypes;
    protected boolean multiRefEncoding;
    protected boolean serializeInterfaces;
    protected SerializerWriterFactory writerFactory;
    private LocalizableMessageFactory messageFactory;
    private Set visitedTypes;

    public GeneratorBase() {
        this.sourceDir = null;
        this.destDir = null;
        this.nonclassDestDir = null;
        this.env = null;
        this.model = null;
        this.out = null;
    }

    public void perform(Model model, Configuration configuration, Properties properties) {
        ProcessorEnvironment processorEnvironment = configuration.getEnvironment();
        String string = "destinationDirectory";
        String string2 = properties.getProperty(string);
        File file = new File(string2);
        string = "sourceDirectory";
        String string3 = properties.getProperty(string);
        File file2 = new File(string3);
        string = "nonclassDestinationDirectory";
        String string4 = properties.getProperty(string);
        File file3 = new File(string4);
        GeneratorBase generatorBase = this.getGenerator(model, configuration, properties);
        generatorBase.doGeneration();
    }

    public abstract GeneratorBase getGenerator(Model var1, Configuration var2, Properties var3);

    protected GeneratorBase(Model model, Configuration configuration, Properties properties) {
        this.model = model;
        this.env = configuration.getEnvironment();
        String string = "destinationDirectory";
        String string2 = properties.getProperty(string);
        this.destDir = new File(string2);
        string = "sourceDirectory";
        String string3 = properties.getProperty(string);
        this.sourceDir = new File(string3);
        string = "nonclassDestinationDirectory";
        String string4 = properties.getProperty(string);
        this.nonclassDestDir = new File(string4);
        string = "encodeTypes";
        this.encodeTypes = Boolean.valueOf(properties.getProperty(string));
        string = "multiRefEncoding";
        this.multiRefEncoding = Boolean.valueOf(properties.getProperty(string));
        this.messageFactory = new LocalizableMessageFactory("com.sun.xml.rpc.resources.generator");
        string = "serializerInterfaces";
        this.serializeInterfaces = Boolean.valueOf(properties.getProperty(string));
    }

    protected void doGeneration() {
        try {
            this.model.accept(this);
        }
        catch (Exception exception) {
            throw new GeneratorException("generator.nestedGeneratorError", new LocalizableExceptionAdapter(exception));
        }
    }

    public void visit(Model model) throws Exception {
        this.visitedTypes = new HashSet();
        this.preVisitModel(model);
        this.visitModel(model);
        this.postVisitModel(model);
    }

    protected void preVisitModel(Model model) throws Exception {
    }

    protected void visitModel(Model model) throws Exception {
        this.env.getNames().resetPrefixFactory();
        this.writerFactory = new SerializerWriterFactoryImpl(this.env.getNames());
        Iterator iterator = model.getServices();
        while (iterator.hasNext()) {
            ((Service)iterator.next()).accept(this);
        }
    }

    protected void postVisitModel(Model model) throws Exception {
    }

    public void visit(Service service) throws Exception {
        this.preVisitService(service);
        this.visitService(service);
        this.postVisitService(service);
    }

    protected void preVisitService(Service service) throws Exception {
    }

    protected void visitService(Service service) throws Exception {
        this.service = service;
        Iterator iterator = service.getPorts();
        while (iterator.hasNext()) {
            ((Port)iterator.next()).accept(this);
        }
        this.service = null;
    }

    protected void postVisitService(Service service) throws Exception {
        Iterator iterator = this.model.getExtraTypes();
        while (iterator.hasNext()) {
            AbstractType abstractType = (AbstractType)iterator.next();
            if (abstractType.isSOAPType()) {
                ((SOAPType)abstractType).accept(this);
                continue;
            }
            if (!abstractType.isLiteralType()) continue;
            ((LiteralType)abstractType).accept(this);
        }
    }

    public void visit(Port port) throws Exception {
        this.preVisitPort(port);
        this.visitPort(port);
        this.postVisitPort(port);
    }

    protected void preVisitPort(Port port) throws Exception {
    }

    protected void visitPort(Port port) throws Exception {
        Iterator iterator = port.getOperations();
        while (iterator.hasNext()) {
            ((Operation)iterator.next()).accept(this);
        }
    }

    protected void postVisitPort(Port port) throws Exception {
    }

    public void visit(Operation operation) throws Exception {
        this.preVisitOperation(operation);
        this.visitOperation(operation);
        this.postVisitOperation(operation);
    }

    protected void preVisitOperation(Operation operation) throws Exception {
    }

    protected void visitOperation(Operation operation) throws Exception {
        operation.getRequest().accept(this);
        operation.getResponse().accept(this);
        Iterator iterator = operation.getAllFaults();
        if (iterator != null) {
            while (iterator.hasNext()) {
                Fault fault = (Fault)iterator.next();
                fault.accept(this);
            }
        }
    }

    protected void postVisitOperation(Operation operation) throws Exception {
    }

    public void visit(Parameter parameter) throws Exception {
        this.preVisitParameter(parameter);
        this.visitParameter(parameter);
        this.postVisitParameter(parameter);
    }

    protected void preVisitParameter(Parameter parameter) throws Exception {
    }

    protected void visitParameter(Parameter parameter) throws Exception {
    }

    protected void postVisitParameter(Parameter parameter) throws Exception {
    }

    public void visit(Block block) throws Exception {
        this.preVisitBlock(block);
        this.visitBlock(block);
        this.postVisitBlock(block);
    }

    protected void preVisitBlock(Block block) throws Exception {
    }

    protected void visitBlock(Block block) throws Exception {
    }

    protected void postVisitBlock(Block block) throws Exception {
    }

    public void visit(Response response) throws Exception {
        this.preVisitResponse(response);
        this.visitResponse(response);
        this.postVisitResponse(response);
    }

    protected void preVisitResponse(Response response) throws Exception {
    }

    protected void visitResponse(Response response) throws Exception {
        AbstractType abstractType;
        Block block;
        Iterator iterator = response.getParameters();
        while (iterator.hasNext()) {
            ((Parameter)iterator.next()).accept(this);
        }
        iterator = response.getBodyBlocks();
        while (iterator.hasNext()) {
            block = (Block)iterator.next();
            abstractType = block.getType();
            if (abstractType.isSOAPType()) {
                ((SOAPType)abstractType).accept(this);
            } else if (abstractType.isLiteralType()) {
                ((LiteralType)abstractType).accept(this);
            }
            this.responseBodyBlock(block);
        }
        iterator = response.getHeaderBlocks();
        while (iterator.hasNext()) {
            block = (Block)iterator.next();
            abstractType = block.getType();
            if (abstractType.isSOAPType()) {
                ((SOAPType)abstractType).accept(this);
            } else if (abstractType.isLiteralType()) {
                ((LiteralType)abstractType).accept(this);
            }
            this.responseHeaderBlock(block);
        }
    }

    protected void responseBodyBlock(Block block) throws Exception {
    }

    protected void responseHeaderBlock(Block block) throws Exception {
    }

    protected void postVisitResponse(Response response) throws Exception {
    }

    public void visit(Request request) throws Exception {
        this.preVisitRequest(request);
        this.visitRequest(request);
        this.postVisitRequest(request);
    }

    protected void preVisitRequest(Request request) throws Exception {
    }

    protected void visitRequest(Request request) throws Exception {
        AbstractType abstractType;
        Block block;
        Iterator iterator = request.getParameters();
        while (iterator.hasNext()) {
            ((Parameter)iterator.next()).accept(this);
        }
        iterator = request.getBodyBlocks();
        while (iterator.hasNext()) {
            block = (Block)iterator.next();
            abstractType = block.getType();
            if (abstractType.isSOAPType()) {
                ((SOAPType)abstractType).accept(this);
            } else if (abstractType.isLiteralType()) {
                ((LiteralType)abstractType).accept(this);
            }
            this.requestBodyBlock(block);
        }
        iterator = request.getHeaderBlocks();
        while (iterator.hasNext()) {
            block = (Block)iterator.next();
            abstractType = block.getType();
            if (abstractType.isSOAPType()) {
                ((SOAPType)abstractType).accept(this);
            } else if (abstractType.isLiteralType()) {
                ((LiteralType)abstractType).accept(this);
            }
            this.requestHeaderBlock(block);
        }
    }

    protected void requestBodyBlock(Block block) throws Exception {
    }

    protected void requestHeaderBlock(Block block) throws Exception {
    }

    protected void postVisitRequest(Request request) throws Exception {
    }

    public void visit(Fault fault) throws Exception {
        this.preVisitFault(fault);
        this.visitFault(fault);
        this.postVisitFault(fault);
    }

    protected void preVisitFault(Fault fault) throws Exception {
    }

    protected void visitFault(Fault fault) throws Exception {
        AbstractType abstractType = fault.getBlock().getType();
        if (abstractType.isSOAPType()) {
            ((SOAPType)abstractType).accept(this);
        }
    }

    protected void postVisitFault(Fault fault) throws Exception {
    }

    public void visit(SOAPCustomType sOAPCustomType) throws Exception {
        this.preVisitSOAPCustomType(sOAPCustomType);
        this.visitSOAPCustomType(sOAPCustomType);
        this.postVisitSOAPCustomType(sOAPCustomType);
    }

    protected void preVisitSOAPCustomType(SOAPCustomType sOAPCustomType) throws Exception {
    }

    protected void visitSOAPCustomType(SOAPCustomType sOAPCustomType) throws Exception {
    }

    protected void postVisitSOAPCustomType(SOAPCustomType sOAPCustomType) throws Exception {
    }

    public void visit(SOAPSimpleType sOAPSimpleType) throws Exception {
        this.preVisitSOAPSimpleType(sOAPSimpleType);
        this.visitSOAPSimpleType(sOAPSimpleType);
        this.postVisitSOAPSimpleType(sOAPSimpleType);
    }

    protected void preVisitSOAPSimpleType(SOAPSimpleType sOAPSimpleType) throws Exception {
    }

    protected void visitSOAPSimpleType(SOAPSimpleType sOAPSimpleType) throws Exception {
    }

    protected void postVisitSOAPSimpleType(SOAPSimpleType sOAPSimpleType) throws Exception {
    }

    public void visit(SOAPAnyType sOAPAnyType) throws Exception {
        this.preVisitSOAPAnyType(sOAPAnyType);
        this.visitSOAPAnyType(sOAPAnyType);
        this.postVisitSOAPAnyType(sOAPAnyType);
    }

    protected void preVisitSOAPAnyType(SOAPAnyType sOAPAnyType) throws Exception {
    }

    protected void visitSOAPAnyType(SOAPAnyType sOAPAnyType) throws Exception {
    }

    protected void postVisitSOAPAnyType(SOAPAnyType sOAPAnyType) throws Exception {
    }

    public void visit(SOAPEnumerationType sOAPEnumerationType) throws Exception {
        this.preVisitSOAPEnumerationType(sOAPEnumerationType);
        this.visitSOAPEnumerationType(sOAPEnumerationType);
        this.postVisitSOAPEnumerationType(sOAPEnumerationType);
    }

    protected void preVisitSOAPEnumerationType(SOAPEnumerationType sOAPEnumerationType) throws Exception {
    }

    protected void visitSOAPEnumerationType(SOAPEnumerationType sOAPEnumerationType) throws Exception {
    }

    protected void postVisitSOAPEnumerationType(SOAPEnumerationType sOAPEnumerationType) throws Exception {
    }

    public void visit(SOAPArrayType sOAPArrayType) throws Exception {
        this.preVisitSOAPArrayType(sOAPArrayType);
        this.visitSOAPArrayType(sOAPArrayType);
        this.postVisitSOAPArrayType(sOAPArrayType);
    }

    protected void preVisitSOAPArrayType(SOAPArrayType sOAPArrayType) throws Exception {
    }

    protected void visitSOAPArrayType(SOAPArrayType sOAPArrayType) throws Exception {
        SOAPType sOAPType = sOAPArrayType.getElementType();
        sOAPType.accept(this);
    }

    protected void postVisitSOAPArrayType(SOAPArrayType sOAPArrayType) throws Exception {
    }

    public void visit(SOAPOrderedStructureType sOAPOrderedStructureType) throws Exception {
        this.preVisitSOAPOrderedStructureType(sOAPOrderedStructureType);
        this.visitSOAPOrderedStructureType(sOAPOrderedStructureType);
        this.postVisitSOAPOrderedStructureType(sOAPOrderedStructureType);
    }

    protected void preVisitSOAPOrderedStructureType(SOAPOrderedStructureType sOAPOrderedStructureType) throws Exception {
        this.preVisitSOAPStructureType(sOAPOrderedStructureType);
    }

    protected void visitSOAPOrderedStructureType(SOAPOrderedStructureType sOAPOrderedStructureType) throws Exception {
        this.visit((SOAPStructureType)sOAPOrderedStructureType);
    }

    protected void postVisitSOAPOrderedStructureType(SOAPOrderedStructureType sOAPOrderedStructureType) throws Exception {
        this.postVisitSOAPStructureType(sOAPOrderedStructureType);
    }

    public void visit(SOAPUnorderedStructureType sOAPUnorderedStructureType) throws Exception {
        this.preVisitSOAPUnorderedStructureType(sOAPUnorderedStructureType);
        this.visitSOAPUnorderedStructureType(sOAPUnorderedStructureType);
        this.postVisitSOAPUnorderedStructureType(sOAPUnorderedStructureType);
    }

    protected void preVisitSOAPUnorderedStructureType(SOAPUnorderedStructureType sOAPUnorderedStructureType) throws Exception {
        this.preVisitSOAPStructureType(sOAPUnorderedStructureType);
    }

    protected void visitSOAPUnorderedStructureType(SOAPUnorderedStructureType sOAPUnorderedStructureType) throws Exception {
        this.visit((SOAPStructureType)sOAPUnorderedStructureType);
    }

    protected void postVisitSOAPUnorderedStructureType(SOAPUnorderedStructureType sOAPUnorderedStructureType) throws Exception {
        this.postVisitSOAPStructureType(sOAPUnorderedStructureType);
    }

    public void visit(RPCRequestOrderedStructureType rPCRequestOrderedStructureType) throws Exception {
        this.preVisitRPCRequestOrderedStructureType(rPCRequestOrderedStructureType);
        this.visitRPCRequestOrderedStructureType(rPCRequestOrderedStructureType);
        this.postVisitRPCRequestOrderedStructureType(rPCRequestOrderedStructureType);
    }

    protected void preVisitRPCRequestOrderedStructureType(RPCRequestOrderedStructureType rPCRequestOrderedStructureType) throws Exception {
        this.preVisitSOAPStructureType(rPCRequestOrderedStructureType);
    }

    protected void visitRPCRequestOrderedStructureType(RPCRequestOrderedStructureType rPCRequestOrderedStructureType) throws Exception {
        this.visit((SOAPStructureType)rPCRequestOrderedStructureType);
    }

    protected void postVisitRPCRequestOrderedStructureType(RPCRequestOrderedStructureType rPCRequestOrderedStructureType) throws Exception {
        this.postVisitSOAPStructureType(rPCRequestOrderedStructureType);
    }

    public void visit(RPCRequestUnorderedStructureType rPCRequestUnorderedStructureType) throws Exception {
        this.preVisitRPCRequestUnorderedStructureType(rPCRequestUnorderedStructureType);
        this.visitRPCRequestUnorderedStructureType(rPCRequestUnorderedStructureType);
        this.postVisitRPCRequestUnorderedStructureType(rPCRequestUnorderedStructureType);
    }

    protected void preVisitRPCRequestUnorderedStructureType(RPCRequestUnorderedStructureType rPCRequestUnorderedStructureType) throws Exception {
        this.preVisitSOAPStructureType(rPCRequestUnorderedStructureType);
    }

    protected void visitRPCRequestUnorderedStructureType(RPCRequestUnorderedStructureType rPCRequestUnorderedStructureType) throws Exception {
        this.visit((SOAPStructureType)rPCRequestUnorderedStructureType);
    }

    protected void postVisitRPCRequestUnorderedStructureType(RPCRequestUnorderedStructureType rPCRequestUnorderedStructureType) throws Exception {
        this.postVisitSOAPStructureType(rPCRequestUnorderedStructureType);
    }

    public void visit(RPCResponseStructureType rPCResponseStructureType) throws Exception {
        this.preVisitRPCResponseStructureType(rPCResponseStructureType);
        this.visitRPCResponseStructureType(rPCResponseStructureType);
        this.postVisitRPCResponseStructureType(rPCResponseStructureType);
    }

    protected void preVisitRPCResponseStructureType(RPCResponseStructureType rPCResponseStructureType) throws Exception {
        this.preVisitSOAPStructureType(rPCResponseStructureType);
    }

    protected void visitRPCResponseStructureType(RPCResponseStructureType rPCResponseStructureType) throws Exception {
        this.visit((SOAPStructureType)rPCResponseStructureType);
    }

    protected void postVisitRPCResponseStructureType(RPCResponseStructureType rPCResponseStructureType) throws Exception {
        this.postVisitSOAPStructureType(rPCResponseStructureType);
    }

    public void visit(SOAPStructureType sOAPStructureType) throws Exception {
        this.preVisitSOAPStructureType(sOAPStructureType);
        this.visitSOAPStructureType(sOAPStructureType);
        this.postVisitSOAPStructureType(sOAPStructureType);
    }

    protected void preVisitSOAPStructureType(SOAPStructureType sOAPStructureType) throws Exception {
    }

    protected void visitSOAPStructureType(SOAPStructureType sOAPStructureType) throws Exception {
        if (!this.visitedTypes.contains(sOAPStructureType)) {
            this.visitedTypes.add(sOAPStructureType);
            if (sOAPStructureType.getParentType() != null) {
                sOAPStructureType.getParentType().accept(this);
            }
            Iterator iterator = sOAPStructureType.getMembers();
            while (iterator.hasNext()) {
                SOAPStructureMember sOAPStructureMember = (SOAPStructureMember)iterator.next();
                sOAPStructureMember.getType().accept(this);
            }
        }
    }

    protected void postVisitSOAPStructureType(SOAPStructureType sOAPStructureType) throws Exception {
    }

    public void visit(LiteralSimpleType literalSimpleType) throws Exception {
        this.preVisitLiteralSimpleType(literalSimpleType);
        this.visitLiteralSimpleType(literalSimpleType);
        this.postVisitLiteralSimpleType(literalSimpleType);
    }

    protected void preVisitLiteralSimpleType(LiteralSimpleType literalSimpleType) throws Exception {
    }

    protected void visitLiteralSimpleType(LiteralSimpleType literalSimpleType) throws Exception {
    }

    protected void postVisitLiteralSimpleType(LiteralSimpleType literalSimpleType) throws Exception {
    }

    public void visit(LiteralSequenceType literalSequenceType) throws Exception {
        this.preVisitLiteralSequenceType(literalSequenceType);
        this.visitLiteralSequenceType(literalSequenceType);
        this.postVisitLiteralSequenceType(literalSequenceType);
    }

    protected void preVisitLiteralSequenceType(LiteralSequenceType literalSequenceType) throws Exception {
    }

    protected void visitLiteralSequenceType(LiteralSequenceType literalSequenceType) throws Exception {
        if (!this.visitedTypes.contains(literalSequenceType)) {
            this.visitedTypes.add(literalSequenceType);
            Iterator iterator = literalSequenceType.getAttributeMembers();
            while (iterator.hasNext()) {
                LiteralAttributeMember literalAttributeMember = (LiteralAttributeMember)iterator.next();
                literalAttributeMember.getType().accept(this);
            }
            Iterator iterator2 = literalSequenceType.getElementMembers();
            while (iterator2.hasNext()) {
                LiteralElementMember literalElementMember = (LiteralElementMember)iterator2.next();
                literalElementMember.getType().accept(this);
            }
        }
    }

    protected void postVisitLiteralSequenceType(LiteralSequenceType literalSequenceType) throws Exception {
    }

    public void visit(LiteralAllType literalAllType) throws Exception {
        this.preVisitLiteralAllType(literalAllType);
        this.visitLiteralAllType(literalAllType);
        this.postVisitLiteralAllType(literalAllType);
    }

    protected void preVisitLiteralAllType(LiteralAllType literalAllType) throws Exception {
    }

    protected void visitLiteralAllType(LiteralAllType literalAllType) throws Exception {
        if (!this.visitedTypes.contains(literalAllType)) {
            this.visitedTypes.add(literalAllType);
            Iterator iterator = literalAllType.getAttributeMembers();
            while (iterator.hasNext()) {
                LiteralAttributeMember literalAttributeMember = (LiteralAttributeMember)iterator.next();
                literalAttributeMember.getType().accept(this);
            }
            Iterator iterator2 = literalAllType.getElementMembers();
            while (iterator2.hasNext()) {
                LiteralElementMember literalElementMember = (LiteralElementMember)iterator2.next();
                literalElementMember.getType().accept(this);
            }
        }
    }

    protected void postVisitLiteralAllType(LiteralAllType literalAllType) throws Exception {
    }

    public void visit(LiteralArrayType literalArrayType) throws Exception {
        this.preVisitLiteralArrayType(literalArrayType);
        this.visitLiteralArrayType(literalArrayType);
        this.postVisitLiteralArrayType(literalArrayType);
    }

    protected void preVisitLiteralArrayType(LiteralArrayType literalArrayType) throws Exception {
    }

    protected void visitLiteralArrayType(LiteralArrayType literalArrayType) throws Exception {
        literalArrayType.getElementType().accept(this);
    }

    protected void postVisitLiteralArrayType(LiteralArrayType literalArrayType) throws Exception {
    }

    public void visit(LiteralFragmentType literalFragmentType) throws Exception {
        this.preVisitLiteralFragmentType(literalFragmentType);
        this.visitLiteralFragmentType(literalFragmentType);
        this.postVisitLiteralFragmentType(literalFragmentType);
    }

    protected void preVisitLiteralFragmentType(LiteralFragmentType literalFragmentType) throws Exception {
    }

    protected void visitLiteralFragmentType(LiteralFragmentType literalFragmentType) throws Exception {
    }

    protected void postVisitLiteralFragmentType(LiteralFragmentType literalFragmentType) throws Exception {
    }

    public static void writeWarning(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln("// Helper class generated by xrpcc, do not edit.");
        indentingWriter.pln("// Contents subject to change without notice.");
        indentingWriter.pln();
    }

    public static void writePackage(IndentingWriter indentingWriter, String string) throws IOException {
        GeneratorBase.writeWarning(indentingWriter);
        GeneratorBase.writePackageOnly(indentingWriter, string);
    }

    public static void writePackageOnly(IndentingWriter indentingWriter, String string) throws IOException {
        int n = string.lastIndexOf(".");
        if (n > 0) {
            indentingWriter.pln("package " + string.substring(0, n) + ";");
            indentingWriter.pln();
        }
    }

    protected void log(String string) {
        if (this.env.verbose()) {
            StringBuffer stringBuffer = new StringBuffer().append("[");
            this.env.getNames();
            System.out.println(stringBuffer.append(Names.stripQualifier(this.getClass().getName())).append(": ").append(string).append("]").toString());
        }
    }

    protected void warn(String string) {
        this.env.warn(this.messageFactory.getMessage(string));
    }

    protected void warn(String string, String string2) {
        this.env.warn(this.messageFactory.getMessage(string, string2));
    }

    protected void warn(String string, Object[] objectArray) {
        this.env.warn(this.messageFactory.getMessage(string, objectArray));
    }

    protected void info(String string) {
        this.env.info(this.messageFactory.getMessage(string));
    }

    protected void info(String string, String string2) {
        this.env.info(this.messageFactory.getMessage(string, string2));
    }

    protected static void fail(String string) {
        throw new GeneratorException(string);
    }

    protected static void fail(String string, String string2) {
        throw new GeneratorException(string, string2);
    }

    protected static void fail(String string, String string2, String string3) {
        throw new GeneratorException(string, new Object[]{string2, string3});
    }

    protected static void fail(Localizable localizable) {
        throw new GeneratorException("generator.nestedGeneratorError", localizable);
    }

    protected static void fail(Throwable throwable) {
        throw new GeneratorException("generator.nestedGeneratorError", new LocalizableExceptionAdapter(throwable));
    }
}

