/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.naming;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.xml.rpc.Service;

public class ServiceReferenceResolver
implements ObjectFactory {
    protected static final Map registeredServices = Collections.synchronizedMap(new HashMap());

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        if (object instanceof StringRefAddr) {
            StringRefAddr stringRefAddr = (StringRefAddr)object;
            if (stringRefAddr.getType() == "ServiceName") {
                return registeredServices.get(stringRefAddr.getContent());
            }
            if (stringRefAddr.getType() == "ServiceClassName") {
                Object object2 = stringRefAddr.getContent();
                Object object3 = registeredServices.get(object2);
                if (object3 == null) {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    object3 = Class.forName((String)stringRefAddr.getContent(), true, classLoader).newInstance();
                    registeredServices.put(object2, object3);
                }
                return object3;
            }
        }
        return null;
    }

    public static String registerService(Service service) {
        String string = ServiceReferenceResolver.getQualifiedServiceNameString(service);
        registeredServices.put(string, service);
        return string;
    }

    protected static String getQualifiedServiceNameString(Service service) {
        String string = "";
        URL uRL = service.getWSDLDocumentLocation();
        if (uRL != null) {
            string = string + uRL.toExternalForm() + ":";
        }
        string = string + service.getServiceName().toString();
        return string;
    }

    public Reference getServiceClassReference(Class clazz) {
        return this.getServiceClassReference(clazz.getName());
    }

    public Reference getServiceClassReference(String string) {
        Reference reference = new Reference(string, "com.sun.xml.rpc.naming.ServiceReferenceResolver", null);
        reference.add(new StringRefAddr("ServiceClassName", string));
        return reference;
    }
}

