/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.PolymorphicArraySerializer;
import com.sun.xml.rpc.encoding.ReferenceableSerializerImpl;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.encoding.SerializerConstants;
import com.sun.xml.rpc.encoding.TypeMappingException;
import com.sun.xml.rpc.encoding.ValueTypeSerializer;
import com.sun.xml.rpc.encoding.literal.LiteralFragmentSerializer;
import com.sun.xml.rpc.encoding.soap.SOAPConstants;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.beans.Introspector;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.Deserializer;
import javax.xml.rpc.encoding.Serializer;

public class DynamicInternalTypeMappingRegistry
implements InternalTypeMappingRegistry,
SerializerConstants {
    protected static final QName ELEMENT_NAME = new QName("element");
    protected InternalTypeMappingRegistry registry = null;
    static /* synthetic */ Class class$java$rmi$Remote;

    public DynamicInternalTypeMappingRegistry(InternalTypeMappingRegistry internalTypeMappingRegistry) {
        if (internalTypeMappingRegistry == null) {
            throw new IllegalArgumentException("registry must not be null");
        }
        this.registry = internalTypeMappingRegistry;
    }

    public Serializer getSerializer(String string, Class clazz, QName qName) throws Exception {
        try {
            return this.registry.getSerializer(string, clazz, qName);
        }
        catch (TypeMappingException typeMappingException) {
            try {
                if (string.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
                    if (DynamicInternalTypeMappingRegistry.isArray(clazz, qName)) {
                        return this.createArraySerializer(clazz, qName);
                    }
                    if (DynamicInternalTypeMappingRegistry.isValueType(clazz)) {
                        return this.createValueSerializer(clazz, qName);
                    }
                } else if (string.equals("")) {
                    return this.createLiteralSerializer(qName);
                }
                throw typeMappingException;
            }
            catch (JAXRPCExceptionBase jAXRPCExceptionBase) {
                throw new SerializationException(jAXRPCExceptionBase);
            }
            catch (Exception exception) {
                throw new SerializationException(new LocalizableExceptionAdapter(exception));
            }
        }
    }

    public Deserializer getDeserializer(String string, Class clazz, QName qName) throws Exception {
        try {
            return this.registry.getDeserializer(string, clazz, qName);
        }
        catch (TypeMappingException typeMappingException) {
            try {
                if (string.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
                    if (DynamicInternalTypeMappingRegistry.isArray(clazz, qName)) {
                        return this.createArraySerializer(clazz, qName);
                    }
                    return this.createValueSerializer(clazz, qName);
                }
                if (string.equals("")) {
                    return this.createLiteralSerializer(qName);
                }
                throw typeMappingException;
            }
            catch (JAXRPCExceptionBase jAXRPCExceptionBase) {
                throw new SerializationException(jAXRPCExceptionBase);
            }
            catch (Exception exception) {
                throw new SerializationException(new LocalizableExceptionAdapter(exception));
            }
        }
    }

    private ReferenceableSerializerImpl createArraySerializer(Class clazz, QName qName) throws Exception {
        if (clazz == null || qName == null) {
            return null;
        }
        ReferenceableSerializerImpl referenceableSerializerImpl = new ReferenceableSerializerImpl(false, new PolymorphicArraySerializer(qName, false, true, "http://schemas.xmlsoap.org/soap/encoding/", ELEMENT_NAME));
        referenceableSerializerImpl.initialize(this.registry);
        return referenceableSerializerImpl;
    }

    private ReferenceableSerializerImpl createValueSerializer(Class clazz, QName qName) throws Exception {
        if (clazz == null || qName == null) {
            return null;
        }
        ReferenceableSerializerImpl referenceableSerializerImpl = new ReferenceableSerializerImpl(false, new ValueTypeSerializer(qName, false, true, "http://schemas.xmlsoap.org/soap/encoding/", clazz));
        referenceableSerializerImpl.initialize(this.registry);
        return referenceableSerializerImpl;
    }

    private ReferenceableSerializerImpl createLiteralSerializer(QName qName) throws Exception {
        if (qName == null) {
            return null;
        }
        ReferenceableSerializerImpl referenceableSerializerImpl = new ReferenceableSerializerImpl(false, new LiteralFragmentSerializer(qName, true, ""));
        referenceableSerializerImpl.initialize(this.registry);
        return referenceableSerializerImpl;
    }

    public Serializer getSerializer(String string, Class clazz) throws Exception {
        return this.registry.getSerializer(string, clazz);
    }

    public Serializer getSerializer(String string, QName qName) throws Exception {
        return this.registry.getSerializer(string, qName);
    }

    public Deserializer getDeserializer(String string, QName qName) throws Exception {
        return this.registry.getDeserializer(string, qName);
    }

    public Class getJavaType(String string, QName qName) throws Exception {
        return this.registry.getJavaType(string, qName);
    }

    public QName getXmlType(String string, Class clazz) throws Exception {
        return this.registry.getXmlType(string, clazz);
    }

    public static boolean isArray(Class clazz, QName qName) {
        return clazz != null && clazz.isArray() && SOAPConstants.QNAME_ENCODING_ARRAY.equals(qName);
    }

    public static boolean isValueType(Class clazz) throws Exception {
        if (clazz == null || (class$java$rmi$Remote == null ? (class$java$rmi$Remote = DynamicInternalTypeMappingRegistry.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(clazz)) {
            return false;
        }
        boolean bl = false;
        Constructor<?>[] constructorArray = clazz.getConstructors();
        int n = 0;
        while (n < constructorArray.length) {
            if (constructorArray[n].getParameterTypes().length == 0) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            return false;
        }
        boolean bl2 = false;
        if (Introspector.getBeanInfo(clazz).getPropertyDescriptors().length == 0) {
            Field[] fieldArray = clazz.getFields();
            int n2 = 0;
            while (n2 < fieldArray.length) {
                Field field = fieldArray[n2];
                int n3 = field.getModifiers();
                if (Modifier.isPublic(n3) && !Modifier.isTransient(n3) && !Modifier.isFinal(n3)) {
                    bl2 = true;
                    break;
                }
                ++n2;
            }
        } else {
            bl2 = true;
        }
        return bl2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

