/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client.dii;

import com.sun.xml.rpc.client.dii.OperationInfo;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;

public class PortInfo {
    Map operationMap;
    String targetEndpoint;
    String defaultNamespace;
    QName name;
    QName portTypeName;

    public PortInfo(QName qName) {
        this.init();
        this.name = qName;
    }

    protected void init() {
        this.operationMap = new HashMap();
        this.targetEndpoint = "";
        this.defaultNamespace = "";
    }

    public QName getName() {
        return this.name;
    }

    public OperationInfo createOperationForName(String string) {
        OperationInfo operationInfo = (OperationInfo)this.operationMap.get(string);
        if (operationInfo == null) {
            operationInfo = new OperationInfo(string);
            operationInfo.setNamespace(this.defaultNamespace);
            this.operationMap.put(string, operationInfo);
        }
        return operationInfo;
    }

    public void setPortTypeName(QName qName) {
        this.portTypeName = qName;
    }

    public QName getPortTypeName() {
        return this.portTypeName;
    }

    public void setDefaultNamespace(String string) {
        this.defaultNamespace = string;
    }

    public boolean isOperationKnown(String string) {
        return this.operationMap.get(string) != null;
    }

    public String getTargetEndpoint() {
        return this.targetEndpoint;
    }

    public void setTargetEndpoint(String string) {
        this.targetEndpoint = string;
    }

    public Iterator getOperations() {
        return this.operationMap.values().iterator();
    }

    public int getOperationCount() {
        return this.operationMap.values().size();
    }
}

