/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import java.io.File;
import java.io.IOException;
import org.exolab.castor.util.Configuration;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.reader.SaxUnmarshaller;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshaller;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshallerState;
import org.xml.sax.AttributeList;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class ImportUnmarshaller
extends SaxUnmarshaller {
    private static final String HTTP_PROTOCOL = "http://";
    private static final String FILE_PROTOCOL = "file://";

    public ImportUnmarshaller(Schema schema, AttributeList attributeList, Resolver resolver, Locator locator) throws SAXException {
        this(schema, attributeList, resolver, locator, null);
    }

    public ImportUnmarshaller(Schema schema, AttributeList attributeList, Resolver resolver, Locator locator, SchemaUnmarshallerState schemaUnmarshallerState) throws SAXException {
        String string;
        this.setResolver(resolver);
        String string2 = attributeList.getValue("schemaLocation");
        if (string2 == null) {
            throw new SAXException("'schemaLocation' attribute missing on 'import'");
        }
        String string3 = string2;
        if (string3.startsWith(FILE_PROTOCOL)) {
            string3 = string3.substring(7);
            if (File.separatorChar == '\\') {
                string3 = string3.substring(1);
            }
        }
        if (!string3.startsWith(HTTP_PROTOCOL) && !new File(string3).isAbsolute() && (string = locator.getSystemId()) != null) {
            if (string2.startsWith("./")) {
                string2 = string2.substring(2);
            }
            if (string2.startsWith("/")) {
                string2 = string2.substring(1);
            }
            string = string.substring(7);
            if (File.separatorChar == '\\') {
                string = string.substring(1);
            }
            string = string.substring(0, string.lastIndexOf(47) + 1);
            string2 = string + string2;
            string = null;
        }
        if ((string = attributeList.getValue("namespace")) == null) {
            throw new SAXException("'namespace' attribute missing on 'import'");
        }
        if (!schema.isKnownNamespace(string)) {
            throw new SAXException("namespace '" + string + "' not declared in schema");
        }
        if (string.equals(schema.getTargetNamespace())) {
            throw new SAXException("the 'namespace' attribute in the <import> element cannot be the same of the targetNamespace of the global schema");
        }
        boolean bl = false;
        Schema schema2 = schema.getImportedSchema(string);
        if (schemaUnmarshallerState.processed(string2)) {
            if (schema2 == null) {
                schema.addImportedSchema(schemaUnmarshallerState.getSchema(string2));
            }
            return;
        }
        if (schema2 == null) {
            schema2 = new Schema();
            bl = true;
        }
        schemaUnmarshallerState.markAsProcessed(string2, schema2);
        Parser parser = null;
        try {
            parser = Configuration.getParser();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (parser == null) {
            throw new SAXException("Error failed to create parser for import");
        }
        SchemaUnmarshaller schemaUnmarshaller = new SchemaUnmarshaller(schemaUnmarshallerState);
        schemaUnmarshaller.setSchema(schema2);
        parser.setDocumentHandler(schemaUnmarshaller);
        parser.setErrorHandler(schemaUnmarshaller);
        try {
            parser.parse(new InputSource(string2));
        }
        catch (IOException iOException) {
            throw new SAXException("Error reading import file '" + string2 + "': " + iOException);
        }
        if (bl) {
            schema2.setSchemaLocation(string2);
            schema.addImportedSchema(schema2);
        }
    }

    public String elementName() {
        return "import";
    }

    public Object getObject() {
        return null;
    }
}

