/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.exolab.castor.types.GMonthDay;
import org.exolab.castor.types.OperationNotSupportedException;

public class GDay
extends GMonthDay {
    private static final String DAY_FORMAT = "---dd";

    public GDay() {
    }

    public GDay(short s) {
        this.setDay(s);
    }

    public GDay(int n) {
        this.setDay((short)n);
    }

    public Date toDate() {
        Date date = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DAY_FORMAT);
        if (this.isUTC()) {
            SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, "UTC");
            int n = 0;
            n = (this.getZoneMinute() + this.getZoneHour() * 60) * 60 * 1000;
            n = this.isZoneNegative() ? -n : n;
            simpleTimeZone.setRawOffset(n);
            simpleTimeZone.setID(TimeZone.getAvailableIDs(n)[0]);
            simpleDateFormat.setTimeZone(simpleTimeZone);
        }
        try {
            date = simpleDateFormat.parse(this.toString());
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return null;
        }
        return date;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('-');
        stringBuffer.append('-');
        stringBuffer.append('-');
        stringBuffer.append(this.getDay());
        if (stringBuffer.length() == 4) {
            stringBuffer.insert(3, 0);
        }
        if (this.isUTC()) {
            if (this.getZoneHour() == 0 && this.getZoneMinute() == 0) {
                stringBuffer.append('Z');
            } else {
                StringBuffer stringBuffer2 = new StringBuffer();
                if (this.isZoneNegative()) {
                    stringBuffer2.append('-');
                } else {
                    stringBuffer2.append('+');
                }
                if (this.getZoneHour() / 10 == 0) {
                    stringBuffer2.append(0);
                }
                stringBuffer2.append(this.getZoneHour());
                stringBuffer2.append(':');
                if (this.getZoneMinute() / 10 == 0) {
                    stringBuffer2.append(0);
                }
                stringBuffer2.append(this.getZoneMinute());
                stringBuffer.append(stringBuffer2.toString());
                stringBuffer2 = null;
            }
        }
        return stringBuffer.toString();
    }

    public static Object parse(String string) throws ParseException {
        return GDay.parseGDay(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GDay parseGDay(String string) throws ParseException {
        if (string == null) {
            throw new IllegalArgumentException("The string to be parsed must not be null.");
        }
        GDay gDay = new GDay();
        char[] cArray = string.toCharArray();
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = -1;
        int n3 = 0;
        int n4 = 31;
        while (n < cArray.length) {
            char c = cArray[n++];
            switch (c) {
                case '-': {
                    if (n4 == 31 && n2 == -1) {
                        n4 = 15;
                    } else if (n4 == 15 && n2 == -1) {
                        n4 = 7;
                    } else if (n4 == 7 && n2 == -1) {
                        n4 = 3;
                    } else {
                        if (n4 != 3) throw new ParseException("Bad gDay Format:" + string + "\nA gDay must follow the pattern ---DD(Z|((+|-)hh:mm)).", n);
                        if (!bl2) throw new ParseException("Bad gDay Format:" + string + "\nThe day field must have 2 digits.", n);
                        gDay.setDay((short)n2);
                        n4 = 1;
                        gDay.setUTC();
                        gDay.setZoneNegative();
                        n2 = -1;
                    }
                    bl = false;
                    bl2 = false;
                    break;
                }
                case 'Z': {
                    if (n4 != 3) {
                        throw new ParseException("Bad gDay Format:" + string + "\n'Z' is wrongly placed", n);
                    }
                    gDay.setUTC();
                    break;
                }
                case '+': {
                    if (n4 != 3) {
                        throw new ParseException("Bad gDay Format:" + string + "\n'+' is wrongly placed", n);
                    }
                    if (!bl2) throw new ParseException("Bad gDay Format:" + string + "\nThe day field must have 2 digits.", n);
                    gDay.setDay((short)n2);
                    gDay.setUTC();
                    n4 = 1;
                    bl = false;
                    bl2 = false;
                    break;
                }
                case ':': {
                    if (n4 != 1) {
                        throw new ParseException("Bad gDay Format:" + string + "\n':' is wrongly placed", n);
                    }
                    n3 = n2;
                    n2 = -1;
                    n4 = 0;
                    bl = false;
                    bl2 = false;
                    break;
                }
                default: {
                    if ('0' > c || c > '9') throw new ParseException(string + ": Invalid character: " + c, n);
                    if (bl) {
                        n2 = (short)(n2 * 10 + (c - 48));
                        bl2 = true;
                        break;
                    }
                    bl = true;
                    n2 = (short)(c - 48);
                    break;
                }
            }
        }
        if (n4 != 3 && n4 != 0) {
            throw new ParseException("Bad gDay Format: " + string + "\nA gDay must follow the pattern ---DD(Z|((+|-)hh:mm)).", n);
        }
        if (n4 == 3) {
            if (!bl2) throw new ParseException("Bad gDay Format:" + string + "\nThe day field must have 2 digits.", n);
            gDay.setDay((short)n2);
            return gDay;
        } else {
            if (n4 != 0) return gDay;
            if (n2 == -1) throw new ParseException(string + "\n In a time zone, the minute field must always be present.", n);
            gDay.setZone((short)n3, (short)n2);
        }
        return gDay;
    }

    public short getMonth() {
        String string = "GDay: couldn't access to the Month field.";
        throw new OperationNotSupportedException(string);
    }

    public void setMonth(short s) {
        String string = "GDay: couldn't access to the Month field.";
        throw new OperationNotSupportedException(string);
    }
}

