/*
 * Decompiled with CFR 0.152.
 */
package com.sun.activation.registries;

public class MailcapTokenizer {
    public static final int UNKNOWN_TOKEN = 0;
    public static final int START_TOKEN = 1;
    public static final int STRING_TOKEN = 2;
    public static final int EOI_TOKEN = 5;
    public static final int SLASH_TOKEN = 47;
    public static final int SEMICOLON_TOKEN = 59;
    public static final int EQUALS_TOKEN = 61;
    private String data;
    private int dataIndex;
    private int dataLength;
    private int currentToken;
    private String currentTokenValue;
    private boolean isAutoquoting;
    private char autoquoteChar;

    public MailcapTokenizer(String string) {
        this.data = string;
        this.dataIndex = 0;
        this.dataLength = string.length();
        this.currentToken = 1;
        this.currentTokenValue = "";
        this.isAutoquoting = false;
        this.autoquoteChar = (char)59;
    }

    public void setIsAutoquoting(boolean bl) {
        this.isAutoquoting = bl;
    }

    public void setAutoquoteChar(char c) {
        this.autoquoteChar = c;
    }

    public int getCurrentToken() {
        return this.currentToken;
    }

    public static String nameForToken(int n) {
        String string = "really unknown";
        switch (n) {
            case 0: {
                string = "unknown";
                break;
            }
            case 1: {
                string = "start";
                break;
            }
            case 2: {
                string = "string";
                break;
            }
            case 5: {
                string = "EOI";
                break;
            }
            case 47: {
                string = "'/'";
                break;
            }
            case 59: {
                string = "';'";
                break;
            }
            case 61: {
                string = "'='";
            }
        }
        return string;
    }

    public String getCurrentTokenValue() {
        return this.currentTokenValue;
    }

    public int nextToken() {
        if (this.dataIndex < this.dataLength) {
            while (this.dataIndex < this.dataLength && MailcapTokenizer.isWhiteSpaceChar(this.data.charAt(this.dataIndex))) {
                ++this.dataIndex;
            }
            if (this.dataIndex < this.dataLength) {
                char c = this.data.charAt(this.dataIndex);
                if (this.isAutoquoting) {
                    if (!MailcapTokenizer.isAutoquoteSpecialChar(c)) {
                        this.processAutoquoteToken();
                    } else if (c == ';' || c == '=') {
                        this.currentToken = c;
                        this.currentTokenValue = new Character(c).toString();
                        ++this.dataIndex;
                    } else {
                        this.currentToken = 0;
                        this.currentTokenValue = new Character(c).toString();
                        ++this.dataIndex;
                    }
                } else if (MailcapTokenizer.isStringTokenChar(c)) {
                    this.processStringToken();
                } else if (c == '/' || c == ';' || c == '=') {
                    this.currentToken = c;
                    this.currentTokenValue = new Character(c).toString();
                    ++this.dataIndex;
                } else {
                    this.currentToken = 0;
                    this.currentTokenValue = new Character(c).toString();
                    ++this.dataIndex;
                }
            } else {
                this.currentToken = 5;
                this.currentTokenValue = null;
            }
        } else {
            this.currentToken = 5;
            this.currentTokenValue = null;
        }
        return this.currentToken;
    }

    private void processStringToken() {
        int n = this.dataIndex;
        while (this.dataIndex < this.dataLength && MailcapTokenizer.isStringTokenChar(this.data.charAt(this.dataIndex))) {
            ++this.dataIndex;
        }
        this.currentToken = 2;
        this.currentTokenValue = this.data.substring(n, this.dataIndex);
    }

    private void processAutoquoteToken() {
        int n = this.dataIndex;
        boolean bl = false;
        while (this.dataIndex < this.dataLength && !bl) {
            char c = this.data.charAt(this.dataIndex);
            if (c != this.autoquoteChar) {
                ++this.dataIndex;
                continue;
            }
            bl = true;
        }
        this.currentToken = 2;
        this.currentTokenValue = MailcapTokenizer.fixEscapeSequences(this.data.substring(n, this.dataIndex));
    }

    public static boolean isSpecialChar(char c) {
        boolean bl = false;
        switch (c) {
            case '\"': 
            case '(': 
            case ')': 
            case ',': 
            case '/': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '[': 
            case '\\': 
            case ']': {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean isAutoquoteSpecialChar(char c) {
        boolean bl = false;
        switch (c) {
            case ';': 
            case '=': {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean isControlChar(char c) {
        return Character.isISOControl(c);
    }

    public static boolean isWhiteSpaceChar(char c) {
        return Character.isWhitespace(c);
    }

    public static boolean isStringTokenChar(char c) {
        return !MailcapTokenizer.isSpecialChar(c) && !MailcapTokenizer.isControlChar(c) && !MailcapTokenizer.isWhiteSpaceChar(c);
    }

    private static String fixEscapeSequences(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.ensureCapacity(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c != '\\') {
                stringBuffer.append(c);
            } else if (n2 < n - 1) {
                char c2 = string.charAt(n2 + 1);
                stringBuffer.append(c2);
                ++n2;
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }
}

