/*
 * Decompiled with CFR 0.152.
 */
package samples.connectors.simple;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import samples.connectors.simple.CometConnectionFactory;
import samples.connectors.simple.CometManagedConnection;
import samples.connectors.simple.Debug;
import samples.connectors.simple.Messages;
import samples.connectors.simple.Util;

public class CometManagedConnectionFactory
implements ManagedConnectionFactory,
Serializable {
    private transient PrintWriter out;
    private transient PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private String host = null;
    private String port = null;

    public CometManagedConnectionFactory() {
        System.out.println(" 1. In CometManagedConnectionFactory ctor");
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public Object createConnectionFactory() throws ResourceException {
        System.out.println("createConnectionFactory 2 ");
        return new CometConnectionFactory(this, null);
    }

    public Object createConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        System.out.println("createConnectionFactory 1 this" + this);
        CometConnectionFactory cometConnectionFactory = null;
        try {
            cometConnectionFactory = new CometConnectionFactory(this, connectionManager);
        }
        catch (Exception exception) {
            throw new ResourceException(exception.getMessage());
        }
        return cometConnectionFactory;
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        System.out.println(" -- In CometManagedConnectionFactory:: createManagedConnection");
        String string = null;
        CometManagedConnection cometManagedConnection = null;
        PasswordCredential passwordCredential = Util.getPasswordCredential(this, subject, connectionRequestInfo);
        if (passwordCredential != null) {
            string = passwordCredential.getUserName();
        }
        if (!(cometManagedConnection = new CometManagedConnection(this, string)).connect(this.host, this.port)) {
            System.out.println(" -- Connect to backend FAIL !!!");
            Object[] objectArray = new Object[]{this.host, this.port};
            throw new ResourceException(MessageFormat.format(Messages.getMessage("10"), objectArray), "10");
        }
        return cometManagedConnection;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object instanceof CometManagedConnectionFactory) {
            String string = ((CometManagedConnectionFactory)object).host;
            String string2 = this.host;
            String string3 = ((CometManagedConnectionFactory)object).port;
            String string4 = this.port;
            bl = Util.isEqual(string, string2) && Util.isEqual(string3, string4);
        }
        return bl;
    }

    public String getHost() {
        return this.host;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.out;
    }

    public String getPort() {
        return this.port;
    }

    public int hashCode() {
        int n = 0;
        if (this.host != null && this.port != null) {
            n = this.host.hashCode() + this.port.hashCode();
        }
        return n;
    }

    public ManagedConnection matchManagedConnections(Set set, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        PasswordCredential passwordCredential = Util.getPasswordCredential(this, subject, connectionRequestInfo);
        String string = null;
        if (passwordCredential != null) {
            string = passwordCredential.getUserName();
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof CometManagedConnection)) continue;
            CometManagedConnection cometManagedConnection = (CometManagedConnection)e;
            ManagedConnectionFactory managedConnectionFactory = cometManagedConnection.getManagedConnectionFactory();
            if (!Util.isEqual(cometManagedConnection.getUserName(), string) || !managedConnectionFactory.equals((Object)this)) continue;
            Debug.printDebug("In matchManagedConnections mc=" + cometManagedConnection);
            return cometManagedConnection;
        }
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        System.out.println("Before readObject mcf");
        objectInputStream.defaultReadObject();
        this.changes = new PropertyChangeSupport(this);
        this.out = null;
        System.out.println("after readObject mcf");
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public void setHost(String string) {
        String string2 = this.host;
        this.host = string;
        this.changes.firePropertyChange("host", string2, string);
    }

    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        this.out = printWriter;
    }

    public void setPort(String string) {
        String string2 = this.port;
        this.port = string;
        this.changes.firePropertyChange("port", string2, string);
    }
}

