/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.mozilla.jss.util.Assert;

public class Base64OutputStream
extends FilterOutputStream {
    private static final char[] encoding = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private byte[] input = new byte[3];
    private short inputCount = 0;
    private short charsOnLine = 0;
    private int charsPerLine;
    private static final int DEFAULT_QUADS_PER_LINE = 16;
    private boolean doLineBreaks = false;

    public Base64OutputStream(PrintStream printStream) {
        super(printStream);
    }

    public Base64OutputStream(PrintStream printStream, int n) {
        this(printStream);
        this.doLineBreaks = true;
        Assert.assert(n > 0, "quadsPerLine must be > 0");
        this.charsPerLine = n * 4;
    }

    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    public void flush() throws IOException {
        if (this.inputCount > 0) {
            this.outputOneAtom();
        }
        if (this.doLineBreaks) {
            ((PrintStream)this.out).println();
            this.charsOnLine = 0;
        }
    }

    private void outputOneAtom() throws IOException {
        byte[] byArray = new byte[4];
        if (this.inputCount == 0) {
            return;
        }
        if (this.inputCount < 3) {
            this.input[2] = 0;
            if (this.inputCount < 2) {
                this.input[1] = 0;
            }
        }
        byArray[0] = (byte)encoding[this.input[0] >>> 2 & 0x3F];
        byArray[1] = (byte)encoding[this.input[0] << 4 & 0x30 | this.input[1] >>> 4 & 0xF];
        byArray[2] = (byte)encoding[this.input[1] << 2 & 0x3C | this.input[2] >>> 6 & 3];
        byArray[3] = (byte)encoding[this.input[2] & 0x3F];
        if (this.inputCount < 3) {
            byArray[3] = 61;
            if (this.inputCount < 2) {
                byArray[2] = 61;
            }
        }
        this.out.write(byArray);
        this.inputCount = 0;
        if (this.doLineBreaks) {
            this.charsOnLine = (short)(this.charsOnLine + 4);
        }
    }

    public void write(int n) throws IOException {
        short s = this.inputCount;
        this.inputCount = (short)(s + 1);
        this.input[s] = (byte)(0xFF & n);
        if (this.inputCount == 3) {
            this.outputOneAtom();
            if (this.doLineBreaks) {
                if (this.charsOnLine == this.charsPerLine) {
                    ((PrintStream)this.out).println();
                    this.charsOnLine = 0;
                }
                Assert.assert(this.charsOnLine < this.charsPerLine);
            }
        }
        Assert.assert(this.inputCount < 3);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n;
        int n4 = 0;
        while (n4 < n2) {
            this.write(byArray[n3]);
            ++n3;
            ++n4;
        }
    }
}

