/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.crmf;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.CHOICE;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.GeneralizedTime;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.asn1.TimeBase;
import org.mozilla.jss.asn1.UTCTime;
import org.mozilla.jss.pkix.cert.Extension;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.Name;
import org.mozilla.jss.pkix.primitive.SubjectPublicKeyInfo;

public class CertTemplate
implements ASN1Value {
    private INTEGER version;
    private INTEGER serialNumber;
    private AlgorithmIdentifier signingAlg;
    private Name issuer;
    private Date notBefore;
    private Date notAfter;
    private Name subject;
    private SubjectPublicKeyInfo publicKey;
    private BIT_STRING issuerUID;
    private BIT_STRING subjectUID;
    private SEQUENCE extensions;
    public static final Tag TAG = SEQUENCE.TAG;
    static final int UTCTIME_CUTOFF_YEAR = 2049;
    private static Template templateInstance = new Template();

    CertTemplate() {
    }

    private static TimeBase dateToASN1(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTime(date);
        if (calendar.get(1) <= 2049) {
            return new UTCTime(date);
        }
        return new GeneralizedTime(date);
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(TAG, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addElement(Tag.get(0L), this.version);
        sEQUENCE.addElement(Tag.get(1L), this.serialNumber);
        sEQUENCE.addElement(Tag.get(2L), this.signingAlg);
        if (this.issuer != null) {
            sEQUENCE.addElement(new EXPLICIT(Tag.get(3L), this.issuer));
        }
        if (this.notBefore != null || this.notAfter != null) {
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            if (this.notBefore != null) {
                sEQUENCE2.addElement(new EXPLICIT(Tag.get(0L), CertTemplate.dateToASN1(this.notBefore)));
            }
            if (this.notAfter != null) {
                sEQUENCE2.addElement(new EXPLICIT(Tag.get(1L), CertTemplate.dateToASN1(this.notAfter)));
            }
            sEQUENCE.addElement(Tag.get(4L), sEQUENCE2);
        }
        if (this.subject != null) {
            sEQUENCE.addElement(new EXPLICIT(Tag.get(5L), this.subject));
        }
        sEQUENCE.addElement(Tag.get(6L), this.publicKey);
        sEQUENCE.addElement(Tag.get(7L), this.issuerUID);
        sEQUENCE.addElement(Tag.get(8L), this.subjectUID);
        sEQUENCE.addElement(Tag.get(9L), this.extensions);
        sEQUENCE.encode(tag, outputStream);
    }

    public Extension extensionAt(int n) {
        if (this.extensions == null) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return (Extension)this.extensions.elementAt(n);
    }

    public Name getIssuer() {
        return this.issuer;
    }

    public BIT_STRING getIssuerUID() {
        return this.issuerUID;
    }

    public Date getNotAfter() {
        return this.notAfter;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public SubjectPublicKeyInfo getPublicKey() {
        return this.publicKey;
    }

    public INTEGER getSerialNumber() {
        return this.serialNumber;
    }

    public AlgorithmIdentifier getSigningAlg() {
        return this.signingAlg;
    }

    public Name getSubject() {
        return this.subject;
    }

    public BIT_STRING getSubjectUID() {
        return this.subjectUID;
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public INTEGER getVersion() {
        return this.version;
    }

    public boolean hasExtensions() {
        return this.extensions != null;
    }

    public boolean hasIssuer() {
        return this.issuer != null;
    }

    public boolean hasIssuerUID() {
        return this.issuerUID != null;
    }

    public boolean hasNotAfter() {
        return this.notAfter != null;
    }

    public boolean hasNotBefore() {
        return this.notBefore != null;
    }

    public boolean hasPublicKey() {
        return this.publicKey != null;
    }

    public boolean hasSerialNumber() {
        return this.serialNumber != null;
    }

    public boolean hasSigningAlg() {
        return this.signingAlg != null;
    }

    public boolean hasSubject() {
        return this.subject != null;
    }

    public boolean hasSubjectUID() {
        return this.subjectUID != null;
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public static void main(String[] stringArray) {
        try {
            CertTemplate certTemplate = new CertTemplate();
            certTemplate.setVersion(new INTEGER(5L));
            certTemplate.setSerialNumber(new INTEGER(13112L));
            Name name = new Name();
            name.addCommonName("You");
            name.addStateOrProvinceName("California");
            certTemplate.setIssuer(name);
            certTemplate.setNotBefore(new Date());
            name = new Name();
            name.addCommonName("Me");
            name.addCountryName("US");
            certTemplate.setSubject(name);
            byte[] byArray = new byte[2];
            byArray[1] = 1;
            certTemplate.setIssuerUID(new BIT_STRING(byArray, 0));
            System.out.println("Constructed CertTemplate:");
            byte[] byArray2 = ASN1Util.encode(certTemplate);
            FileOutputStream fileOutputStream = new FileOutputStream("certTemplate");
            fileOutputStream.write(byArray2);
            fileOutputStream.close();
            certTemplate.print(System.out, 0);
            CertTemplate certTemplate2 = (CertTemplate)ASN1Util.decode(CertTemplate.getTemplate(), byArray2);
            System.out.println("\nDecoded CertTemplate:");
            certTemplate2.print(System.out, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int numExtensions() {
        if (this.extensions == null) {
            return 0;
        }
        return this.extensions.size();
    }

    public void print(PrintStream printStream, int n) throws InvalidBERException, IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(" ");
            ++n2;
        }
        String string = stringBuffer.toString();
        if (this.version != null) {
            printStream.println("Version: " + this.version.toString());
        }
        if (this.serialNumber != null) {
            printStream.println("Serial Number: " + this.serialNumber.toString());
        }
        if (this.signingAlg != null) {
            printStream.println("Signing Algorithm: " + this.signingAlg.getOID().toString());
        }
        if (this.issuer != null) {
            printStream.println("Issuer: " + this.issuer.getRFC1485());
        }
        if (this.notBefore != null) {
            printStream.println("Not Before: " + this.notBefore);
        }
        if (this.notAfter != null) {
            printStream.println("Not After: " + this.notAfter);
        }
        if (this.subject != null) {
            printStream.println("Subject: " + this.subject.getRFC1485());
        }
        if (this.publicKey != null) {
            printStream.println("publicKey is present");
        }
        if (this.issuerUID != null) {
            printStream.println("issuerUID is present");
        }
        if (this.subjectUID != null) {
            printStream.println("subjectUID is present");
        }
        if (this.extensions != null) {
            printStream.println("Extensions is present, with " + this.extensions.size() + " elements");
        }
    }

    public void setExtensions(SEQUENCE sEQUENCE) {
        this.extensions = sEQUENCE;
    }

    public void setIssuer(Name name) {
        this.issuer = name;
    }

    public void setIssuerUID(BIT_STRING bIT_STRING) {
        this.issuerUID = bIT_STRING;
    }

    public void setNotAfter(Date date) {
        this.notAfter = date;
    }

    public void setNotBefore(Date date) {
        this.notBefore = date;
    }

    public void setPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.publicKey = subjectPublicKeyInfo;
    }

    public void setSerialNumber(INTEGER iNTEGER) {
        this.serialNumber = iNTEGER;
    }

    public void setSigningAlg(AlgorithmIdentifier algorithmIdentifier) {
        this.signingAlg = algorithmIdentifier;
    }

    public void setSubject(Name name) {
        this.subject = name;
    }

    public void setSubjectUID(BIT_STRING bIT_STRING) {
        this.subjectUID = bIT_STRING;
    }

    public void setVersion(INTEGER iNTEGER) {
        this.version = iNTEGER;
    }

    public static class Template
    implements ASN1Template {
        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            CHOICE.Template template = new CHOICE.Template();
            template.addElement(new GeneralizedTime.Template());
            template.addElement(new UTCTime.Template());
            SEQUENCE.Template template2 = new SEQUENCE.Template();
            template2.addOptionalElement(new EXPLICIT.Template(Tag.get(0L), template));
            template2.addOptionalElement(new EXPLICIT.Template(Tag.get(1L), template));
            SEQUENCE.Template template3 = new SEQUENCE.Template();
            template3.addOptionalElement(Tag.get(0L), new INTEGER.Template());
            template3.addOptionalElement(Tag.get(1L), new INTEGER.Template());
            template3.addOptionalElement(Tag.get(2L), new AlgorithmIdentifier.Template());
            template3.addOptionalElement(new EXPLICIT.Template(Tag.get(3L), new Name.Template()));
            template3.addOptionalElement(Tag.get(4L), template2);
            template3.addOptionalElement(new EXPLICIT.Template(Tag.get(5L), new Name.Template()));
            template3.addOptionalElement(Tag.get(6L), new SubjectPublicKeyInfo.Template());
            template3.addOptionalElement(Tag.get(7L), new BIT_STRING.Template());
            template3.addOptionalElement(Tag.get(8L), new BIT_STRING.Template());
            template3.addOptionalElement(Tag.get(9L), new SEQUENCE.OF_Template(new Extension.Template()));
            SEQUENCE sEQUENCE = (SEQUENCE)template3.decode(tag, inputStream);
            CertTemplate certTemplate = new CertTemplate();
            certTemplate.setVersion((INTEGER)sEQUENCE.elementAt(0));
            certTemplate.setSerialNumber((INTEGER)sEQUENCE.elementAt(1));
            certTemplate.setSigningAlg((AlgorithmIdentifier)sEQUENCE.elementAt(2));
            if (sEQUENCE.elementAt(3) != null) {
                certTemplate.setIssuer((Name)((EXPLICIT)sEQUENCE.elementAt(3)).getContent());
            }
            if (sEQUENCE.elementAt(4) != null) {
                CHOICE cHOICE;
                ASN1Value aSN1Value;
                EXPLICIT eXPLICIT = (EXPLICIT)((SEQUENCE)sEQUENCE.elementAt(4)).elementAt(0);
                if (eXPLICIT != null && (aSN1Value = (cHOICE = (CHOICE)eXPLICIT.getContent()).getValue()) instanceof TimeBase) {
                    certTemplate.setNotBefore(((TimeBase)aSN1Value).toDate());
                }
                if ((eXPLICIT = (EXPLICIT)((SEQUENCE)sEQUENCE.elementAt(4)).elementAt(1)) != null && (aSN1Value = (cHOICE = (CHOICE)eXPLICIT.getContent()).getValue()) instanceof TimeBase) {
                    certTemplate.setNotAfter(((TimeBase)aSN1Value).toDate());
                }
            }
            if (sEQUENCE.elementAt(5) != null) {
                certTemplate.setSubject((Name)((EXPLICIT)sEQUENCE.elementAt(5)).getContent());
            }
            certTemplate.setPublicKey((SubjectPublicKeyInfo)sEQUENCE.elementAt(6));
            certTemplate.setIssuerUID((BIT_STRING)sEQUENCE.elementAt(7));
            certTemplate.setSubjectUID((BIT_STRING)sEQUENCE.elementAt(8));
            certTemplate.setExtensions((SEQUENCE)sEQUENCE.elementAt(9));
            return certTemplate;
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }
    }
}

