/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.crmf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.text.DateFormat;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.crypto.InvalidKeyFormatException;
import org.mozilla.jss.crypto.Signature;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkix.crmf.CertRequest;
import org.mozilla.jss.pkix.crmf.CertTemplate;
import org.mozilla.jss.pkix.crmf.ChallengeResponseException;
import org.mozilla.jss.pkix.crmf.POPOPrivKey;
import org.mozilla.jss.pkix.crmf.POPOSigningKey;
import org.mozilla.jss.pkix.crmf.ProofOfPossession;
import org.mozilla.jss.pkix.primitive.AVA;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.SubjectPublicKeyInfo;
import org.mozilla.jss.util.Assert;

public class CertReqMsg
implements ASN1Value {
    public static final Tag TAG = SEQUENCE.TAG;
    private CertRequest certReq;
    private SEQUENCE regInfo;
    private ProofOfPossession pop = null;
    private static final Template templateInstance = new Template();

    private CertReqMsg() {
    }

    public CertReqMsg(CertRequest certRequest, ProofOfPossession proofOfPossession, SEQUENCE sEQUENCE) {
        this.certReq = certRequest;
        this.pop = proofOfPossession;
        this.regInfo = sEQUENCE;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(this.getTag(), outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addElement(this.certReq);
        if (this.pop != null) {
            sEQUENCE.addElement(this.pop);
        }
        if (this.regInfo != null) {
            sEQUENCE.addElement(this.regInfo);
        }
        sEQUENCE.encode(tag, outputStream);
    }

    public CertRequest getCertReq() {
        return this.certReq;
    }

    public ProofOfPossession getPop() {
        Assert.assert(this.pop != null);
        return this.pop;
    }

    public SEQUENCE getRegInfo() {
        Assert.assert(this.regInfo != null);
        return this.regInfo;
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public boolean hasPop() {
        return this.pop != null;
    }

    public boolean hasRegInfo() {
        return this.regInfo != null;
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length < 1) {
                System.err.println("Give an arg");
                System.exit(0);
            }
            FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
            SEQUENCE.OF_Template oF_Template = new SEQUENCE.OF_Template(new Template());
            SET sET = null;
            byte[] byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            int n = 0;
            while (n < 1) {
                sET = (SEQUENCE)oF_Template.decode(new ByteArrayInputStream(byArray));
                ++n;
            }
            System.out.println("Decoded " + sET.size() + " messages");
            CertReqMsg certReqMsg = (CertReqMsg)sET.elementAt(0);
            CertRequest certRequest = certReqMsg.getCertReq();
            System.out.println("Request ID: " + certRequest.getCertReqId());
            CertTemplate certTemplate = certRequest.getCertTemplate();
            if (certTemplate.hasVersion()) {
                System.out.println("Version: " + certTemplate.getVersion());
            } else {
                System.out.println("No version");
            }
            if (certTemplate.hasSerialNumber()) {
                System.out.println("Serial Number: " + certTemplate.getSerialNumber());
            } else {
                System.out.println("No serial number");
            }
            if (certTemplate.hasSigningAlg()) {
                System.out.println("SigningAlg: " + certTemplate.getSigningAlg().getOID());
            } else {
                System.out.println("No signing alg");
            }
            if (certTemplate.hasIssuer()) {
                System.out.println("Issuer: " + certTemplate.getIssuer().getRFC1485());
            } else {
                System.out.println("No issuer");
            }
            if (certTemplate.hasSubject()) {
                System.out.println("Subject: " + certTemplate.getSubject().getRFC1485());
            } else {
                System.out.println("No subject: ");
            }
            if (certTemplate.hasPublicKey()) {
                System.out.println("Public Key: " + certTemplate.getPublicKey().getAlgorithmIdentifier().getOID());
            } else {
                System.out.println("No public key");
            }
            if (certTemplate.hasIssuerUID()) {
                System.out.println("Issuer UID: " + new BigInteger(certTemplate.getIssuerUID().getBits()));
            } else {
                System.out.println("no issuer uid");
            }
            if (certTemplate.hasSubjectUID()) {
                System.out.println("Subject UID: " + new BigInteger(certTemplate.getIssuerUID().getBits()));
            } else {
                System.out.println("no subject uid");
            }
            if (certTemplate.hasNotBefore()) {
                System.out.println("Not Before: " + DateFormat.getInstance().format(certTemplate.getNotBefore()));
            }
            if (certTemplate.hasNotAfter()) {
                System.out.println("Not After: " + DateFormat.getInstance().format(certTemplate.getNotAfter()));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void verify() throws SignatureException, InvalidKeyFormatException, NoSuchAlgorithmException, CryptoManager.NotInitializedException, TokenException, InvalidKeyException, IOException {
        POPOPrivKey pOPOPrivKey;
        POPOPrivKey.Type type;
        ProofOfPossession.Type type2 = this.pop.getType();
        if (type2 == ProofOfPossession.SIGNATURE) {
            Object object;
            POPOSigningKey pOPOSigningKey = this.pop.getSignature();
            AlgorithmIdentifier algorithmIdentifier = pOPOSigningKey.getAlgorithmIdentifier();
            BIT_STRING bIT_STRING = pOPOSigningKey.getSignature();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.certReq.encode(byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            PublicKey publicKey = null;
            CertTemplate certTemplate = this.certReq.getCertTemplate();
            if (certTemplate.hasPublicKey()) {
                object = certTemplate.getPublicKey();
                publicKey = ((SubjectPublicKeyInfo)object).toPublicKey();
            }
            object = CryptoManager.getInstance().getInternalCryptoToken();
            SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.fromOID(algorithmIdentifier.getOID());
            Signature signature = object.getSignatureContext(signatureAlgorithm);
            signature.initVerify(publicKey);
            signature.update(byArray);
            if (signature.verify(bIT_STRING.getBits())) {
                return;
            }
            throw new SignatureException("Signed request information does not match signature in POP");
        }
        if (type2 == ProofOfPossession.KEY_ENCIPHERMENT && (type = (pOPOPrivKey = this.pop.getKeyEncipherment()).getType()) != POPOPrivKey.THIS_MESSAGE && type == POPOPrivKey.SUBSEQUENT_MESSAGE) {
            new ChallengeResponseException("requested");
        }
    }

    public static class Template
    implements ASN1Template {
        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            SEQUENCE.Template template = new SEQUENCE.Template();
            template.addElement(new CertRequest.Template());
            template.addOptionalElement(new ProofOfPossession.Template());
            template.addOptionalElement(new SEQUENCE.OF_Template(new AVA.Template()));
            SEQUENCE sEQUENCE = (SEQUENCE)template.decode(tag, inputStream);
            return new CertReqMsg((CertRequest)sEQUENCE.elementAt(0), (ProofOfPossession)sEQUENCE.elementAt(1), (SEQUENCE)sEQUENCE.elementAt(2));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }
    }
}

