/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cert;

import java.io.IOException;
import java.io.InputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BOOLEAN;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cert.Extension;
import org.mozilla.jss.util.Assert;

public class SubjectKeyIdentifier
extends Extension {
    private OCTET_STRING keyIdentifier;
    private static OBJECT_IDENTIFIER OID = new OBJECT_IDENTIFIER("2.5.29.14");

    public SubjectKeyIdentifier(OCTET_STRING oCTET_STRING) {
        super(OID, false, oCTET_STRING);
    }

    public SubjectKeyIdentifier(boolean bl, OCTET_STRING oCTET_STRING) {
        super(OID, bl, oCTET_STRING);
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(OBJECT_IDENTIFIER.getTemplate());
            this.seqt.addElement(BOOLEAN.getTemplate(), new BOOLEAN(false));
            this.seqt.addElement(OCTET_STRING.getTemplate());
        }

        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(Extension.TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            Assert.assert(((OBJECT_IDENTIFIER)sEQUENCE.elementAt(0)).equals(OID));
            return new SubjectKeyIdentifier(((BOOLEAN)sEQUENCE.elementAt(1)).toBoolean(), (OCTET_STRING)sEQUENCE.elementAt(2));
        }

        public boolean tagMatch(Tag tag) {
            return Extension.TAG.equals(tag);
        }
    }
}

