/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.naming.ContextAccessController;
import org.apache.naming.StringManager;

public class ContextBindings {
    private static Hashtable contextNameBindings = new Hashtable();
    private static Hashtable threadBindings = new Hashtable();
    private static Hashtable threadNameBindings = new Hashtable();
    private static Hashtable clBindings = new Hashtable();
    private static Hashtable clNameBindings = new Hashtable();
    protected static StringManager sm = StringManager.getManager("org.apache.naming");

    public static void bindContext(Object object, Context context) {
        ContextBindings.bindContext(object, context, null);
    }

    public static void bindContext(Object object, Context context, Object object2) {
        if (ContextAccessController.checkSecurityToken(object, object2)) {
            contextNameBindings.put(object, context);
        }
    }

    public static void unbindContext(Object object) {
        ContextBindings.unbindContext(object, null);
    }

    public static void unbindContext(Object object, Object object2) {
        if (ContextAccessController.checkSecurityToken(object, object2)) {
            contextNameBindings.remove(object);
        }
    }

    static Context getContext(Object object) {
        return (Context)contextNameBindings.get(object);
    }

    public static void bindThread(Object object) throws NamingException {
        ContextBindings.bindThread(object, null);
    }

    public static void bindThread(Object object, Object object2) throws NamingException {
        if (ContextAccessController.checkSecurityToken(object, object2)) {
            Context context = (Context)contextNameBindings.get(object);
            if (context == null) {
                throw new NamingException(sm.getString("contextBindings.unknownContext", object));
            }
            threadBindings.put(Thread.currentThread(), context);
            threadNameBindings.put(Thread.currentThread(), object);
        }
    }

    public static void unbindThread(Object object) {
        ContextBindings.unbindThread(object, null);
    }

    public static void unbindThread(Object object, Object object2) {
        if (ContextAccessController.checkSecurityToken(object, object2)) {
            threadBindings.remove(Thread.currentThread());
            threadNameBindings.remove(Thread.currentThread());
        }
    }

    public static Context getThread() throws NamingException {
        Context context = (Context)threadBindings.get(Thread.currentThread());
        if (context == null) {
            throw new NamingException(sm.getString("contextBindings.noContextBoundToThread"));
        }
        return context;
    }

    static Object getThreadName() throws NamingException {
        Object v = threadNameBindings.get(Thread.currentThread());
        if (v == null) {
            throw new NamingException(sm.getString("contextBindings.noContextBoundToThread"));
        }
        return v;
    }

    public static boolean isThreadBound() {
        return threadBindings.containsKey(Thread.currentThread());
    }

    public static void bindClassLoader(Object object) throws NamingException {
        ContextBindings.bindClassLoader(object, null);
    }

    public static void bindClassLoader(Object object, Object object2) throws NamingException {
        ContextBindings.bindClassLoader(object, object2, Thread.currentThread().getContextClassLoader());
    }

    public static void bindClassLoader(Object object, Object object2, ClassLoader classLoader) throws NamingException {
        if (ContextAccessController.checkSecurityToken(object, object2)) {
            Context context = (Context)contextNameBindings.get(object);
            if (context == null) {
                throw new NamingException(sm.getString("contextBindings.unknownContext", object));
            }
            clBindings.put(classLoader, context);
            clNameBindings.put(classLoader, object);
        }
    }

    public static void unbindClassLoader(Object object) {
        ContextBindings.unbindClassLoader(object, null);
    }

    public static void unbindClassLoader(Object object, Object object2) {
        if (ContextAccessController.checkSecurityToken(object, object2)) {
            clBindings.remove(Thread.currentThread().getContextClassLoader());
            clNameBindings.remove(Thread.currentThread().getContextClassLoader());
        }
    }

    public static Context getClassLoader() throws NamingException {
        Context context = (Context)clBindings.get(Thread.currentThread().getContextClassLoader());
        if (context == null) {
            throw new NamingException(sm.getString("contextBindings.noContextBoundToCL"));
        }
        return context;
    }

    static Object getClassLoaderName() throws NamingException {
        Object v = clNameBindings.get(Thread.currentThread().getContextClassLoader());
        if (v == null) {
            throw new NamingException(sm.getString("contextBindings.noContextBoundToCL"));
        }
        return v;
    }

    public static boolean isClassLoaderBound() {
        return clBindings.containsKey(Thread.currentThread().getContextClassLoader());
    }
}

