/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Stack;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.JspParseEventListener;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.ParseEventListener;
import org.apache.jasper.compiler.ParseException;
import org.apache.jasper.compiler.Parser;
import org.apache.jasper.compiler.ParserXJspSax;
import org.xml.sax.Attributes;

public class ParserController {
    private JspCompilationContext ctxt;
    private Stack baseDirStack = new Stack();
    private HashSet fileSet = new HashSet();
    private ParseEventListener jspHandler = null;
    private boolean isXml;
    private static final String JSP_ROOT_TAG = "<jsp:root";
    private static final String JSP_PAGEDIRECTIVE_TAG = "<jsp:directive.page";
    private boolean isTopFile = true;
    private String topFileEncoding = "ISO-8859-1";
    private String newEncoding;

    public ParserController(JspCompilationContext jspCompilationContext) {
        this.ctxt = jspCompilationContext;
        this.jspHandler = new JspParseEventListener(jspCompilationContext, this);
    }

    public ParseEventListener getParseEventListener() {
        return this.jspHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(String string) throws FileNotFoundException, JasperException {
        String string2 = this.resolveFileName(string);
        if (this.fileSet.contains(string2)) {
            throw new ParseException(Constants.getString("jsp.error.file.already.registered", new Object[]{string}));
        }
        this.fileSet.add(string2);
        String string3 = this.topFileEncoding;
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = this.getReader(string2, string3);
            this.figureOutJspDocument(string2, string3, inputStreamReader);
            String string4 = string3 = this.newEncoding != null ? this.newEncoding : string3;
            if (this.isTopFile) {
                this.topFileEncoding = string3;
                this.isTopFile = false;
            }
            try {
                inputStreamReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            inputStreamReader = this.getReader(string2, string3);
            this.jspHandler.setDefault(this.isXml);
            if (this.isXml) {
                new ParserXJspSax(string2, inputStreamReader, this.jspHandler).parse();
            } else {
                new Parser(this.ctxt, string2, string3, inputStreamReader, this.jspHandler).parse();
            }
            this.baseDirStack.pop();
        }
        finally {
            this.fileSet.remove(string2);
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void figureOutJspDocument(String string, String string2, InputStreamReader inputStreamReader) throws JasperException {
        JspReader jspReader;
        try {
            jspReader = new JspReader(this.ctxt, string, string2, inputStreamReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new JasperException(fileNotFoundException);
        }
        jspReader.setSingleFile(true);
        Mark mark = jspReader.mark();
        jspReader.reset(mark);
        Mark mark2 = jspReader.skipUntil(JSP_ROOT_TAG);
        this.isXml = mark2 != null;
        this.newEncoding = null;
        if (!this.isXml) {
            jspReader.reset(mark);
            while (jspReader.skipUntil("<%@") != null) {
                jspReader.skipSpaces();
                if (!jspReader.matches("page")) continue;
                jspReader.advance(4);
                jspReader.skipSpaces();
                Attributes attributes = jspReader.parseTagAttributes();
                String string3 = "pageEncoding";
                this.newEncoding = attributes.getValue("pageEncoding");
                if (this.newEncoding == null) {
                    int n;
                    String string4 = attributes.getValue("contentType");
                    if (string4 == null || (n = string4.indexOf("charset=")) == -1) continue;
                    this.newEncoding = string4.substring(n + 8);
                    return;
                }
                return;
            }
        } else {
            jspReader.reset(mark);
            while (jspReader.skipUntil(JSP_PAGEDIRECTIVE_TAG) != null) {
                jspReader.skipSpaces();
                Attributes attributes = jspReader.parseTagAttributes();
                this.newEncoding = attributes.getValue("pageEncoding");
                if (this.newEncoding == null) {
                    int n;
                    String string5 = attributes.getValue("contentType");
                    if (string5 == null || (n = string5.indexOf("charset=")) == -1) continue;
                    this.newEncoding = string5.substring(n + 8);
                    return;
                }
                return;
            }
        }
    }

    private String resolveFileName(String string) {
        String string2 = string.replace('\\', '/');
        boolean bl = string2.startsWith("/");
        string2 = bl ? string2 : (String)this.baseDirStack.peek() + string2;
        String string3 = string2.substring(0, string2.lastIndexOf("/") + 1);
        this.baseDirStack.push(string3);
        return string2;
    }

    private InputStreamReader getReader(String string, String string2) throws FileNotFoundException, JasperException {
        try {
            InputStream inputStream = this.ctxt.getResourceAsStream(string);
            if (inputStream == null) {
                throw new FileNotFoundException(string);
            }
            return new InputStreamReader(inputStream, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new JasperException(Constants.getString("jsp.error.unsupported.encoding", new Object[]{string2}));
        }
    }

    private void p(String string) {
        System.out.println("[ParserController] " + string);
    }

    private void p(String string, Throwable throwable) {
        this.p(string);
        this.p(throwable.getMessage());
        throwable.printStackTrace();
    }
}

