/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.util.HashMap;
import javax.naming.directory.DirContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.ApplicationParameter;
import org.apache.catalina.deploy.ContextEjb;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ResourceParams;
import org.apache.catalina.util.StringManager;

public class DefaultContext {
    private String[] applicationListeners = new String[0];
    private ApplicationParameter[] applicationParameters = new ApplicationParameter[0];
    private boolean cookies = true;
    private boolean crossContext = true;
    private HashMap ejbs = new HashMap();
    private HashMap envs = new HashMap();
    private static final String info = "org.apache.catalina.core.DefaultContext/1.0";
    private String[] instanceListeners = new String[0];
    private String mapperClass = "org.apache.catalina.core.StandardContextMapper";
    private HashMap parameters = new HashMap();
    private boolean reloadable = false;
    private HashMap resourceEnvRefs = new HashMap();
    private HashMap resources = new HashMap();
    private HashMap resourceParams = new HashMap();
    private String[] wrapperLifecycles = new String[0];
    private String[] wrapperListeners = new String[0];
    private String wrapperClass = "org.apache.catalina.core.StandardWrapper";
    private boolean useNaming = true;
    DirContext dirContext = null;
    protected String name = "defaultContext";
    protected Container parent = null;
    protected Loader loader = null;
    protected Manager manager = null;
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.core");

    public boolean isUseNaming() {
        return this.useNaming;
    }

    public void setUseNaming(boolean bl) {
        this.useNaming = bl;
    }

    public boolean getCookies() {
        return this.cookies;
    }

    public void setCookies(boolean bl) {
        boolean bl2 = this.cookies;
        this.cookies = bl;
    }

    public boolean getCrossContext() {
        return this.crossContext;
    }

    public void setCrossContext(boolean bl) {
        boolean bl2 = this.crossContext;
        this.crossContext = bl;
    }

    public String getInfo() {
        return info;
    }

    public boolean getReloadable() {
        return this.reloadable;
    }

    public void setReloadable(boolean bl) {
        boolean bl2 = this.reloadable;
        this.reloadable = bl;
    }

    public String getWrapperClass() {
        return this.wrapperClass;
    }

    public void setWrapperClass(String string) {
        this.wrapperClass = string;
    }

    public void setResources(DirContext dirContext) {
        this.dirContext = dirContext;
    }

    public DirContext getResources() {
        return this.dirContext;
    }

    public Loader getLoader() {
        return this.loader;
    }

    public void setLoader(Loader loader) {
        this.loader = loader;
    }

    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Container getParent() {
        return this.parent;
    }

    public void setParent(Container container) {
        this.parent = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApplicationListener(String string) {
        String[] stringArray = this.applicationListeners;
        synchronized (this.applicationListeners) {
            String[] stringArray2 = new String[this.applicationListeners.length + 1];
            int n = 0;
            while (n < this.applicationListeners.length) {
                stringArray2[n] = this.applicationListeners[n];
                ++n;
            }
            stringArray2[this.applicationListeners.length] = string;
            this.applicationListeners = stringArray2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApplicationParameter(ApplicationParameter applicationParameter) {
        ApplicationParameter[] applicationParameterArray = this.applicationParameters;
        synchronized (this.applicationParameters) {
            ApplicationParameter[] applicationParameterArray2 = new ApplicationParameter[this.applicationParameters.length + 1];
            System.arraycopy(this.applicationParameters, 0, applicationParameterArray2, 0, this.applicationParameters.length);
            applicationParameterArray2[this.applicationParameters.length] = applicationParameter;
            this.applicationParameters = applicationParameterArray2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEjb(ContextEjb contextEjb) {
        HashMap hashMap = this.ejbs;
        synchronized (hashMap) {
            this.ejbs.put(contextEjb.getName(), contextEjb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEnvironment(ContextEnvironment contextEnvironment) {
        HashMap hashMap = this.envs;
        synchronized (hashMap) {
            this.envs.put(contextEnvironment.getName(), contextEnvironment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceParams(ResourceParams resourceParams) {
        HashMap hashMap = this.resourceParams;
        synchronized (hashMap) {
            this.resourceParams.put(resourceParams.getName(), resourceParams);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstanceListener(String string) {
        String[] stringArray = this.instanceListeners;
        synchronized (this.instanceListeners) {
            String[] stringArray2 = new String[this.instanceListeners.length + 1];
            int n = 0;
            while (n < this.instanceListeners.length) {
                stringArray2[n] = this.instanceListeners[n];
                ++n;
            }
            stringArray2[this.instanceListeners.length] = string;
            this.instanceListeners = stringArray2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParameter(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.parameter.required"));
        }
        if (this.parameters.get(string) != null) {
            throw new IllegalArgumentException(sm.getString("standardContext.parameter.duplicate", string));
        }
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            this.parameters.put(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResource(ContextResource contextResource) {
        HashMap hashMap = this.resources;
        synchronized (hashMap) {
            this.resources.put(contextResource.getName(), contextResource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceEnvRef(String string, String string2) {
        HashMap hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            this.resourceEnvRefs.put(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWrapperLifecycle(String string) {
        String[] stringArray = this.wrapperLifecycles;
        synchronized (this.wrapperLifecycles) {
            String[] stringArray2 = new String[this.wrapperLifecycles.length + 1];
            int n = 0;
            while (n < this.wrapperLifecycles.length) {
                stringArray2[n] = this.wrapperLifecycles[n];
                ++n;
            }
            stringArray2[this.wrapperLifecycles.length] = string;
            this.wrapperLifecycles = stringArray2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWrapperListener(String string) {
        String[] stringArray = this.wrapperListeners;
        synchronized (this.wrapperListeners) {
            String[] stringArray2 = new String[this.wrapperListeners.length + 1];
            int n = 0;
            while (n < this.wrapperListeners.length) {
                stringArray2[n] = this.wrapperListeners[n];
                ++n;
            }
            stringArray2[this.wrapperListeners.length] = string;
            this.wrapperListeners = stringArray2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public String[] findApplicationListeners() {
        return this.applicationListeners;
    }

    public ApplicationParameter[] findApplicationParameters() {
        return this.applicationParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEjb findEjb(String string) {
        HashMap hashMap = this.ejbs;
        synchronized (hashMap) {
            return (ContextEjb)this.ejbs.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEjb[] findEjbs() {
        HashMap hashMap = this.ejbs;
        synchronized (hashMap) {
            ContextEjb[] contextEjbArray = new ContextEjb[this.ejbs.size()];
            return this.ejbs.values().toArray(contextEjbArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEnvironment findEnvironment(String string) {
        HashMap hashMap = this.envs;
        synchronized (hashMap) {
            return (ContextEnvironment)this.envs.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEnvironment[] findEnvironments() {
        HashMap hashMap = this.envs;
        synchronized (hashMap) {
            ContextEnvironment[] contextEnvironmentArray = new ContextEnvironment[this.envs.size()];
            return this.envs.values().toArray(contextEnvironmentArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceParams[] findResourceParams() {
        HashMap hashMap = this.resourceParams;
        synchronized (hashMap) {
            ResourceParams[] resourceParamsArray = new ResourceParams[this.resourceParams.size()];
            return this.resourceParams.values().toArray(resourceParamsArray);
        }
    }

    public String[] findInstanceListeners() {
        return this.instanceListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findParameter(String string) {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            return (String)this.parameters.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findParameters() {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            String[] stringArray = new String[this.parameters.size()];
            return this.parameters.keySet().toArray(stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResource findResource(String string) {
        HashMap hashMap = this.resources;
        synchronized (hashMap) {
            return (ContextResource)this.resources.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findResourceEnvRef(String string) {
        HashMap hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            return (String)this.resourceEnvRefs.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findResourceEnvRefs() {
        HashMap hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            String[] stringArray = new String[this.resourceEnvRefs.size()];
            return this.resourceEnvRefs.keySet().toArray(stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResource[] findResources() {
        HashMap hashMap = this.resources;
        synchronized (hashMap) {
            ContextResource[] contextResourceArray = new ContextResource[this.resources.size()];
            return this.resources.values().toArray(contextResourceArray);
        }
    }

    public String[] findWrapperLifecycles() {
        return this.wrapperLifecycles;
    }

    public String[] findWrapperListeners() {
        return this.wrapperListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApplicationListener(String string) {
        String[] stringArray = this.applicationListeners;
        synchronized (this.applicationListeners) {
            int n = -1;
            int n2 = 0;
            while (n2 < this.applicationListeners.length) {
                if (this.applicationListeners[n2].equals(string)) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int n3 = 0;
            String[] stringArray2 = new String[this.applicationListeners.length - 1];
            int n4 = 0;
            while (n4 < this.applicationListeners.length) {
                if (n4 != n) {
                    stringArray2[n3++] = this.applicationListeners[n4];
                }
                ++n4;
            }
            this.applicationListeners = stringArray2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApplicationParameter(String string) {
        ApplicationParameter[] applicationParameterArray = this.applicationParameters;
        synchronized (this.applicationParameters) {
            int n = -1;
            int n2 = 0;
            while (n2 < this.applicationParameters.length) {
                if (string.equals(this.applicationParameters[n2].getName())) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int n3 = 0;
            ApplicationParameter[] applicationParameterArray2 = new ApplicationParameter[this.applicationParameters.length - 1];
            int n4 = 0;
            while (n4 < this.applicationParameters.length) {
                if (n4 != n) {
                    applicationParameterArray2[n3++] = this.applicationParameters[n4];
                }
                ++n4;
            }
            this.applicationParameters = applicationParameterArray2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEjb(String string) {
        HashMap hashMap = this.ejbs;
        synchronized (hashMap) {
            this.ejbs.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEnvironment(String string) {
        HashMap hashMap = this.envs;
        synchronized (hashMap) {
            this.envs.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstanceListener(String string) {
        String[] stringArray = this.instanceListeners;
        synchronized (this.instanceListeners) {
            int n = -1;
            int n2 = 0;
            while (n2 < this.instanceListeners.length) {
                if (this.instanceListeners[n2].equals(string)) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int n3 = 0;
            String[] stringArray2 = new String[this.instanceListeners.length - 1];
            int n4 = 0;
            while (n4 < this.instanceListeners.length) {
                if (n4 != n) {
                    stringArray2[n3++] = this.instanceListeners[n4];
                }
                ++n4;
            }
            this.instanceListeners = stringArray2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParameter(String string) {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            this.parameters.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResource(String string) {
        HashMap hashMap = this.resources;
        synchronized (hashMap) {
            this.resources.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResourceEnvRef(String string) {
        HashMap hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            this.resourceEnvRefs.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWrapperLifecycle(String string) {
        String[] stringArray = this.wrapperLifecycles;
        synchronized (this.wrapperLifecycles) {
            int n = -1;
            int n2 = 0;
            while (n2 < this.wrapperLifecycles.length) {
                if (this.wrapperLifecycles[n2].equals(string)) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int n3 = 0;
            String[] stringArray2 = new String[this.wrapperLifecycles.length - 1];
            int n4 = 0;
            while (n4 < this.wrapperLifecycles.length) {
                if (n4 != n) {
                    stringArray2[n3++] = this.wrapperLifecycles[n4];
                }
                ++n4;
            }
            this.wrapperLifecycles = stringArray2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWrapperListener(String string) {
        String[] stringArray = this.wrapperListeners;
        synchronized (this.wrapperListeners) {
            int n = -1;
            int n2 = 0;
            while (n2 < this.wrapperListeners.length) {
                if (this.wrapperListeners[n2].equals(string)) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int n3 = 0;
            String[] stringArray2 = new String[this.wrapperListeners.length - 1];
            int n4 = 0;
            while (n4 < this.wrapperListeners.length) {
                if (n4 != n) {
                    stringArray2[n3++] = this.wrapperListeners[n4];
                }
                ++n4;
            }
            this.wrapperListeners = stringArray2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void importDefaultContext(Context context) {
        int n;
        Object[] objectArray;
        if (context instanceof StandardContext) {
            ((StandardContext)context).setUseNaming(this.isUseNaming());
        }
        context.setCookies(this.getCookies());
        context.setCrossContext(this.getCrossContext());
        context.setReloadable(this.getReloadable());
        String[] stringArray = this.findApplicationListeners();
        int n2 = 0;
        while (n2 < stringArray.length) {
            context.addApplicationListener(stringArray[n2]);
            ++n2;
        }
        stringArray = this.findInstanceListeners();
        int n3 = 0;
        while (n3 < stringArray.length) {
            context.addInstanceListener(stringArray[n3]);
            ++n3;
        }
        String[] stringArray2 = this.findWrapperListeners();
        int n4 = 0;
        while (n4 < stringArray2.length) {
            context.addWrapperListener(stringArray2[n4]);
            ++n4;
        }
        stringArray2 = this.findWrapperLifecycles();
        int n5 = 0;
        while (n5 < stringArray2.length) {
            context.addWrapperLifecycle(stringArray2[n5]);
            ++n5;
        }
        String[] stringArray3 = this.findParameters();
        int n6 = 0;
        while (n6 < stringArray3.length) {
            context.addParameter(stringArray3[n6], this.findParameter(stringArray3[n6]));
            ++n6;
        }
        ApplicationParameter[] applicationParameterArray = this.findApplicationParameters();
        int n7 = 0;
        while (n7 < applicationParameterArray.length) {
            context.addApplicationParameter(applicationParameterArray[n7]);
            ++n7;
        }
        ContextEjb[] contextEjbArray = this.findEjbs();
        int n8 = 0;
        while (n8 < contextEjbArray.length) {
            context.addEjb(contextEjbArray[n8]);
            ++n8;
        }
        ContextEnvironment[] contextEnvironmentArray = this.findEnvironments();
        int n9 = 0;
        while (n9 < contextEnvironmentArray.length) {
            context.addEnvironment(contextEnvironmentArray[n9]);
            ++n9;
        }
        if (context instanceof StandardContext) {
            objectArray = this.findResourceParams();
            n = 0;
            while (n < objectArray.length) {
                ((StandardContext)context).addResourceParams((ResourceParams)objectArray[n]);
                ++n;
            }
        }
        objectArray = this.findResources();
        n = 0;
        while (n < objectArray.length) {
            context.addResource((ContextResource)objectArray[n]);
            ++n;
        }
        String[] stringArray4 = this.findResourceEnvRefs();
        int n10 = 0;
        while (n10 < stringArray4.length) {
            context.addResourceEnvRef(stringArray4[n10], this.findResourceEnvRef(stringArray4[n10]));
            ++n10;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getParent() != null) {
            stringBuffer.append(this.getParent().toString());
            stringBuffer.append(".");
        }
        stringBuffer.append("DefaultContext[");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

