/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster;

import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.Vector;
import org.apache.catalina.Cluster;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.cluster.ClusterMemberInfo;
import org.apache.catalina.cluster.ClusterReceiver;
import org.apache.catalina.cluster.ClusterSender;
import org.apache.catalina.cluster.MulticastReceiver;
import org.apache.catalina.cluster.MulticastSender;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;

public final class StandardCluster
implements Cluster,
Lifecycle,
Runnable {
    private static final String info = "StandardCluster/1.0";
    private String threadName = "StandardCluster";
    private String clusterImpName = "StandardCluster";
    private StringManager sm = StringManager.getManager("org.apache.catalina.cluster");
    private ClusterMemberInfo localClusterMember = null;
    private Vector clusterMembers = new Vector();
    private Thread thread = null;
    private boolean threadDone = false;
    private String clusterName = null;
    private Container container = null;
    private ClusterSender clusterSender = null;
    private ClusterReceiver clusterReceiver = null;
    private int multicastPort;
    private InetAddress multicastAddress = null;
    private MulticastSocket multicastSocket = null;
    private LifecycleSupport lifecycle = new LifecycleSupport(this);
    private boolean started = false;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private int debug = 0;
    private int checkInterval = 60;

    public String getInfo() {
        return info;
    }

    protected String getName() {
        return this.clusterImpName;
    }

    public void setDebug(int n) {
        this.debug = n;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setClusterName(String string) {
        String string2 = this.clusterName;
        this.clusterName = string;
        this.support.firePropertyChange("clusterName", string2, this.clusterName);
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setContainer(Container container) {
        Container container2 = this.container;
        this.container = container;
        this.support.firePropertyChange("container", container2, this.container);
    }

    public Container getContainer() {
        return this.container;
    }

    public void setMulticastPort(int n) {
        int n2 = this.multicastPort;
        this.multicastPort = n;
        this.support.firePropertyChange("multicastPort", n2, this.multicastPort);
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public void setMulticastAddress(String string) {
        try {
            InetAddress inetAddress = this.multicastAddress;
            this.multicastAddress = InetAddress.getByName(string);
            this.support.firePropertyChange("multicastAddress", inetAddress, this.multicastAddress);
        }
        catch (UnknownHostException unknownHostException) {
            this.log(this.sm.getString("standardCluster.invalidAddress", string));
        }
    }

    public InetAddress getMulticastAddress() {
        return this.multicastAddress;
    }

    public void setCheckInterval(int n) {
        int n2 = this.checkInterval;
        this.checkInterval = n;
        this.support.firePropertyChange("checkInterval", n2, this.checkInterval);
    }

    public int getCheckInterval() {
        return this.checkInterval;
    }

    public ClusterMemberInfo[] getRemoteClusterMembers() {
        return (ClusterMemberInfo[])this.clusterMembers.toArray();
    }

    public ClusterMemberInfo getLocalClusterMember() {
        return this.localClusterMember;
    }

    public ClusterSender getClusterSender(String string) {
        Logger logger = null;
        MulticastSender multicastSender = new MulticastSender(string, this.multicastSocket, this.multicastAddress, this.multicastPort);
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        multicastSender.setLogger(logger);
        multicastSender.setDebug(this.debug);
        if (this.debug > 1) {
            this.log(this.sm.getString("standardCluster.createSender", string));
        }
        return multicastSender;
    }

    public ClusterReceiver getClusterReceiver(String string) {
        Logger logger = null;
        MulticastReceiver multicastReceiver = new MulticastReceiver(string, this.multicastSocket, this.multicastAddress, this.multicastPort);
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        multicastReceiver.setDebug(this.debug);
        multicastReceiver.setLogger(logger);
        multicastReceiver.setCheckInterval(this.checkInterval);
        multicastReceiver.start();
        if (this.debug > 1) {
            this.log(this.sm.getString("standardCluster.createReceiver", string));
        }
        return multicastReceiver;
    }

    protected void log(String string) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log(this.getName() + "[" + this.container.getName() + "]: " + string);
        } else {
            String string2 = null;
            if (this.container != null) {
                string2 = this.container.getName();
            }
            System.out.println(this.getName() + "[" + string2 + "]: " + string);
        }
    }

    private void processReceive() {
        Object[] objectArray = this.clusterReceiver.getObjects();
        int n = 0;
        while (n < objectArray.length) {
            this.clusterMembers.add((ClusterMemberInfo)objectArray[n]);
            ++n;
        }
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.addLifecycleListener(lifecycleListener);
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.removeLifecycleListener(lifecycleListener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString("standardCluster.alreadyStarted"));
        }
        try {
            this.multicastSocket = new MulticastSocket(this.multicastPort);
            if (this.multicastSocket != null && this.multicastAddress != null) {
                this.multicastSocket.joinGroup(this.multicastAddress);
                this.clusterSender = this.getClusterSender(this.getName());
                this.clusterReceiver = this.getClusterReceiver(this.getName());
                this.localClusterMember = new ClusterMemberInfo();
                this.localClusterMember.setClusterName(this.getClusterName());
                this.localClusterMember.setHostName(null);
                this.localClusterMember.setClusterInfo(this.getInfo());
                this.clusterSender.send(this.localClusterMember);
                if (this.debug > 1) {
                    this.log(this.sm.getString("standardCluster.joinGroup", this.multicastAddress));
                }
            } else {
                this.log(this.sm.getString("standardCluster.socketOrAddressNull"));
            }
        }
        catch (IOException iOException) {
            this.log(this.sm.getString("standardCluster.joinException", iOException.toString()));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        this.threadStart();
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            this.log(this.sm.getString("standardCluster.notStarted"));
        }
        try {
            this.multicastSocket.leaveGroup(this.multicastAddress);
            this.multicastSocket = null;
        }
        catch (IOException iOException) {
            this.log(this.sm.getString("standardCluster.leaveException", this.multicastAddress));
        }
        if (this.debug > 1) {
            this.log(this.sm.getString("standardCluster.leaveGroup", this.multicastAddress));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.threadStop();
    }

    public void run() {
        while (!this.threadDone) {
            this.processReceive();
            this.threadSleep();
        }
    }

    private void threadSleep() {
        try {
            Thread.sleep((long)this.checkInterval * 1000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void threadStart() {
        if (this.thread != null) {
            return;
        }
        this.threadDone = false;
        this.threadName = "StandardCluster[" + this.getClusterName() + "]";
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }
}

