/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;

public class EntityBeanExtendsSerializableClass
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor ejbDescriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor componentNameConstructor = new ComponentNameConstructor(ejbDescriptor);
        if (ejbDescriptor instanceof EjbEntityDescriptor) {
            try {
                Context context = this.getVerifierContext();
                ClassLoader classLoader = context.getClassLoader();
                Class<?> clazz = classLoader.loadClass(ejbDescriptor.getEjbClassName());
                boolean bl = true;
                Class<?> clazz2 = clazz.getSuperclass();
                if (bl) {
                    if (!clazz2.getName().equals("java.lang.Object")) {
                        if (!EntityBeanExtendsSerializableClass.isValidSerializableType(clazz2)) {
                            bl = false;
                            result.addWarningDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                            result.addWarningDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed1", "[ {0} ] extends class [ {1} ] which is not serializable. ", new Object[]{ejbDescriptor.getEjbClassName(), clazz2.getName()}));
                            result.setStatus(2);
                            return result;
                        }
                        result.addGoodDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                        result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed1", "Bean [ {0} ] extends class [ {1} ] which is serializable. ", new Object[]{ejbDescriptor.getEjbClassName(), clazz2.getName()}));
                        block2: do {
                            Class<?>[] classArray = clazz.getInterfaces();
                            int n = 0;
                            while (n < classArray.length) {
                                if (this.debug) {
                                    System.out.println(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "Interface [ {0} ]", new Object[]{classArray[n].getName()}));
                                }
                                if (!EntityBeanExtendsSerializableClass.isValidSerializableType(classArray[n])) {
                                    bl = false;
                                    result.addWarningDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                                    result.addWarningDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "[ {0} ] implements interface [ {1} ] which is not serializable. ", new Object[]{ejbDescriptor.getEjbClassName(), classArray[n].getName()}));
                                    result.setStatus(2);
                                    continue block2;
                                }
                                ++n;
                            }
                        } while ((clazz = clazz.getSuperclass()) != null && bl);
                    }
                    if (bl) {
                        result.addGoodDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                        result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "Bean [ {0} ] implements interfaces which are all serializable. ", new Object[]{ejbDescriptor.getEjbClassName()}));
                        result.setStatus(0);
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                Verifier.debug(classNotFoundException);
                result.addErrorDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException", "Error: [ {0} ] class not found.", new Object[]{ejbDescriptor.getEjbClassName()}));
            }
            return result;
        }
        result.addNaDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
        result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return result;
    }

    public static boolean isValidSerializableType(Class clazz) {
        Class clazz2 = clazz;
        boolean bl = false;
        boolean bl2 = false;
        block0: do {
            bl = false;
            if (clazz.getName().equals("java.io.Serializable")) {
                bl = true;
                break;
            }
            Class<?>[] classArray = clazz2.getInterfaces();
            int n = 0;
            while (n < classArray.length) {
                if (classArray[n].getName().equals("java.io.Serializable")) {
                    bl = true;
                    continue block0;
                }
                Class<?> clazz3 = classArray[n];
                do {
                    if (clazz3.getName().equals("java.io.Serializable")) {
                        bl = true;
                        break;
                    }
                    if (!EntityBeanExtendsSerializableClass.isValidSerializableType(clazz3)) continue;
                    return true;
                } while (clazz3.getInterfaces().length != 0 && !bl);
                ++n;
            }
        } while ((clazz2 = clazz2.getSuperclass()) != null && !bl);
        return bl;
    }
}

