/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.gui;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.ResultMgr;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.VerifierEventsListener;
import com.sun.enterprise.tools.verifier.ejb.EjbCheckMgrImpl;
import com.sun.enterprise.tools.verifier.gui.ControlPanel;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class ResultsPanel
extends JPanel
implements VerifierEventsListener {
    JTable table;
    DefaultTableModel tableModel;
    JScrollPane tableScrollPane;
    JScrollPane textScrollPane;
    JTextArea detailText;
    Vector details = new Vector();
    private static Vector passResults = new Vector();
    private static Vector failResults = new Vector();
    private static Vector warnResults = new Vector();
    private static Vector naResults = new Vector();
    private static Vector notImplementedResults = new Vector();
    private static Vector notRunResults = new Vector();
    private static Vector defaultResults = new Vector();
    int tableIndex;
    static LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
    final String[] columnNames = new String[]{smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.columnName1", "Item"), smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.columnName2", "Test Name"), smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.columnName3", "Result")};
    static /* synthetic */ Class class$java$lang$Object;

    public ResultsPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.ResultsPanelLabel", "Results: (Click on Item to show test Details below)")));
        EjbCheckMgrImpl.addVerifierEventsListener(this);
        ResultMgr.addVerifierEventsListener(this);
        this.tableModel = new DefaultTableModel(this.columnNames, 0);
        this.table = new JTable(this.tableModel);
        this.table.setSelectionMode(0);
        this.tableScrollPane = new JScrollPane(this.table);
        this.sizeTableColumns();
        this.table.setDefaultEditor(class$java$lang$Object == null ? (class$java$lang$Object = ResultsPanel.class$("java.lang.Object")) : class$java$lang$Object, new DefaultCellEditor(new JTextField()){

            public boolean isCellEditable(EventObject eventObject) {
                return false;
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ResultsPanel.this.tableIndex = listSelectionEvent.getLastIndex() == ResultsPanel.this.tableIndex ? listSelectionEvent.getFirstIndex() : listSelectionEvent.getLastIndex();
                    ResultsPanel.this.setDetailText((String)ResultsPanel.this.details.elementAt(ResultsPanel.this.tableIndex));
                }
            }
        });
        this.detailText = new JTextArea(4, 50);
        this.detailText.setEditable(false);
        this.textScrollPane = new JScrollPane(this.detailText);
        this.textScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.DetailsPanelLabel", "Details:")));
        this.add("Center", this.tableScrollPane);
        this.add("South", this.textScrollPane);
        RadioListener radioListener = new RadioListener();
        ControlPanel.addRadioButtonListener(radioListener);
    }

    public void setDetailText(String string) {
        this.detailText.setText(string);
        JScrollBar jScrollBar = this.textScrollPane.getVerticalScrollBar();
        if (jScrollBar != null) {
            jScrollBar.setValue(0);
        }
    }

    public void addDetailText(String string) {
        this.detailText.append(string);
    }

    public void clearResults() {
        this.tableModel = new DefaultTableModel(this.columnNames, 0);
        this.table.setModel(this.tableModel);
        this.sizeTableColumns();
        this.setDetailText("");
        this.details = new Vector();
    }

    void sizeTableColumns() {
        this.table.getColumn(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.columnName1", "Item")).setMinWidth(150);
        this.table.getColumn(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.columnName1", "Item")).setMaxWidth(200);
        this.table.getColumn(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.columnName1", "Item")).setPreferredWidth(180);
        this.table.getColumn(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.columnName2", "Test Name")).setMinWidth(150);
        this.table.getColumn(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.columnName2", "Test Name")).setPreferredWidth(180);
        this.table.getColumn(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.columnName3", "Result")).setMinWidth(120);
        this.table.getColumn(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.columnName3", "Result")).setMaxWidth(200);
        this.table.getColumn(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.columnName3", "Result")).setPreferredWidth(160);
        this.table.setAutoResizeMode(4);
        this.table.sizeColumnsToFit(0);
    }

    private void upDateDisplayAll() {
        this.upDateDisplayFail();
        this.upDateDisplayWarn();
        this.upDateDisplayPass();
        this.upDateDisplayNa();
        this.upDateDisplayNotImplemented();
        this.upDateDisplayNotRun();
        this.upDateDisplayDefault();
    }

    private void updateTableRows(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            Enumeration enumeration;
            String string;
            Result result = (Result)vector.elementAt(n);
            String string2 = new String("");
            switch (result.getStatus()) {
                case 0: {
                    string = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_Passed", "Passed");
                    enumeration = result.getGoodDetails().elements();
                    break;
                }
                case 1: {
                    string = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_Failed", "FAILED");
                    enumeration = result.getErrorDetails().elements();
                    break;
                }
                case 2: {
                    string = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_Warning", "WARNING");
                    enumeration = result.getWarningDetails().elements();
                    break;
                }
                case 3: {
                    string = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_NotApplicable", "Not Applicable");
                    enumeration = result.getNaDetails().elements();
                    break;
                }
                case 5: {
                    string = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_NotImplemented", "Not Implemented");
                    enumeration = result.getNaDetails().elements();
                    break;
                }
                case 4: {
                    string = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_NotRun", "Not Run");
                    enumeration = result.getNaDetails().elements();
                    break;
                }
                default: {
                    string = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_Unknown", "Unknown");
                    enumeration = result.getNaDetails().elements();
                }
            }
            Object[] objectArray = new Object[]{result.getComponentName(), result.getTestName(), string};
            this.tableModel.addRow(objectArray);
            if (result.getStatus() == 0 || result.getStatus() == 1 || result.getStatus() == 2 || result.getStatus() == 5 || result.getStatus() == 3) {
                while (enumeration.hasMoreElements()) {
                    string2 = string2 + (String)enumeration.nextElement();
                    string2 = string2 + "\n";
                }
                this.details.add(string2);
            }
            this.table.sizeColumnsToFit(0);
            ++n;
        }
    }

    private void upDateDisplayPass() {
        this.updateTableRows(this.getPassResultsForDisplay());
    }

    private void upDateDisplayFail() {
        this.updateTableRows(this.getFailResultsForDisplay());
    }

    private void upDateDisplayWarn() {
        this.updateTableRows(this.getWarnResultsForDisplay());
    }

    private void upDateDisplayNa() {
        this.updateTableRows(this.getNaResultsForDisplay());
    }

    private void upDateDisplayNotImplemented() {
        this.updateTableRows(this.getNotImplementedResultsForDisplay());
    }

    private void upDateDisplayNotRun() {
        this.updateTableRows(this.getNotRunResultsForDisplay());
    }

    private void upDateDisplayDefault() {
        this.updateTableRows(this.getDefaultResultsForDisplay());
    }

    public void upDateDisplay(int n) {
        this.clearResults();
        if (n == 2) {
            this.upDateDisplayAll();
        }
        if (n == 0) {
            this.upDateDisplayFail();
        }
        if (n == 1) {
            this.upDateDisplayFail();
            this.upDateDisplayWarn();
        }
    }

    private void savePassResultsForDisplay(Result result) {
        passResults.addElement(result);
    }

    private void saveWarnResultsForDisplay(Result result) {
        warnResults.addElement(result);
    }

    private void saveFailResultsForDisplay(Result result) {
        failResults.addElement(result);
    }

    private void saveNaResultsForDisplay(Result result) {
        naResults.addElement(result);
    }

    private void saveNotRunResultsForDisplay(Result result) {
        notRunResults.addElement(result);
    }

    private void saveNotImplementedResultsForDisplay(Result result) {
        notImplementedResults.addElement(result);
    }

    private void saveDefaultResultsForDisplay(Result result) {
        defaultResults.addElement(result);
    }

    private Vector getPassResultsForDisplay() {
        return passResults;
    }

    private Vector getWarnResultsForDisplay() {
        return warnResults;
    }

    private Vector getFailResultsForDisplay() {
        return failResults;
    }

    private Vector getNaResultsForDisplay() {
        return naResults;
    }

    private Vector getNotImplementedResultsForDisplay() {
        return notImplementedResults;
    }

    private Vector getNotRunResultsForDisplay() {
        return notRunResults;
    }

    private Vector getDefaultResultsForDisplay() {
        return defaultResults;
    }

    public void clearOldResults() {
        passResults = new Vector();
        failResults = new Vector();
        warnResults = new Vector();
        naResults = new Vector();
        notImplementedResults = new Vector();
        notRunResults = new Vector();
        defaultResults = new Vector();
    }

    public void testFinished(EventObject eventObject) {
        Enumeration enumeration;
        String string;
        Result result = (Result)eventObject.getSource();
        switch (result.getStatus()) {
            case 0: {
                string = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_Passed", "Passed");
                this.savePassResultsForDisplay(result);
                break;
            }
            case 1: {
                string = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_Failed", "FAILED");
                this.saveFailResultsForDisplay(result);
                break;
            }
            case 2: {
                string = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_Warning", "WARNING");
                this.saveWarnResultsForDisplay(result);
                break;
            }
            case 3: {
                string = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_NotApplicable", "Not Applicable");
                this.saveNaResultsForDisplay(result);
                break;
            }
            case 5: {
                string = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_NotImplemented", "Not Implemented");
                this.saveNotImplementedResultsForDisplay(result);
                break;
            }
            case 4: {
                string = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_NotRun", "Not Run");
                this.saveNotRunResultsForDisplay(result);
                break;
            }
            default: {
                string = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_Unknown", "Unknown");
                this.saveDefaultResultsForDisplay(result);
            }
        }
        Object[] objectArray = new Object[]{result.getComponentName(), result.getTestName(), string};
        String string2 = new String("");
        if (Verifier.getReportLevel() == 0 && result.getStatus() == 1) {
            this.tableModel.addRow(objectArray);
            enumeration = result.getErrorDetails().elements();
            while (enumeration.hasMoreElements()) {
                string2 = string2 + (String)enumeration.nextElement();
                string2 = string2 + "\n";
            }
            this.details.add(string2);
        }
        if (Verifier.getReportLevel() == 1 && (result.getStatus() == 1 || result.getStatus() == 2)) {
            this.tableModel.addRow(objectArray);
            enumeration = result.getErrorDetails().elements();
            while (enumeration.hasMoreElements()) {
                string2 = string2 + (String)enumeration.nextElement();
                string2 = string2 + "\n";
            }
            enumeration = result.getWarningDetails().elements();
            while (enumeration.hasMoreElements()) {
                string2 = string2 + (String)enumeration.nextElement();
                string2 = string2 + "\n";
            }
            this.details.add(string2);
        }
        if (Verifier.getReportLevel() == 2) {
            this.tableModel.addRow(objectArray);
            enumeration = result.getErrorDetails().elements();
            while (enumeration.hasMoreElements()) {
                string2 = string2 + (String)enumeration.nextElement();
                string2 = string2 + "\n";
            }
            enumeration = result.getWarningDetails().elements();
            while (enumeration.hasMoreElements()) {
                string2 = string2 + (String)enumeration.nextElement();
                string2 = string2 + "\n";
            }
            enumeration = result.getGoodDetails().elements();
            while (enumeration.hasMoreElements()) {
                string2 = string2 + (String)enumeration.nextElement();
                string2 = string2 + "\n";
            }
            enumeration = result.getNaDetails().elements();
            while (enumeration.hasMoreElements()) {
                string2 = string2 + (String)enumeration.nextElement();
                string2 = string2 + "\n";
            }
            this.details.add(string2);
        }
        this.table.sizeColumnsToFit(0);
    }

    public void allTestsFinished(EventObject eventObject) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class RadioListener
    implements ActionListener {
        RadioListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == ControlPanel.allButton) {
                if (ResultsPanel.this.getPassResultsForDisplay().size() > 0 || ResultsPanel.this.getFailResultsForDisplay().size() > 0 || ResultsPanel.this.getWarnResultsForDisplay().size() > 0 || ResultsPanel.this.getNaResultsForDisplay().size() > 0 || ResultsPanel.this.getNotImplementedResultsForDisplay().size() > 0 || ResultsPanel.this.getNotRunResultsForDisplay().size() > 0 || ResultsPanel.this.getDefaultResultsForDisplay().size() > 0) {
                    ResultsPanel.this.upDateDisplay(2);
                } else {
                    ResultsPanel.this.clearResults();
                }
            }
            if (actionEvent.getSource() == ControlPanel.failButton) {
                if (ResultsPanel.this.getFailResultsForDisplay().size() > 0) {
                    ResultsPanel.this.upDateDisplay(0);
                } else {
                    ResultsPanel.this.clearResults();
                }
            }
            if (actionEvent.getSource() == ControlPanel.warnButton) {
                if (ResultsPanel.this.getFailResultsForDisplay().size() > 0 || ResultsPanel.this.getWarnResultsForDisplay().size() > 0) {
                    ResultsPanel.this.upDateDisplay(1);
                } else {
                    ResultsPanel.this.clearResults();
                }
            }
        }
    }
}

