/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.iplanet.ias.admin.monitor.MonitoringHelper;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.ElementProperty;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerBeansFactory;
import com.iplanet.ias.config.serverbeans.TransactionService;
import com.iplanet.ias.security.Audit;
import com.iplanet.ias.server.ApplicationServer;
import com.iplanet.ias.server.ServerContext;
import com.iplanet.ias.server.ServerContextImpl;
import com.iplanet.ias.transaction.monitor.JTSMonitorMBean;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.ejb.ContainerFactory;
import com.sun.ejb.containers.ContainerFactoryImpl;
import com.sun.ejb.sqlgen.DBInfoImpl;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.J2EESecurityManager;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.NamingManager;
import com.sun.enterprise.ProtocolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.appverification.factory.AppVerification;
import com.sun.enterprise.distributedtx.J2EETransactionManagerImpl;
import com.sun.enterprise.distributedtx.UserTransactionImpl;
import com.sun.enterprise.iiop.POAProtocolMgr;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.naming.NamingManagerImpl;
import com.sun.enterprise.naming.SerialContextProviderImpl;
import com.sun.enterprise.repository.Configuration;
import com.sun.enterprise.resource.IASConnectionManagerImpl;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.enterprise.resource.ResourcePoolManagerImpl;
import com.sun.enterprise.security.RealmManager;
import com.sun.enterprise.security.SSLUtils;
import com.sun.enterprise.server.ServerObject;
import com.sun.enterprise.server.ServerObjectImpl;
import com.sun.enterprise.tools.deployment.backend.JarManagerImpl;
import com.sun.enterprise.util.DebugController;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.InvocationManagerImpl;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.UniqueValueGeneratorBackendImpl;
import com.sun.enterprise.util.Utility;
import com.sun.jts.jta.TransactionManagerImpl;
import com.sun.logging.LogDomains;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.SecureRandom;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;

public final class J2EEServer {
    public static SecureRandom secureRandom = null;
    private static Logger _logger = null;
    public static final String J2EE_HOME = "com.sun.enterprise.home";
    public static final String J2EE_APPNAME = "com.sun.enterprise.appname";
    public static final String JTS_SERVER_ID = "com.sun.jts.persistentServerId";
    public static final String J2EE_SERVER_ID_PROP = "com.sun.enterprise.J2EEServerId";
    private static final boolean debug = false;
    private static LocalStringManagerImpl localStrings;
    private static PrintStream ostream;
    private static PrintStream estream;
    private static final int J2EE_SERVERID = 100;
    private static final int MAX_INITIAL_CONTEXT_RETRIES = 15;
    private static final String VERBOSE = "-verbose";
    private static final String HELP = "-help";
    private static final String VERSION = "-version";
    private static final String FULL_VERSION = "-fullversion";
    private static final String SINGLEVM = "-singleVM";
    private static final String MULTIVM = "-multiVM";
    private static final String DEBUG = "-debug";
    private static final String STOP = "-stop";
    private static final String NOJMS = "-noJMS";
    private static final String INSTRUMENT = "-instrument";
    private static final String DefaultDbDir = "orb.db";
    private static final String LISTEN_PROP = "com.sun.CORBA.connection.ORBListenSocket";
    private static final String DEFAULT_KEYSTORE_PROP;
    private static final String DEFAULT_KEYSTORE_NAME;
    private static final String SERVEROBJECT_NAME = "ServerObject";
    private static final String OUTPUT_LOG = "system.out";
    private static final String ERROR_LOG = "system.err";
    private File repositoryDir;
    private int orbInitialPort;
    private Configuration conf = null;
    private ORB orb;
    private ProtocolManager protocolMgr;
    private boolean shutdownStarted = false;
    private ServerContext serverContext;
    static /* synthetic */ Class class$com$sun$enterprise$server$J2EEServer;
    static /* synthetic */ Class class$com$sun$enterprise$server$ServerObject;

    private void run(String[] stringArray, boolean bl, boolean bl2) {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            String string;
            Object object5;
            if (this.serverContext != null && this.serverContext instanceof ServerContextImpl) {
                object5 = (ServerContextImpl)this.serverContext;
                string = ((ServerContextImpl)object5).getServerConfigPath() + File.separator + "secure.seed";
                object4 = new File(string);
                long l = this.readSecureSeed((File)object4);
                secureRandom.setSeed(l);
                l = secureRandom.nextLong();
                this.writeSecureSeed((File)object4, l);
                object4 = null;
            } else {
                _logger.log(Level.FINE, "Unable to initialize secure seed.");
            }
            object5 = System.getProperties();
            string = new Integer(100).toString();
            ((Properties)object5).setProperty(J2EE_SERVER_ID_PROP, string);
            ((Properties)object5).setProperty(J2EE_APPNAME, "j2ee");
            object4 = Switch.getSwitch();
            ((Switch)object4).setContainerType(2);
            try {
                this.orb = this.createORB(stringArray);
                try {
                    object3 = this.orb.resolve_initial_references("RootPOA");
                }
                catch (InvalidName invalidName) {
                    _logger.log(Level.SEVERE, "enterprise.orb_reference_exception", invalidName);
                }
            }
            catch (Exception exception) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "enterprise.createorb_exception", exception.toString());
                }
                throw new RuntimeException("Unable to create ORB");
            }
            this.protocolMgr = new POAProtocolMgr(this.orb);
            ((Switch)object4).setProtocolManager(this.protocolMgr);
            this.protocolMgr.setPersistentServerPort(ORBManager.getORBInitialPort());
            this.protocolMgr.setPersistentServerId(100);
            this.protocolMgr.initializeNaming(this.repositoryDir, this.orbInitialPort);
            ((POAProtocolMgr)this.protocolMgr).initializePOAs();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, localStrings.getLocalString("j2ee.naming", "Naming service started: ") + this.orbInitialPort);
            }
            SerialContextProviderImpl.initSerialContextProvider();
            object3 = new InvocationManagerImpl();
            ((Switch)object4).setInvocationManager((InvocationManager)object3);
            NamingManagerImpl namingManagerImpl = new NamingManagerImpl();
            ((Switch)object4).setNamingManager(namingManagerImpl);
            this.createServerObject();
            this.protocolMgr.initTransactionService("com.sun.jts.CosTransactions.DefaultTransactionService");
            this.startAuthenticationService();
            Audit.init();
            J2EETransactionManager j2EETransactionManager = J2EETransactionManagerImpl.createTransactionManager();
            ((Switch)object4).setTransactionManager(j2EETransactionManager);
            ResourceInstaller resourceInstaller = ((Switch)object4).getResourceInstaller();
            resourceInstaller.installJdbcDataSources();
            resourceInstaller.installConnectionFactories();
            resourceInstaller.installPersistenceManagerResources();
            resourceInstaller.installCustomResources();
            resourceInstaller.installExternalJndiResources();
            resourceInstaller.installMailResources();
            ((Switch)object4).setConnectionManager(IASConnectionManagerImpl.getConnectionManager());
            ResourcePoolManagerImpl resourcePoolManagerImpl = new ResourcePoolManagerImpl();
            ((Switch)object4).setResourcePoolManager(resourcePoolManagerImpl);
            resourceInstaller.installJMSResources();
            String string2 = System.getProperty("java.security.policy");
            if (string2 != null && ((File)(object2 = new File(string2))).canRead()) {
                object = new J2EESecurityManager();
                System.setSecurityManager((SecurityManager)object);
            }
            object2 = new JarManagerImpl();
            ((Switch)object4).setEJBJarManager((JarManagerImpl)object2);
            object = new ContainerFactoryImpl();
            ((Switch)object4).setContainerFactory((ContainerFactory)object);
            MonitoringHelper.registerTxnMonitoringMBean(new JTSMonitorMBean());
            ConfigContext configContext = ApplicationServer.getServerContext().getConfigContext();
            TransactionService transactionService = null;
            try {
                transactionService = ServerBeansFactory.getServerBean(configContext).getTransactionService();
                if (transactionService.isAutomaticRecovery()) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, localStrings.getLocalString("ejbserver.recovery", "Perform recovery of XAResources..."));
                    }
                    resourceInstaller.recoverXAResources();
                }
            }
            catch (ConfigException configException) {
                throw new RuntimeException("Error reading configuration : " + configException);
            }
            namingManagerImpl.publishObject("UserTransaction", (Object)new UserTransactionImpl(), true);
            DBInfoImpl dBInfoImpl = new DBInfoImpl();
            this.bindObject(this.orb, "DatabaseInformation", dBInfoImpl);
            UniqueValueGeneratorBackendImpl uniqueValueGeneratorBackendImpl = new UniqueValueGeneratorBackendImpl();
            this.bindObject(this.orb, "J2EE_UNIQUE_VALUE_GEN", uniqueValueGeneratorBackendImpl);
            String string3 = localStrings.getLocalString("j2ee.started", "J2EE server startup complete.");
            _logger.log(Level.FINE, string3);
        }
        catch (Exception exception) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "enterprise.j2eeservice_running_exception", exception.toString());
            }
            Log.err.flush();
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    private ORB createORB(String[] stringArray) throws Exception {
        Properties properties = new Properties();
        J2EEServer.initJTSProperties(true, properties);
        ORBManager.init(stringArray, properties);
        this.orbInitialPort = ORBManager.getORBInitialPort();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, localStrings.getLocalString("j2ee.listenPort", "J2EE server listen port: ") + this.orbInitialPort);
        }
        return ORBManager.getORB();
    }

    public static void initJTSProperties(boolean bl, Properties properties) {
        if (!bl) {
            properties.put("com.sun.corba.ee.CosTransactions.ORBJTSClass", "com.sun.jts.CosTransactions.DefaultTransactionService");
        }
        ConfigContext configContext = ApplicationServer.getServerContext().getConfigContext();
        TransactionService transactionService = null;
        try {
            String string;
            transactionService = ServerBeansFactory.getServerBean(configContext).getTransactionService();
            properties.put("com.sun.jts.heuristicDirection", transactionService.getHeuristicDecision());
            properties.put("com.sun.jts.keypointCount", transactionService.getKeypointInterval());
            if (transactionService.isAutomaticRecovery()) {
                properties.put("com.sun.jts.ManualRecovery", "true");
            }
            boolean bl2 = false;
            ElementProperty[] elementPropertyArray = transactionService.getElementProperty();
            int n = 0;
            while (n < elementPropertyArray.length) {
                if ("disable-distributed-transaction-logging".equals(elementPropertyArray[n].getName())) {
                    bl2 = "true".equals(elementPropertyArray[n].getValue());
                } else if ("xaresource-txn-timeout".equals(elementPropertyArray[n].getName())) {
                    string = elementPropertyArray[n].getValue();
                    _logger.log(Level.FINE, "XAResource transaction timeout is" + string);
                    if (string != null) {
                        TransactionManagerImpl.setXAResourceTimeOut(Integer.parseInt(string));
                    }
                }
                ++n;
            }
            if (transactionService.isAutomaticRecovery() || !transactionService.isAutomaticRecovery() && !bl2) {
                string = System.getProperty(J2EE_SERVER_ID_PROP);
                if (string == null) {
                    string = "0";
                }
                properties.put(J2EE_SERVER_ID_PROP, string);
                properties.put(JTS_SERVER_ID, string);
                String string2 = transactionService.getTxLogDir();
                if (string2 == null) {
                    Server server = null;
                    server = ServerBeansFactory.getServerBean(configContext);
                    string2 = server.getLogRoot();
                    if (string2 == null) {
                        string2 = FileUtil.getAbsolutePath(".." + File.separator + "logs");
                    }
                } else if (!new File(string2).isAbsolute()) {
                    _logger.log(Level.WARNING, "enterprise.relative_tx_log_dir", string2);
                    Server server = null;
                    server = ServerBeansFactory.getServerBean(configContext);
                    String string3 = server.getLogRoot();
                    string2 = string3 != null ? string3 + File.separator + string2 : FileUtil.getAbsolutePath(".." + File.separator + "logs" + File.separator + string2);
                }
                string2 = string2 + File.separator + "tx";
                new File(string2).mkdirs();
                properties.put("com.sun.jts.logDirectory", string2);
            }
        }
        catch (ConfigException configException) {
            throw new RuntimeException("Error reading configuration : " + configException);
        }
    }

    private void createServerObject() {
        ServerObjectImpl serverObjectImpl = null;
        try {
            serverObjectImpl = new ServerObjectImpl(this);
            this.bindObject(this.orb, SERVEROBJECT_NAME, serverObjectImpl);
        }
        catch (Exception exception) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "enterprise.serverobject_exception", exception.toString());
            }
            throw new RuntimeException("Unable to create ServerObjectImpl remote object");
        }
    }

    private void bindObject(ORB oRB, String string, Remote remote) throws RemoteException, NamingException {
        Tie tie = Util.getTie((Remote)remote);
        tie.orb(oRB);
        NamingManager namingManager = Switch.getSwitch().getNamingManager();
        namingManager.publishObject(string, (Object)tie, true);
    }

    private void startAuthenticationService() {
        block2: {
            try {
                RealmManager realmManager = new RealmManager();
                realmManager.init();
            }
            catch (Exception exception) {
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, "enterprise.realmmanager_exception", exception.toString());
            }
        }
    }

    private long readSecureSeed(File file) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            try {
                String string = bufferedReader.readLine();
                bufferedReader.close();
                Long l = new Long(string);
                return l;
            }
            catch (IOException iOException) {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        secureRandom.setSeed(System.currentTimeMillis());
        long l = secureRandom.nextLong();
        return l;
    }

    private void writeSecureSeed(File file, long l) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            String string = Long.toString(l);
            fileOutputStream.write(string.getBytes());
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            String string = localStrings.getLocalString("j2ee.startupslow", "Cannot write the seed file for fast startup. The next startup will be slow.");
            _logger.log(Level.WARNING, "enterprise.j2ee_startupslow");
        }
    }

    private static void printHelp(PrintStream printStream) {
        printStream.println(localStrings.getLocalString("j2ee.server", "Java 2 Enterprise Edition"));
        printStream.println(localStrings.getLocalString("j2ee.options", "Options:"));
        printStream.print("    ");
        printStream.println("-verbose\t\t" + localStrings.getLocalString("j2ee.verbose", "Redirect logging output to the current shell."));
        printStream.print("    ");
        printStream.println("-help\t\t" + localStrings.getLocalString("j2ee.help", "Print this help message."));
        printStream.print("    ");
        printStream.println("-version\t\t" + localStrings.getLocalString("j2ee.version", "Print the version."));
        printStream.print("    ");
        printStream.println("-stop\t\t" + localStrings.getLocalString("j2ee.stop", "Stop the J2EE server."));
    }

    public static void main(ServerContext serverContext) throws ServerLifecycleException {
        String[] stringArray = serverContext.getCmdLineArgs();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        Utility.checkJVMVersion();
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].trim().equals(HELP)) {
                J2EEServer.printHelp(System.out);
                return;
            }
            if (stringArray[n].trim().equals(STOP)) {
                J2EEServer.clientShutdown();
                return;
            }
            if (stringArray[n].trim().equals(VERSION) || stringArray[n].trim().equals(FULL_VERSION)) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, localStrings.getLocalString("j2ee.server_version", "Java 2 Enterprise Edition version ", new String[]{"1.3.1", "1.3.1-b16"}));
                }
                return;
            }
            if (stringArray[n].trim().equals(VERBOSE)) {
                bl = true;
            } else if (stringArray[n].trim().equals(DEBUG)) {
                bl3 = true;
            } else if (!stringArray[n].trim().equals(SINGLEVM)) {
                if (stringArray[n].trim().equals(MULTIVM)) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, localStrings.getLocalString("j2ee.msg001", "Warning: The multi-VM mode is no longer supported. Starting in single VM mode."));
                    }
                } else if (stringArray[n].trim().equals(NOJMS)) {
                    bl2 = false;
                } else if (stringArray[n].trim().equals(INSTRUMENT)) {
                    AppVerification.setInstrument(true);
                } else {
                    J2EEServer.printHelp(System.out);
                    return;
                }
            }
            ++n;
        }
        try {
            if (bl3) {
                DebugController.init();
            }
            J2EEServer j2EEServer = new J2EEServer();
            j2EEServer.setServerContext(serverContext);
            j2EEServer.run(stringArray, bl, bl2);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "enterprise.run_exception", exception);
            if (exception.getMessage() != null && _logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "enterprise.j2ee_server_error", exception.getMessage());
            }
            _logger.log(Level.SEVERE, "enterprise.j2ee_server_error1");
            System.err.flush();
            throw new ServerLifecycleException(exception.getMessage(), exception);
        }
    }

    private void setServerContext(ServerContext serverContext) {
        this.serverContext = serverContext;
    }

    private static void clientShutdown() {
        ServerObject serverObject;
        block7: {
            serverObject = null;
            try {
                System.setProperty(LISTEN_PROP, "");
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, localStrings.getLocalString("j2ee.shutdown", "Shutting down the J2EE server..."));
                }
                serverObject = (ServerObject)Utility.lookupObject(SERVEROBJECT_NAME, class$com$sun$enterprise$server$ServerObject == null ? (class$com$sun$enterprise$server$ServerObject = J2EEServer.class$("com.sun.enterprise.server.ServerObject")) : class$com$sun$enterprise$server$ServerObject);
            }
            catch (Throwable throwable) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "enterprise.serverobject_lookup_exception", throwable.toString());
                }
                if (!_logger.isLoggable(Level.FINE)) break block7;
                _logger.log(Level.FINE, localStrings.getLocalString("j2ee.cannot.shutdown", "Unable to shutdownthe J2EE server..."));
            }
        }
        try {
            if (serverObject != null) {
                serverObject.shutdown();
            }
        }
        catch (Throwable throwable) {}
    }

    void shutdown() {
        if (this.shutdownStarted) {
            return;
        }
        try {
            this.shutdownNoExit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.exit(0);
    }

    void shutdownNoExit() {
        block5: {
            try {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, localStrings.getLocalString("j2ee.shutdown", "Shutting down the J2EE server..."));
                }
                this.shutdownStarted = true;
                if (AppVerification.doInstrument()) {
                    AppVerification.getInstrumentLogger().writeResults();
                }
                Log.flushAll();
            }
            catch (Throwable throwable) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "enterprise.shutdown_exception", throwable.toString());
                }
                if (!_logger.isLoggable(Level.FINE)) break block5;
                _logger.log(Level.FINE, localStrings.getLocalString("j2ee.cannot.shutdown", "Unable to shutdown the J2EE server..."));
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.core");
        secureRandom = new SecureRandom();
        secureRandom.setSeed(System.currentTimeMillis());
        localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$server$J2EEServer == null ? (class$com$sun$enterprise$server$J2EEServer = J2EEServer.class$("com.sun.enterprise.server.J2EEServer")) : class$com$sun$enterprise$server$J2EEServer);
        ostream = System.out;
        estream = System.err;
        DEFAULT_KEYSTORE_PROP = SSLUtils.getKeyStoreProp();
        DEFAULT_KEYSTORE_NAME = SSLUtils.getDefaultKeyStoreName();
        if (Switch.getSwitch().getContainerType() != 1) {
            System.setProperty(DEFAULT_KEYSTORE_PROP, DEFAULT_KEYSTORE_NAME);
        }
    }

    class ShutdownHelper
    implements Runnable {
        private J2EEServer j2eeServer;

        ShutdownHelper(J2EEServer j2EEServer2) {
            this.j2eeServer = j2EEServer2;
        }

        public void run() {
            block4: {
                try {
                    if (!J2EEServer.this.shutdownStarted) {
                        this.j2eeServer.shutdownNoExit();
                    }
                }
                catch (Exception exception) {
                    if (_logger.isLoggable(Level.SEVERE)) {
                        _logger.log(Level.SEVERE, "enterprise.shutdown_exception", exception.toString());
                    }
                    if (!_logger.isLoggable(Level.FINE)) break block4;
                    _logger.log(Level.FINE, localStrings.getLocalString("j2ee.cannot.shutdown", "Unable to shutdown the J2EE server..."));
                }
            }
        }
    }
}

