/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.security.AbstractSecurityContext;
import com.sun.enterprise.security.PrincipalImpl;
import com.sun.enterprise.security.auth.Credentials;
import com.sun.enterprise.security.auth.login.PasswordCredential;
import com.sun.logging.LogDomains;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;

public class ClientSecurityContext
extends AbstractSecurityContext {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    private static final boolean isPerThreadAuth = Boolean.getBoolean("com.sun.appserv.iiopclient.perthreadauth");
    private static Object csc = isPerThreadAuth ? new ThreadLocal() : null;
    static /* synthetic */ Class class$com$sun$enterprise$security$ClientSecurityContext;

    public ClientSecurityContext(String string, Credentials credentials, Subject subject) {
        this.initiator = new PrincipalImpl(string);
        this.credentials = credentials;
        this.subject = subject;
    }

    public static ClientSecurityContext init() {
        ClientSecurityContext clientSecurityContext = ClientSecurityContext.getCurrent();
        if (clientSecurityContext == null) {
            clientSecurityContext = ClientSecurityContext.generateDefaultSecurityContext();
        }
        return clientSecurityContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClientSecurityContext generateDefaultSecurityContext() {
        ServerConfiguration serverConfiguration = ServerConfiguration.getConfiguration();
        String string = serverConfiguration.getProperty("auth.default.principal.name", "guest");
        String string2 = serverConfiguration.getProperty("auth.default.principal.password", "guest123");
        Class clazz = class$com$sun$enterprise$security$ClientSecurityContext == null ? (class$com$sun$enterprise$security$ClientSecurityContext = ClientSecurityContext.class$("com.sun.enterprise.security.ClientSecurityContext")) : class$com$sun$enterprise$security$ClientSecurityContext;
        synchronized (clazz) {
            try {
                final Subject subject = new Subject();
                final PasswordCredential passwordCredential = new PasswordCredential(string, string2, "default");
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        subject.getPrivateCredentials().add(passwordCredential);
                        return null;
                    }
                });
                ClientSecurityContext clientSecurityContext = new ClientSecurityContext(string, null, subject);
                ClientSecurityContext.setCurrent(clientSecurityContext);
                return clientSecurityContext;
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "java_security.gen_security_context", exception);
                return null;
            }
        }
    }

    public static void reset(ClientSecurityContext clientSecurityContext) {
        if (isPerThreadAuth) {
            ((ThreadLocal)csc).set(clientSecurityContext);
        } else {
            csc = clientSecurityContext;
        }
    }

    public static ClientSecurityContext getCurrent() {
        if (isPerThreadAuth) {
            return (ClientSecurityContext)((ThreadLocal)csc).get();
        }
        return (ClientSecurityContext)csc;
    }

    public static void setCurrent(ClientSecurityContext clientSecurityContext) {
        if (isPerThreadAuth) {
            ((ThreadLocal)csc).set(clientSecurityContext);
        } else {
            csc = clientSecurityContext;
        }
    }

    public Principal getCallerPrincipal() {
        return this.initiator;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public String toString() {
        return "ClientSecurityContext[ Initiator: " + this.initiator + " Credentials " + this.credentials.toString() + "Subject " + this.subject + " ]";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

