/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.resource.SystemJdbc10XaAllocator;
import com.sun.enterprise.resource.SystemJdbc20XaAllocator;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

public class SystemJdbcDataSource
implements DataSource,
Serializable {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$resource$JdbcDataSource == null ? (class$com$sun$enterprise$resource$JdbcDataSource = SystemJdbcDataSource.class$("com.sun.enterprise.resource.JdbcDataSource")) : class$com$sun$enterprise$resource$JdbcDataSource);
    private transient PoolManager poolMgr;
    private static final boolean debug = false;
    private String dataSourceName;
    private String desc;
    private String jndiName;
    private int jdbcMajorVersion;
    private String userName = null;
    private String password = null;
    private static final String PM_EXTENSION = "__pm";
    private HashMap _10Allocators = new HashMap(1);
    private HashMap _20Allocators = new HashMap(1);
    private ResourceSpec spec = null;
    static Logger _logger = null;
    static /* synthetic */ Class class$com$sun$enterprise$resource$JdbcDataSource;

    public boolean equals(Object object) {
        if (!(object instanceof SystemJdbcDataSource)) {
            return false;
        }
        SystemJdbcDataSource systemJdbcDataSource = (SystemJdbcDataSource)object;
        return systemJdbcDataSource.dataSourceName.equals(this.dataSourceName) && systemJdbcDataSource.jndiName.equals(this.jndiName) && systemJdbcDataSource.jdbcMajorVersion == this.jdbcMajorVersion;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    private ResourcePrincipal getDefaultPrincipal() {
        ResourcePrincipal resourcePrincipal = this.userName != null && this.password != null ? new ResourcePrincipal(this.userName, this.password) : new ResourcePrincipal();
        return resourcePrincipal;
    }

    public Connection getConnection() throws SQLException {
        this.initPoolManager();
        return this.internalGetConnection(this.getDefaultPrincipal());
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        this.initPoolManager();
        return this.internalGetConnection(new ResourcePrincipal(string, string2));
    }

    private Connection internalGetConnection(ResourcePrincipal resourcePrincipal) throws SQLException {
        ResourceAllocator resourceAllocator = null;
        this.spec.setJDBCConnectionPoolResourceName(this.dataSourceName);
        ClientSecurityInfo clientSecurityInfo = new ClientSecurityInfo(resourcePrincipal);
        resourceAllocator = this.jdbcMajorVersion == 1 ? this.get10Allocator(clientSecurityInfo) : this.get20Allocator(clientSecurityInfo);
        try {
            J2EETransactionManager j2EETransactionManager = Switch.getSwitch().getTransactionManager();
            Transaction transaction = j2EETransactionManager.getTransaction();
            ResourceHandle resourceHandle = this.poolMgr.getResourceFromPool(this.spec, resourceAllocator, new ClientSecurityInfo(resourcePrincipal), transaction);
            if (transaction != null) {
                j2EETransactionManager.enlistResource(transaction, resourceHandle);
            }
            return (Connection)resourceHandle.getUserConnection();
        }
        catch (PoolingException poolingException) {
            Exception exception = poolingException.getNestedException();
            if (exception == null) {
                throw new SQLException(poolingException.getMessage());
            }
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            _logger.log(Level.SEVERE, "poolmgr.unexpected_exception", poolingException);
            throw new SQLException(exception.toString());
        }
        catch (SystemException systemException) {
            _logger.log(Level.SEVERE, "poolmgr.unexpected_exception", systemException);
            throw new SQLException(systemException.toString());
        }
        catch (IllegalStateException illegalStateException) {
            _logger.log(Level.SEVERE, "poolmgr.unexpected_exception", illegalStateException);
            throw new SQLException(illegalStateException.toString());
        }
        catch (RollbackException rollbackException) {
            _logger.log(Level.SEVERE, "poolmgr.unexpected_exception", rollbackException);
            throw new SQLException(rollbackException.toString());
        }
    }

    private ResourceAllocator get10Allocator(ClientSecurityInfo clientSecurityInfo) {
        ResourceAllocator resourceAllocator = null;
        resourceAllocator = (ResourceAllocator)this._10Allocators.get(clientSecurityInfo);
        if (resourceAllocator == null) {
            resourceAllocator = new SystemJdbc10XaAllocator(this.poolMgr, this.dataSourceName, this.spec, clientSecurityInfo);
            this._10Allocators.put(clientSecurityInfo, resourceAllocator);
        }
        return resourceAllocator;
    }

    private ResourceAllocator get20Allocator(ClientSecurityInfo clientSecurityInfo) {
        ResourceAllocator resourceAllocator = null;
        resourceAllocator = (ResourceAllocator)this._20Allocators.get(clientSecurityInfo);
        if (resourceAllocator == null) {
            resourceAllocator = new SystemJdbc20XaAllocator(this.poolMgr, this.dataSourceName, this.spec, clientSecurityInfo);
            this._20Allocators.put(clientSecurityInfo, resourceAllocator);
        }
        return resourceAllocator;
    }

    public int getJdbcMajorVersion() {
        return this.jdbcMajorVersion;
    }

    public void setJdbcMajorVersion(int n) {
        this.jdbcMajorVersion = n;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String string) {
        this.jndiName = string;
        this.spec = new ResourceSpec(this.dataSourceName + PM_EXTENSION, 1);
    }

    public int getLoginTimeout() throws SQLException {
        throw new SQLException(localStrings.getLocalString("datasource.notsupported", "Operation not supported"));
    }

    public void setLoginTimeout(int n) throws SQLException {
        throw new SQLException(localStrings.getLocalString("datasource.notsupported", "Operation not supported"));
    }

    public PrintWriter getLogWriter() throws SQLException {
        throw new SQLException(localStrings.getLocalString("datasource.notsupported", "Operation not supported"));
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        throw new SQLException(localStrings.getLocalString("datasource.notsupported", "Operation not supported"));
    }

    public String getDescription() {
        return this.desc;
    }

    public void setDescription(String string) {
        this.desc = string;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    private void initPoolManager() {
        if (this.poolMgr == null) {
            this.poolMgr = Switch.getSwitch().getPoolManager();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    }
}

