/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.JdbcUrlAllocator;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class JdbcXAConnection
implements XAConnection {
    public static boolean debug = false;
    private JdbcConnection con;
    private JdbcXAResource xares;
    private Vector listeners;
    private boolean closed;
    private ResourceSpec spec;
    private ClientSecurityInfo info;
    private PoolManager poolMgr;
    private ResourceAllocator alloc;
    private Connection currentCon;
    private Xid currentXid;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$resource$JdbcXAConnection == null ? (class$com$sun$enterprise$resource$JdbcXAConnection = JdbcXAConnection.class$("com.sun.enterprise.resource.JdbcXAConnection")) : class$com$sun$enterprise$resource$JdbcXAConnection);
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    private static Hashtable jdbcCons = new Hashtable();
    static /* synthetic */ Class class$com$sun$enterprise$resource$JdbcXAConnection;

    public JdbcXAConnection(ResourceSpec resourceSpec, String string, ClientSecurityInfo clientSecurityInfo, PoolManager poolManager) throws PoolingException {
        this.spec = resourceSpec;
        this.info = clientSecurityInfo;
        this.listeners = new Vector();
        this.closed = false;
        this.poolMgr = poolManager;
        this.alloc = new JdbcUrlAllocator(poolManager, string, resourceSpec, clientSecurityInfo);
        ResourceHandle resourceHandle = poolManager.getResourceFromPool(resourceSpec, this.alloc, clientSecurityInfo, null);
        poolManager.putbackResourceToPool(resourceHandle, false);
    }

    public XAResource getXAResource() throws SQLException {
        if (this.closed) {
            throw new SQLException(localStrings.getLocalString("ejbcon.already_closed", "Connection has been previously closed, open a new Connection"));
        }
        return this.xares;
    }

    public Connection getConnection() throws SQLException {
        if (this.closed) {
            throw new SQLException(localStrings.getLocalString("ejbcon.already_closed", "Connection has been previously closed, open a new Connection"));
        }
        if (this.con != null) {
            this.con.setClosed();
        }
        try {
            this.con = new JdbcConnection();
            this.xares = new JdbcXAResource(this.spec, this.info);
        }
        catch (PoolingException poolingException) {
            _logger.log(Level.SEVERE, "jdbc.new_connection_error", poolingException);
            throw new SQLException();
        }
        return this.con;
    }

    public void close() throws SQLException {
        this.closed = true;
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.addElement(connectionEventListener);
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.removeElement(connectionEventListener);
    }

    void connectionClosed() {
        ConnectionEvent connectionEvent = new ConnectionEvent(this);
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            ((ConnectionEventListener)vector.elementAt(n2)).connectionClosed(connectionEvent);
            ++n2;
        }
    }

    void connectionErrorOccurred(SQLException sQLException) {
        ConnectionEvent connectionEvent = new ConnectionEvent(this, sQLException);
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            ((ConnectionEventListener)vector.elementAt(n2)).connectionErrorOccurred(connectionEvent);
            ++n2;
        }
    }

    Connection getJdbcConnection(Xid xid) throws PoolingException {
        Vector<Object> vector = new Vector<Object>(3);
        vector.addElement(this.spec);
        vector.addElement(this.info);
        vector.addElement(xid);
        ResourceHandle resourceHandle = (ResourceHandle)jdbcCons.get(vector);
        if (resourceHandle == null) {
            resourceHandle = this.poolMgr.getResourceFromPool(this.spec, this.alloc, this.info, null);
            jdbcCons.put(vector, resourceHandle);
        }
        return (Connection)resourceHandle.getResource();
    }

    void freeJdbcConnection(Xid xid) throws SQLException {
        Vector<Object> vector = new Vector<Object>(3);
        vector.addElement(this.spec);
        vector.addElement(this.info);
        vector.addElement(xid);
        ResourceHandle resourceHandle = (ResourceHandle)jdbcCons.get(vector);
        jdbcCons.remove(vector);
        this.poolMgr.putbackResourceToPool(resourceHandle, false);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class JdbcConnection
    implements Connection {
        private boolean closed;
        private ResourceHandle localCon;

        public Statement createStatement(int n, int n2, int n3) throws SQLException {
            this.errorIfClosed();
            Connection connection = this.getCurrentConnection();
            return connection.createStatement(n, n2, n3);
        }

        public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
            this.errorIfClosed();
            Connection connection = this.getCurrentConnection();
            return connection.prepareCall(string, n, n2, n3);
        }

        public Savepoint setSavepoint() throws SQLException {
            this.errorIfClosed();
            Connection connection = this.getCurrentConnection();
            return connection.setSavepoint();
        }

        public Savepoint setSavepoint(String string) throws SQLException {
            this.errorIfClosed();
            Connection connection = this.getCurrentConnection();
            return connection.setSavepoint(string);
        }

        public void rollback(Savepoint savepoint) throws SQLException {
            this.errorIfClosed();
            Connection connection = this.getCurrentConnection();
            connection.rollback(savepoint);
        }

        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            this.errorIfClosed();
            Connection connection = this.getCurrentConnection();
            connection.releaseSavepoint(savepoint);
        }

        public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
            this.errorIfClosed();
            Connection connection = this.getCurrentConnection();
            return connection.prepareStatement(string, n, n2, n3);
        }

        public PreparedStatement prepareStatement(String string, int n) throws SQLException {
            this.errorIfClosed();
            Connection connection = this.getCurrentConnection();
            return connection.prepareStatement(string, n);
        }

        public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
            this.errorIfClosed();
            Connection connection = this.getCurrentConnection();
            return connection.prepareStatement(string, nArray);
        }

        public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
            this.errorIfClosed();
            Connection connection = this.getCurrentConnection();
            return connection.prepareStatement(string, stringArray);
        }

        public Statement createStatement() throws SQLException {
            this.errorIfClosed();
            Connection connection = this.getCurrentConnection();
            return connection.createStatement();
        }

        public PreparedStatement prepareStatement(String string) throws SQLException {
            this.errorIfClosed();
            Connection connection = this.getCurrentConnection();
            return connection.prepareStatement(string);
        }

        public CallableStatement prepareCall(String string) throws SQLException {
            this.errorIfClosed();
            Connection connection = this.getCurrentConnection();
            return connection.prepareCall(string);
        }

        public String nativeSQL(String string) throws SQLException {
            this.errorIfClosed();
            Connection connection = this.getCurrentConnection();
            return connection.nativeSQL(string);
        }

        public void setAutoCommit(boolean bl) throws SQLException {
            this.errorIfClosed();
            if (this.checkIfTx()) {
                throw new SQLException(localStrings.getLocalString("ejbcon.wrongoperation", "Operation not allowed under global transaction context"));
            }
            Connection connection = this.getCurrentConnection();
            connection.setAutoCommit(bl);
        }

        public boolean getAutoCommit() throws SQLException {
            this.errorIfClosed();
            Connection connection = this.getCurrentConnection();
            return connection.getAutoCommit();
        }

        public void commit() throws SQLException {
            this.errorIfClosed();
            if (this.checkIfTx()) {
                throw new SQLException(localStrings.getLocalString("ejbcon.nocommitallowed", "No call to commit allowed with a transaction context"));
            }
            Connection connection = this.getCurrentConnection();
            connection.commit();
        }

        public void rollback() throws SQLException {
            this.errorIfClosed();
            if (this.checkIfTx()) {
                throw new SQLException(localStrings.getLocalString("ejbcon.norollbackallowed", "No call to rollback allowed within a transaction context"));
            }
            Connection connection = this.getCurrentConnection();
            connection.rollback();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws SQLException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            JdbcXAConnection.this.connectionClosed();
            if (this.localCon == null) {
                return;
            }
            Connection connection = (Connection)this.localCon.getResource();
            try {
                block8: {
                    try {
                        if (connection.getAutoCommit()) {
                            connection.setAutoCommit(false);
                            break block8;
                        }
                        if (debug) {
                            _logger.log(Level.FINE, "Jdbc10: rollback local connection due to close");
                        }
                        connection.rollback();
                    }
                    catch (SQLException sQLException) {
                        _logger.log(Level.WARNING, "Jdbc10: SQLException thrown while closing the connection", sQLException);
                        Object var4_3 = null;
                        JdbcXAConnection.this.poolMgr.putbackResourceToPool(this.localCon, false);
                    }
                }
                Object var4_2 = null;
                JdbcXAConnection.this.poolMgr.putbackResourceToPool(this.localCon, false);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                JdbcXAConnection.this.poolMgr.putbackResourceToPool(this.localCon, false);
                throw throwable;
            }
        }

        public boolean isClosed() {
            return this.closed;
        }

        public DatabaseMetaData getMetaData() throws SQLException {
            this.errorIfClosed();
            Connection connection = this.getCurrentConnection();
            return connection.getMetaData();
        }

        public void setReadOnly(boolean bl) throws SQLException {
            this.errorIfClosed();
            Connection connection = this.getCurrentConnection();
            connection.setReadOnly(bl);
        }

        public boolean isReadOnly() throws SQLException {
            this.errorIfClosed();
            Connection connection = this.getCurrentConnection();
            return connection.isReadOnly();
        }

        public void setHoldability(int n) throws SQLException {
            this.errorIfClosed();
            Connection connection = this.getCurrentConnection();
            connection.setHoldability(n);
        }

        public int getHoldability() throws SQLException {
            this.errorIfClosed();
            Connection connection = this.getCurrentConnection();
            return connection.getHoldability();
        }

        public void setCatalog(String string) throws SQLException {
            this.errorIfClosed();
            Connection connection = this.getCurrentConnection();
            connection.setCatalog(string);
        }

        public String getCatalog() throws SQLException {
            this.errorIfClosed();
            Connection connection = this.getCurrentConnection();
            return connection.getCatalog();
        }

        public void setTransactionIsolation(int n) throws SQLException {
            this.errorIfClosed();
            Connection connection = this.getCurrentConnection();
            connection.setTransactionIsolation(n);
        }

        public int getTransactionIsolation() throws SQLException {
            this.errorIfClosed();
            Connection connection = this.getCurrentConnection();
            return connection.getTransactionIsolation();
        }

        public SQLWarning getWarnings() throws SQLException {
            this.errorIfClosed();
            Connection connection = this.getCurrentConnection();
            return connection.getWarnings();
        }

        public void clearWarnings() throws SQLException {
            this.errorIfClosed();
            Connection connection = this.getCurrentConnection();
            connection.clearWarnings();
        }

        public void setTypeMap(Map map) throws SQLException {
            this.errorIfClosed();
            Connection connection = this.getCurrentConnection();
            connection.setTypeMap(map);
        }

        public Map getTypeMap() throws SQLException {
            this.errorIfClosed();
            Connection connection = this.getCurrentConnection();
            return connection.getTypeMap();
        }

        public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
            this.errorIfClosed();
            Connection connection = this.getCurrentConnection();
            return connection.prepareStatement(string, n, n2);
        }

        public Statement createStatement(int n, int n2) throws SQLException {
            this.errorIfClosed();
            Connection connection = this.getCurrentConnection();
            return connection.createStatement(n, n2);
        }

        public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
            this.errorIfClosed();
            Connection connection = this.getCurrentConnection();
            return connection.prepareCall(string, n, n2);
        }

        void setClosed() {
            this.closed = true;
        }

        private void errorIfClosed() throws SQLException {
            if (JdbcXAConnection.this.currentXid != null) {
                Vector<Object> vector = new Vector<Object>(3);
                vector.addElement(JdbcXAConnection.this.spec);
                vector.addElement(JdbcXAConnection.this.info);
                vector.addElement(JdbcXAConnection.this.currentXid);
                if (jdbcCons.get(vector) == null) {
                    throw new SQLException(localStrings.getLocalString("ejbcon.already_rollbacked", ""));
                }
            }
            if (this.closed) {
                throw new SQLException(localStrings.getLocalString("ejbcon.already_closed", "Connection has been previously closed, open a new Connection"));
            }
        }

        private boolean checkIfTx() {
            return JdbcXAConnection.this.currentCon != null;
        }

        private Connection getCurrentConnection() throws SQLException {
            if (JdbcXAConnection.this.currentCon != null) {
                return JdbcXAConnection.this.currentCon;
            }
            if (this.localCon == null) {
                if (debug) {
                    _logger.log(Level.FINE, "Jdbc10: Using Local connection");
                    Thread.dumpStack();
                }
                try {
                    this.localCon = JdbcXAConnection.this.poolMgr.getResourceFromPool(JdbcXAConnection.this.spec, JdbcXAConnection.this.alloc, JdbcXAConnection.this.info, null);
                    Connection connection = (Connection)this.localCon.getResource();
                    if (!connection.getAutoCommit()) {
                        connection.rollback();
                        connection.setAutoCommit(true);
                    }
                }
                catch (PoolingException poolingException) {
                    _logger.log(Level.SEVERE, "jdbc.get_current_connection", poolingException);
                    throw new SQLException();
                }
            }
            return (Connection)this.localCon.getResource();
        }
    }

    class JdbcXAResource
    implements XAResource {
        private ResourceSpec spec;
        private ClientSecurityInfo info;

        JdbcXAResource(ResourceSpec resourceSpec, ClientSecurityInfo clientSecurityInfo) {
            this.spec = resourceSpec;
            this.info = clientSecurityInfo;
        }

        public void start(Xid xid, int n) throws XAException {
            if (debug) {
                _logger.log(Level.FINE, "Jdbc10: XAResource.start" + xid);
            }
            try {
                JdbcXAConnection.this.currentXid = xid;
                JdbcXAConnection.this.currentCon = JdbcXAConnection.this.getJdbcConnection(xid);
            }
            catch (PoolingException poolingException) {
                throw new XAException();
            }
        }

        public void end(Xid xid, int n) throws XAException {
            if (debug) {
                _logger.log(Level.FINE, "Jdbc10: XAResource.end" + xid);
            }
            JdbcXAConnection.this.currentCon = null;
            JdbcXAConnection.this.currentXid = null;
        }

        public int prepare(Xid xid) throws XAException {
            if (debug) {
                _logger.log(Level.FINE, "Jdbc10: XAResource.prepare " + xid);
            }
            return 0;
        }

        public void commit(Xid xid, boolean bl) throws XAException {
            if (debug) {
                _logger.log(Level.FINE, "Jdbc10: XAResource.commit" + xid);
            }
            try {
                Connection connection = JdbcXAConnection.this.getJdbcConnection(xid);
                connection.commit();
                JdbcXAConnection.this.freeJdbcConnection(xid);
            }
            catch (Exception exception) {
                throw new XAException();
            }
        }

        public void rollback(Xid xid) throws XAException {
            if (debug) {
                _logger.log(Level.FINE, "Jdbc10: XAResource.rollback" + xid);
            }
            try {
                Connection connection = JdbcXAConnection.this.getJdbcConnection(xid);
                connection.rollback();
                JdbcXAConnection.this.freeJdbcConnection(xid);
            }
            catch (Exception exception) {
                throw new XAException();
            }
        }

        public void forget(Xid xid) throws XAException {
            throw new XAException();
        }

        public Xid[] recover(int n) throws XAException {
            throw new XAException();
        }

        public boolean isSameRM(XAResource xAResource) throws XAException {
            if (this == xAResource) {
                return true;
            }
            if (xAResource == null) {
                return false;
            }
            if (xAResource instanceof JdbcXAResource) {
                JdbcXAResource jdbcXAResource = (JdbcXAResource)xAResource;
                return this.spec.equals(jdbcXAResource.spec) && this.info.equals(jdbcXAResource.info);
            }
            return false;
        }

        public int getTransactionTimeout() throws XAException {
            return 0;
        }

        public boolean setTransactionTimeout(int n) throws XAException {
            return false;
        }

        public String toString() {
            return "JDBCXAConnection$JdbcXAResource, hashCode=" + this.hashCode() + " spec=" + this.spec + " info=" + this.info;
        }
    }
}

