/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.Jdbc10XaAllocator;
import com.sun.enterprise.resource.Jdbc20XaAllocator;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class JdbcDataSource
implements DataSource,
Serializable {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$resource$JdbcDataSource == null ? (class$com$sun$enterprise$resource$JdbcDataSource = JdbcDataSource.class$("com.sun.enterprise.resource.JdbcDataSource")) : class$com$sun$enterprise$resource$JdbcDataSource);
    private transient PoolManager poolMgr;
    private static final boolean debug = false;
    private String dataSourceName;
    private String desc;
    private String jndiName;
    private int jdbcMajorVersion;
    private String userName = null;
    private String password = null;
    private transient HashMap _10Allocators;
    private transient HashMap _20Allocators;
    private ResourceSpec spec = null;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    static /* synthetic */ Class class$com$sun$enterprise$resource$JdbcDataSource;

    private ResourcePrincipal getDefaultPrincipal() {
        ResourcePrincipal resourcePrincipal = this.userName != null && this.password != null ? new ResourcePrincipal(this.userName, this.password) : new ResourcePrincipal();
        return resourcePrincipal;
    }

    public Connection getConnection() throws SQLException {
        InvocationManager invocationManager = Switch.getSwitch().getInvocationManager();
        if (invocationManager == null) {
            String string = localStrings.getLocalString("datasource.wrongclient", "");
            throw new SQLException(string);
        }
        this.initPoolManager();
        ResourceReferenceDescriptor resourceReferenceDescriptor = this.poolMgr.getResourceReference(this.jndiName);
        boolean bl = true;
        if (resourceReferenceDescriptor == null) {
            String string = localStrings.getLocalString("no.resource.reference", "", new Object[]{this.jndiName});
            _logger.log(Level.FINE, string);
            return this.internalGetConnection(this.getDefaultPrincipal(), bl);
        }
        String string = resourceReferenceDescriptor.getSharingScope();
        if (string.equals(ResourceReferenceDescriptor.RESOURCE_UNSHAREABLE)) {
            bl = false;
        }
        String string2 = resourceReferenceDescriptor.getAuthorization();
        if (string2.equals(ResourceReferenceDescriptor.APPLICATION_AUTHORIZATION)) {
            String string3 = localStrings.getLocalString("password.parameter.warning", "", new Object[]{this.jndiName});
            _logger.log(Level.FINE, string3);
            throw new SQLException(string3);
        }
        ResourcePrincipal resourcePrincipal = resourceReferenceDescriptor.getResourcePrincipal();
        if (resourcePrincipal == null) {
            String string4 = localStrings.getLocalString("password.info.warning", "", new Object[]{this.jndiName});
            return this.internalGetConnection(this.getDefaultPrincipal(), bl);
        }
        return this.internalGetConnection(resourcePrincipal, bl);
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        InvocationManager invocationManager = Switch.getSwitch().getInvocationManager();
        if (invocationManager == null) {
            String string3 = localStrings.getLocalString("datasource.wrongclient", "");
            throw new SQLException(string3);
        }
        this.initPoolManager();
        ResourceReferenceDescriptor resourceReferenceDescriptor = this.poolMgr.getResourceReference(this.jndiName);
        boolean bl = true;
        if (resourceReferenceDescriptor == null) {
            String string4 = localStrings.getLocalString("no.resource.reference", "", new Object[]{this.jndiName});
            _logger.log(Level.FINE, string4);
            return this.internalGetConnection(new ResourcePrincipal(string, string2), bl);
        }
        String string5 = resourceReferenceDescriptor.getSharingScope();
        if (string5.equals(ResourceReferenceDescriptor.RESOURCE_UNSHAREABLE)) {
            bl = false;
        }
        String string6 = resourceReferenceDescriptor.getAuthorization();
        if (string6.equals(ResourceReferenceDescriptor.CONTAINER_AUTHORIZATION)) {
            String string7 = localStrings.getLocalString("redundant.password", "", new Object[]{this.jndiName});
            _logger.log(Level.FINE, string7);
            return this.internalGetConnection(new ResourcePrincipal(string, string2), bl);
        }
        return this.internalGetConnection(new ResourcePrincipal(string, string2), bl);
    }

    private Connection internalGetConnection(ResourcePrincipal resourcePrincipal, boolean bl) throws SQLException {
        ResourceAllocator resourceAllocator = null;
        this.spec.setJDBCConnectionPoolResourceName(this.dataSourceName);
        ClientSecurityInfo clientSecurityInfo = new ClientSecurityInfo(resourcePrincipal);
        if (this.jdbcMajorVersion == 1) {
            if (!bl) {
                throw new SQLException("Cannot use resource in unshareable scope: " + this.jndiName);
            }
            resourceAllocator = this.get10Allocator(clientSecurityInfo);
        } else {
            resourceAllocator = this.get20Allocator(clientSecurityInfo, bl);
        }
        try {
            return (Connection)this.poolMgr.getResource(this.spec, resourceAllocator, new ClientSecurityInfo(resourcePrincipal));
        }
        catch (PoolingException poolingException) {
            Exception exception = poolingException.getNestedException();
            if (exception == null) {
                throw new SQLException(poolingException.getMessage());
            }
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            _logger.log(Level.SEVERE, "jdbc.get_internal_connection", exception);
            throw new SQLException(exception.toString());
        }
    }

    private ResourceAllocator get10Allocator(ClientSecurityInfo clientSecurityInfo) {
        ResourceAllocator resourceAllocator = null;
        if (this._10Allocators == null) {
            this._10Allocators = new HashMap();
        }
        if ((resourceAllocator = (ResourceAllocator)this._10Allocators.get(clientSecurityInfo)) == null) {
            resourceAllocator = new Jdbc10XaAllocator(this.poolMgr, this.dataSourceName, this.spec, clientSecurityInfo);
            this._10Allocators.put(clientSecurityInfo, resourceAllocator);
        }
        return resourceAllocator;
    }

    private ResourceAllocator get20Allocator(ClientSecurityInfo clientSecurityInfo, boolean bl) {
        ResourceAllocator resourceAllocator = null;
        if (this._20Allocators == null) {
            this._20Allocators = new HashMap();
        }
        if ((resourceAllocator = (ResourceAllocator)this._20Allocators.get(clientSecurityInfo)) == null) {
            resourceAllocator = new Jdbc20XaAllocator(this.poolMgr, this.dataSourceName, this.spec, clientSecurityInfo, bl);
            this._20Allocators.put(clientSecurityInfo, resourceAllocator);
        }
        return resourceAllocator;
    }

    public int getJdbcMajorVersion() {
        return this.jdbcMajorVersion;
    }

    public void setJdbcMajorVersion(int n) {
        this.jdbcMajorVersion = n;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String string) {
        this.jndiName = string;
        this.spec = new ResourceSpec(this.dataSourceName, 1);
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public int getLoginTimeout() throws SQLException {
        return DriverManager.getLoginTimeout();
    }

    public void setLoginTimeout(int n) throws SQLException {
        DriverManager.setLoginTimeout(n);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return DriverManager.getLogWriter();
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        DriverManager.setLogWriter(printWriter);
    }

    public String getDescription() {
        return this.desc;
    }

    public void setDescription(String string) {
        this.desc = string;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    private void initPoolManager() {
        if (this.poolMgr == null) {
            this.poolMgr = Switch.getSwitch().getPoolManager();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

