/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.iplanet.ias.util.MonitorTask;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationException;
import com.sun.enterprise.Switch;
import com.sun.enterprise.repository.JdbcConnectionPool;
import com.sun.enterprise.resource.Jdbc10XaAllocator;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourcePool;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.resource.SystemJdbc10XaAllocator;
import com.sun.enterprise.resource.validation.ConnectionValidator;
import com.sun.enterprise.resource.validation.ConnectionValidatorByAutoCommit;
import com.sun.enterprise.resource.validation.ConnectionValidatorByMetaData;
import com.sun.enterprise.resource.validation.ConnectionValidatorByUserTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.transaction.Transaction;

public class IASNonSharedResourcePool
implements ResourcePool {
    private static final boolean debug = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$resource$ResourceInstaller == null ? (class$com$sun$enterprise$resource$ResourceInstaller = IASNonSharedResourcePool.class$("com.sun.enterprise.resource.ResourceInstaller")) : class$com$sun$enterprise$resource$ResourceInstaller);
    private Hashtable resourceStates;
    private Set free;
    private long idletime;
    private String name;
    private String jdbcConnectionPoolResourceName;
    private ResourceSpec resourceSpec;
    private ResourceAllocator allocator;
    private int maxPoolSize;
    private int steadyPoolSize;
    private int resizeQuantity;
    private int maxWaitTime;
    private ConnectionValidator validator = null;
    private boolean requireConnectionValidation = false;
    private boolean failAllConnections = false;
    private String validationType = null;
    private String userTable = null;
    private boolean poolInitialized = false;
    private TimerTask resizerTask;
    private int numConnFailedValidation = 0;
    private int numConnTimedOut = 0;
    static final String READ_UNCOMMITTED = "read-uncommitted";
    static final String READ_COMMITTED = "read-committed";
    static final String REPEATABLE_READ = "repeatable-read";
    static final String SERIALIZABLE = "serializable";
    boolean _isGuaranteedIsolationLevel = true;
    boolean _isDefaulIsolationLevel = true;
    int _isolationLevel;
    private Hashtable transTable;
    private LinkedList waitQueue = new LinkedList();
    private HashMap nonTxOpsResourceMap = null;
    private boolean noNonTxOps;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    static /* synthetic */ Class class$com$sun$enterprise$resource$ResourceInstaller;

    private boolean inTx() {
        ComponentInvocation componentInvocation = Switch.getSwitch().getInvocationManager().getCurrentInvocation();
        if (componentInvocation == null) {
            throw new InvocationException();
        }
        Transaction transaction = componentInvocation.getTransaction();
        return transaction != null;
    }

    public IASNonSharedResourcePool(ResourceSpec resourceSpec, ResourceAllocator resourceAllocator) throws PoolingException {
        this.resourceSpec = resourceSpec;
        this.allocator = resourceAllocator;
        this.name = resourceSpec.toString();
        this.jdbcConnectionPoolResourceName = resourceSpec.getJDBCConnectionPoolResourceName();
        this.setConfigurationParameters();
    }

    private void setConfigurationParameters() throws PoolingException {
        String string;
        JdbcConnectionPool jdbcConnectionPool;
        Context context = Switch.getSwitch().getNamingManager().getInitialContext();
        try {
            jdbcConnectionPool = (JdbcConnectionPool)context.lookup(this.jdbcConnectionPoolResourceName);
        }
        catch (NamingException namingException) {
            throw new PoolingException(namingException);
        }
        this.idletime = Integer.parseInt(jdbcConnectionPool.getIdleTimeoutInSeconds()) * 1000;
        this.maxPoolSize = Integer.parseInt(jdbcConnectionPool.getMaxPoolSize());
        this.steadyPoolSize = Integer.parseInt(jdbcConnectionPool.getSteadyPoolSize());
        this.resizeQuantity = Integer.parseInt(jdbcConnectionPool.getPoolResizeQuantity());
        this.maxWaitTime = Integer.parseInt(jdbcConnectionPool.getMaxWaitTimeInMillis());
        if (this.maxWaitTime < 0) {
            this.maxWaitTime = 0;
        }
        if ((string = jdbcConnectionPool.getTransactionIsolationLevel()) == null || string.length() < 1) {
            this._isDefaulIsolationLevel = true;
            this._isGuaranteedIsolationLevel = true;
        } else {
            this._isDefaulIsolationLevel = false;
            this._isGuaranteedIsolationLevel = jdbcConnectionPool.isIsolationLevelGuaranteed();
            if (string.equals(READ_COMMITTED)) {
                this._isolationLevel = 2;
            } else if (string.equals(READ_UNCOMMITTED)) {
                this._isolationLevel = 1;
            } else if (string.equals(REPEATABLE_READ)) {
                this._isolationLevel = 4;
            } else if (string.equals(SERIALIZABLE)) {
                this._isolationLevel = 8;
            } else {
                this._isDefaulIsolationLevel = true;
                this._isGuaranteedIsolationLevel = true;
                _logger.log(Level.WARNING, localStrings.getLocalString("isolation.level.unknown", "Transaction Isolation Level Unknwon, proceeding with default values"));
            }
        }
        this.requireConnectionValidation = jdbcConnectionPool.isIsConnectionValidationRequired();
        if (this.allocator instanceof Jdbc10XaAllocator || this.allocator instanceof SystemJdbc10XaAllocator) {
            this.requireConnectionValidation = false;
            this._isDefaulIsolationLevel = true;
        }
        if (this.requireConnectionValidation) {
            this.failAllConnections = jdbcConnectionPool.isFailAllConnections();
            this.validationType = jdbcConnectionPool.getConnectionValidationMethod();
            if (this.validationType != null && this.requireConnectionValidation) {
                if (this.validationType.equals("auto-commit")) {
                    this.validator = new ConnectionValidatorByAutoCommit();
                } else if (this.validationType.equals("meta-data")) {
                    this.validator = new ConnectionValidatorByMetaData();
                } else if (this.validationType.equals("table")) {
                    this.userTable = jdbcConnectionPool.getValidationTableName();
                    this.validator = new ConnectionValidatorByUserTable(this.userTable);
                } else {
                    _logger.log(Level.WARNING, "jdbc.invalid_validation_type");
                    this.requireConnectionValidation = false;
                }
            }
        }
        if (jdbcConnectionPool.isPerfMonitor()) {
            MonitorTask.addJDBCMonitorable(this);
        }
        if (jdbcConnectionPool.getNoNonTxOps() && jdbcConnectionPool.isXA()) {
            this.noNonTxOps = true;
            this.nonTxOpsResourceMap = new HashMap(this.steadyPoolSize);
        }
    }

    private synchronized void initPool(ResourceSpec resourceSpec, ResourceAllocator resourceAllocator) throws PoolingException {
        if (this.poolInitialized) {
            return;
        }
        this.resourceStates = new Hashtable(this.steadyPoolSize);
        this.free = new HashSet(this.steadyPoolSize);
        this.transTable = new Hashtable();
        this.createSteadyResources();
        if (this.idletime > 0L) {
            this.scheduleResizerTask();
        }
        this.poolInitialized = true;
    }

    private void scheduleResizerTask() {
        if (this.resizerTask != null) {
            this.resizerTask.cancel();
            this.resizerTask = null;
        }
        this.resizerTask = new Resizer();
        Timer timer = Switch.getSwitch().getTimer();
        timer.scheduleAtFixedRate(this.resizerTask, this.idletime, this.idletime);
    }

    private boolean isValid(ResourceHandle resourceHandle) {
        return this.validator.isValid(resourceHandle);
    }

    public synchronized void addResource(ResourceSpec resourceSpec, ResourceHandle resourceHandle) {
        ResourceState resourceState = new ResourceState();
        this.resourceStates.put(resourceHandle, resourceState);
        resourceState.setEnlisted(false);
        resourceState.setBusy(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceHandle getResource(ResourceSpec resourceSpec, ResourceAllocator resourceAllocator, Transaction transaction) throws PoolingException {
        ResourceHandle resourceHandle = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        Object object = new Object();
        if (this.maxWaitTime > 0) {
            l = System.currentTimeMillis();
        }
        while ((resourceHandle = this.internalGetResource(resourceSpec, resourceAllocator, transaction)) == null) {
            Object object2;
            if (this.maxWaitTime > 0) {
                l2 = System.currentTimeMillis() - l;
                if (l2 < (long)this.maxWaitTime) {
                    l3 = (long)this.maxWaitTime - l2;
                } else {
                    ++this.numConnTimedOut;
                    object2 = localStrings.getLocalString("poolmgr.no.available.resource", "No available resource. Wait-time expired.");
                    throw new PoolingException((String)object2);
                }
            }
            object2 = object;
            synchronized (object2) {
                LinkedList linkedList = this.waitQueue;
                synchronized (linkedList) {
                    this.waitQueue.addLast(object);
                }
                try {
                    object.wait(l3);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                LinkedList linkedList2 = this.waitQueue;
                synchronized (linkedList2) {
                    this.waitQueue.remove(object);
                }
            }
        }
        return resourceHandle;
    }

    private synchronized ResourceHandle internalGetResource(ResourceSpec resourceSpec, ResourceAllocator resourceAllocator, Transaction transaction) throws PoolingException {
        Object object;
        Object object2;
        Object object3;
        this.initPool(resourceSpec, resourceAllocator);
        Object object4 = null;
        if (transaction != null && (object3 = (Set)this.transTable.get(transaction)) != null) {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (ResourceHandle)object2.next();
                ResourceState resourceState = this.getResourceState((ResourceHandle)object);
                if (!resourceAllocator.matchConnection((ResourceHandle)object) || !resourceState.isFree()) continue;
                object4 = object;
                break;
            }
        }
        if (object4 == null) {
            object3 = this.free.iterator();
            while (object3.hasNext()) {
                object2 = (ResourceHandle)object3.next();
                object = this.getResourceState((ResourceHandle)object2);
                if (!resourceAllocator.matchConnection((ResourceHandle)object2) || ((ResourceState)object).isEnlisted()) continue;
                object4 = object2;
                break;
            }
        }
        if (object4 != null) {
            object3 = this.getResourceState((ResourceHandle)object4);
            ((ResourceState)object3).setBusy(true);
            this.free.remove(object4);
            if (this.requireConnectionValidation && ((ResourceState)object3).isUnenlisted()) {
                int n = this.resourceStates.size();
                boolean bl = false;
                try {
                    resourceAllocator.fillInResourceObjects((ResourceHandle)object4);
                    bl = this.isValid((ResourceHandle)object4);
                }
                catch (PoolingException poolingException) {
                    bl = false;
                }
                if (!bl) {
                    if (this.failAllConnections) {
                        this.numConnFailedValidation += n;
                        object4 = this.failAllConnections(resourceAllocator);
                    } else {
                        this.resourceStates.remove(object4);
                        this.destroyResource((ResourceHandle)object4);
                        ++this.numConnFailedValidation;
                        object4 = null;
                    }
                }
            } else {
                resourceAllocator.fillInResourceObjects((ResourceHandle)object4);
            }
        }
        if (object4 == null && this.resourceStates.size() < this.maxPoolSize) {
            object4 = resourceAllocator.createResource();
            this.addResource(resourceSpec, (ResourceHandle)object4);
            resourceAllocator.fillInResourceObjects((ResourceHandle)object4);
        }
        if (!this._isDefaulIsolationLevel && object4 != null) {
            object3 = (ResourceState)this.resourceStates.get(object4);
            if (((ResourceState)object3).isNew()) {
                this.setTransactionIsolationLevel((ResourceHandle)object4);
                ((ResourceState)object3).setNotNew();
            } else if (this._isGuaranteedIsolationLevel) {
                this.setTransactionIsolationLevel((ResourceHandle)object4);
            }
        }
        if (this.noNonTxOps && object4 != null && !this.inTx()) {
            this.nonTxOpsResourceMap.put(object4, new Object());
        }
        return object4;
    }

    private void setTransactionIsolationLevel(ResourceHandle resourceHandle) throws PoolingException {
        Connection connection = (Connection)resourceHandle.getUserConnection();
        if (connection == null) {
            connection = (Connection)resourceHandle.getResource();
        }
        try {
            connection.setTransactionIsolation(this._isolationLevel);
        }
        catch (SQLException sQLException) {
            throw new PoolingException(sQLException);
        }
    }

    private ResourceHandle failAllConnections(ResourceAllocator resourceAllocator) throws PoolingException {
        ResourceHandle resourceHandle = null;
        this.emptyPool();
        this.createSteadyResources();
        if (!resourceAllocator.equals(this.allocator) && this.free.size() > 0) {
            Iterator iterator = this.free.iterator();
            resourceHandle = (ResourceHandle)iterator.next();
            ResourceState resourceState = this.getResourceState(resourceHandle);
            resourceState.setBusy(true);
            this.free.remove(resourceHandle);
            this.allocator.fillInResourceObjects(resourceHandle);
        }
        return resourceHandle;
    }

    private synchronized void createSteadyResources() throws PoolingException {
        ResourceHandle resourceHandle = null;
        int n = 0;
        while (n < this.steadyPoolSize) {
            resourceHandle = this.allocator.createResource();
            this.addResource(this.resourceSpec, resourceHandle);
            this.getResourceState(resourceHandle).setBusy(false);
            this.free.add(resourceHandle);
            ++n;
        }
    }

    private void destroyResource(ResourceHandle resourceHandle) {
        try {
            resourceHandle.getResourceAllocator().destroyResource(resourceHandle);
        }
        catch (Exception exception) {
            _logger.log(Level.WARNING, "poolmgr.destroy_resource_failed");
            _logger.log(Level.FINE, "poolmgr.destroy_resource_failed", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resourceClosed(ResourceHandle resourceHandle) throws IllegalStateException {
        ResourceState resourceState = this.getResourceState(resourceHandle);
        if (resourceState == null || !resourceState.isBusy()) {
            throw new IllegalStateException();
        }
        if (this.noNonTxOps && this.nonTxOpsResourceMap.remove(resourceHandle) != null) {
            this.resourceStates.remove(resourceHandle);
            this.destroyResource(resourceHandle);
            return;
        }
        resourceState.setBusy(false);
        resourceState.touchTimestamp();
        this.free.add(resourceHandle);
        Object object = null;
        LinkedList linkedList = this.waitQueue;
        synchronized (linkedList) {
            if (this.waitQueue.size() > 0) {
                object = this.waitQueue.removeFirst();
            }
        }
        if (object != null) {
            Object object2 = object;
            synchronized (object2) {
                object.notify();
            }
        }
    }

    public synchronized void resourceErrorOccurred(ResourceHandle resourceHandle) throws IllegalStateException {
        ResourceState resourceState = this.getResourceState(resourceHandle);
        if (resourceState == null || !resourceState.isBusy()) {
            throw new IllegalStateException();
        }
        this.resourceStates.remove(resourceHandle);
        this.destroyResource(resourceHandle);
    }

    public synchronized void resourceEnlisted(Transaction transaction, ResourceHandle resourceHandle) throws IllegalStateException {
        HashSet<ResourceHandle> hashSet = (HashSet<ResourceHandle>)this.transTable.get(transaction);
        if (hashSet == null) {
            hashSet = new HashSet<ResourceHandle>();
            this.transTable.put(transaction, hashSet);
        }
        hashSet.add(resourceHandle);
        ResourceState resourceState = this.getResourceState(resourceHandle);
        resourceState.setEnlisted(true);
    }

    public synchronized void transactionCompleted(Transaction transaction, int n) throws IllegalStateException {
        HashSet hashSet = (HashSet)this.transTable.get(transaction);
        if (hashSet == null) {
            return;
        }
        this.transTable.remove(transaction);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ResourceHandle resourceHandle = (ResourceHandle)iterator.next();
            ResourceState resourceState = this.getResourceState(resourceHandle);
            resourceState.setEnlisted(false);
        }
    }

    public int getNumThreadWaiting() {
        return this.waitQueue.size();
    }

    public int getNumConnFailedValidation() {
        return this.numConnFailedValidation;
    }

    public int getNumConnTimedOut() {
        return this.numConnTimedOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resizePool(boolean bl) {
        boolean bl2 = false;
        LinkedList linkedList = this.waitQueue;
        synchronized (linkedList) {
            if (this.waitQueue.size() > 0) {
                return;
            }
        }
        int n = this.resourceStates.size() - this.steadyPoolSize;
        if (n > 0) {
            int n2 = this.resizeQuantity < n ? this.resizeQuantity : n;
            Iterator iterator = this.free.iterator();
            long l = System.currentTimeMillis();
            while (n2 > 0 && iterator.hasNext()) {
                ResourceHandle resourceHandle = (ResourceHandle)iterator.next();
                ResourceState resourceState = this.getResourceState(resourceHandle);
                if (!bl && l - resourceState.getTimestamp() <= this.idletime || !resourceState.isUnenlisted()) continue;
                this.resourceStates.remove(resourceHandle);
                this.destroyResource(resourceHandle);
                iterator.remove();
                --n2;
            }
        }
        if (this.resourceStates.size() < this.steadyPoolSize) {
            ResourceHandle resourceHandle = null;
            int n3 = this.resourceStates.size();
            while (n3 < this.steadyPoolSize) {
                try {
                    resourceHandle = this.allocator.createResource();
                    this.addResource(this.resourceSpec, resourceHandle);
                    this.getResourceState(resourceHandle).setBusy(false);
                    this.free.add(resourceHandle);
                }
                catch (PoolingException poolingException) {
                    _logger.log(Level.WARNING, "resource_pool.resize_pool_error", poolingException);
                }
                ++n3;
            }
        }
    }

    private ResourceState getResourceState(ResourceHandle resourceHandle) {
        return (ResourceState)this.resourceStates.get(resourceHandle);
    }

    public synchronized void emptyPool() {
        Enumeration enumeration = this.resourceStates.keys();
        while (enumeration.hasMoreElements()) {
            ResourceHandle resourceHandle = (ResourceHandle)enumeration.nextElement();
            this.destroyResource(resourceHandle);
        }
        this.free.clear();
        this.resourceStates.clear();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Pool [");
        stringBuffer.append(this.name);
        stringBuffer.append("] PoolSize=");
        stringBuffer.append(this.resourceStates.size());
        stringBuffer.append("  FreeResources=");
        stringBuffer.append(this.free.size());
        stringBuffer.append("  QueueSize=");
        stringBuffer.append(this.waitQueue.size());
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Resizer
    extends TimerTask {
        Resizer() {
        }

        public void run() {
            try {
                IASNonSharedResourcePool.this.resizePool(false);
            }
            catch (Throwable throwable) {}
        }
    }

    public static class ResourceState {
        private boolean enlisted;
        private boolean busy;
        private long timestamp;
        private boolean isNew = true;

        public boolean isEnlisted() {
            return this.enlisted;
        }

        public boolean isUnenlisted() {
            return !this.enlisted;
        }

        public boolean isFree() {
            return !this.busy;
        }

        public void setEnlisted(boolean bl) {
            this.enlisted = bl;
        }

        public boolean isBusy() {
            return this.busy;
        }

        public void setBusy(boolean bl) {
            this.busy = bl;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void touchTimestamp() {
            this.timestamp = System.currentTimeMillis();
        }

        public ResourceState() {
            this.touchTimestamp();
        }

        public boolean isNew() {
            return this.isNew;
        }

        public void setNotNew() {
            this.isNew = false;
        }
    }
}

