/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.repository;

import com.sun.enterprise.repository.Configuration;
import com.sun.enterprise.repository.Repository;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigurationImpl
implements Configuration {
    private static Logger _logger = null;
    private static String OBJECT_STORE_DIR;
    private static final String OBJECT_FILE_EXT = ".ser";
    private Hashtable table = new Hashtable();
    private Repository defaultRepository = this.getRepository("default");

    private String getIndex(String string) {
        int n = string.indexOf(".");
        if (n < 0) {
            return "default";
        }
        return string.substring(0, n);
    }

    private String getEffectiveKey(String string) {
        int n = string.indexOf(".");
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    private Repository getRepository(String string) {
        Repository repository = (Repository)this.table.get(string);
        if (repository == null) {
            repository = new Repository(string);
            if (repository.getName().equals(string)) {
                this.table.put(string, repository);
            } else {
                repository = this.defaultRepository;
            }
        }
        return repository;
    }

    public String getProperty(String string) throws RemoteException {
        String string2 = this.getIndex(string);
        String string3 = this.getEffectiveKey(string);
        Repository repository = this.getRepository(string2);
        String string4 = null;
        string4 = repository.getName().equals(string2) ? repository.find(string3) : repository.find(string);
        return string4;
    }

    public void setProperty(String string, String string2) throws RemoteException {
        String string3 = this.getIndex(string);
        String string4 = this.getEffectiveKey(string);
        Repository repository = this.getRepository(string3);
        if (repository.getName().equals(string3)) {
            repository.add(string4, string2);
        } else {
            repository.add(string, string2);
        }
    }

    public void removeProperty(String string) throws RemoteException {
        String string2 = this.getIndex(string);
        String string3 = this.getEffectiveKey(string);
        Repository repository = this.getRepository(string2);
        if (repository.getName().equals(string2)) {
            repository.remove(string3);
        } else {
            repository.remove(string);
        }
    }

    public Object getObject(String string) throws RemoteException {
        Object object;
        block2: {
            String string2 = this.getProperty(string);
            object = null;
            if (string2 == null) break block2;
            try {
                FileInputStream fileInputStream = new FileInputStream(string2);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                object = objectInputStream.readObject();
                fileInputStream.close();
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "enterprise.file_exception", exception);
            }
        }
        return object;
    }

    public void setObject(String string, Object object) throws RemoteException {
        String string2 = object.getClass().getName();
        String string3 = String.valueOf(object.hashCode());
        String string4 = OBJECT_STORE_DIR + string2 + string3 + OBJECT_FILE_EXT;
        try {
            String string5 = FileUtil.getAbsolutePath(string4);
            FileOutputStream fileOutputStream = new FileOutputStream(string5);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            fileOutputStream.close();
            this.setProperty(string, string5);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "enterprise.file_exception", exception);
        }
    }

    public void removeObject(String string) throws RemoteException {
        block3: {
            String string2 = this.getProperty(string);
            if (string2 == null) break block3;
            try {
                File file = new File(string2);
                if (file.exists()) {
                    file.delete();
                }
                this.removeProperty(string);
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "enterprise.file_exception", exception);
            }
        }
    }

    public String[] getKeys(String string) throws RemoteException {
        Repository repository = this.getRepository(string);
        return repository.keys();
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise");
        OBJECT_STORE_DIR = "repository" + File.separator + Utility.getLocalHost() + File.separator + "objects" + File.separator;
    }
}

