/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming;

import com.sun.enterprise.naming.SerialContextProvider;
import com.sun.enterprise.naming.SerialNameParser;
import com.sun.enterprise.util.ORBManager;
import com.sun.logging.LogDomains;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Binding;
import javax.naming.CommunicationException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.spi.NamingManager;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.ORB;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;

public class SerialContext
implements Context {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.naming");
    private static final boolean debug = false;
    private static Hashtable providerCache = new Hashtable();
    private static NameParser myParser = new SerialNameParser();
    private Hashtable myEnv;
    private SerialContextProvider provider;
    private String myName;
    static /* synthetic */ Class class$com$sun$enterprise$naming$SerialContextProvider;

    private SerialContextProvider getProvider() throws NamingException {
        ORB oRB = (ORB)this.myEnv.get("java.naming.corba.orb");
        if (oRB == null) {
            oRB = ORBManager.getORB();
        }
        this.provider = (SerialContextProvider)providerCache.get(oRB);
        if (this.provider == null) {
            try {
                NamingContext namingContext = NamingContextHelper.narrow(oRB.resolve_initial_references("NameService"));
                NameComponent[] nameComponentArray = new NameComponent[]{new NameComponent("SerialContextProvider", "")};
                this.provider = (SerialContextProvider)PortableRemoteObject.narrow((Object)namingContext.resolve(nameComponentArray), (Class)(class$com$sun$enterprise$naming$SerialContextProvider == null ? (class$com$sun$enterprise$naming$SerialContextProvider = SerialContext.class$("com.sun.enterprise.naming.SerialContextProvider")) : class$com$sun$enterprise$naming$SerialContextProvider));
            }
            catch (Exception exception) {
                throw new CommunicationException("Can't find SerialContextProvider");
            }
            providerCache.put(oRB, this.provider);
        }
        return this.provider;
    }

    public SerialContext(Hashtable hashtable) throws NamingException {
        this.myEnv = hashtable != null ? (Hashtable)hashtable.clone() : null;
        this.myName = "";
    }

    public SerialContext(String string, Hashtable hashtable) throws NamingException {
        this(hashtable);
        this.myName = string;
    }

    public String getNameInNamespace() throws NamingException {
        return this.myName;
    }

    public Object lookup(String string) throws NamingException {
        if (string.equals("")) {
            return new SerialContext(this.myName, this.myEnv);
        }
        string = this.getRelativeName(string);
        try {
            Object object = this.getProvider().lookup(string);
            if (object instanceof Context) {
                return new SerialContext(string, this.myEnv);
            }
            Object object2 = NamingManager.getObjectInstance(object, new CompositeName(string), null, this.myEnv);
            return object2;
        }
        catch (NamingException namingException) {
            throw namingException;
        }
        catch (Exception exception) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            _logger.log(Level.SEVERE, "enterprise_naming.serialctx_communication_exception", exception);
            throw new CommunicationException(stringWriter.toString());
        }
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public void bind(String string, Object object) throws NamingException {
        string = this.getRelativeName(string);
        try {
            this.getProvider().bind(string, object);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException.toString());
        }
    }

    public void bind(Name name, Object object) throws NamingException {
        this.bind(name.toString(), object);
    }

    public void rebind(String string, Object object) throws NamingException {
        string = this.getRelativeName(string);
        try {
            this.getProvider().rebind(string, object);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException.toString());
        }
    }

    public void rebind(Name name, Object object) throws NamingException {
        this.rebind(name.toString(), object);
    }

    public void unbind(String string) throws NamingException {
        string = this.getRelativeName(string);
        try {
            this.getProvider().unbind(string);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException.toString());
        }
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void rename(String string, String string2) throws NamingException {
        string = this.getRelativeName(string);
        string2 = this.getRelativeName(string2);
        try {
            this.getProvider().rename(string, string2);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException.toString());
        }
    }

    public void rename(Name name, Name name2) throws NamingException {
        this.rename(name.toString(), name2.toString());
    }

    public NamingEnumeration list(String string) throws NamingException {
        if (string.equals("")) {
            try {
                Hashtable hashtable = this.getProvider().list(this.myName);
                return new RepNames(hashtable);
            }
            catch (RemoteException remoteException) {
                throw new CommunicationException(remoteException.toString());
            }
        }
        Object object = this.lookup(string = this.getRelativeName(string));
        if (object instanceof Context) {
            return ((Context)object).list("");
        }
        throw new NotContextException(string + " cannot be listed");
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        if (string.equals("")) {
            try {
                Hashtable hashtable = this.getProvider().list(this.myName);
                return new RepBindings(hashtable);
            }
            catch (RemoteException remoteException) {
                throw new CommunicationException(remoteException.toString());
            }
        }
        Object object = this.lookup(string = this.getRelativeName(string));
        if (object instanceof Context) {
            return ((Context)object).listBindings("");
        }
        throw new NotContextException(string + " cannot be listed");
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public void destroySubcontext(String string) throws NamingException {
        string = this.getRelativeName(string);
        try {
            this.getProvider().destroySubcontext(string);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException.toString());
        }
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public Context createSubcontext(String string) throws NamingException {
        Context context = null;
        string = this.getRelativeName(string);
        try {
            context = this.getProvider().createSubcontext(string);
            if (context instanceof Context) {
                context = new SerialContext(string, this.myEnv);
            }
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException.toString());
        }
        return context;
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    public Object lookupLink(String string) throws NamingException {
        string = this.getRelativeName(string);
        return this.lookup(string);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public NameParser getNameParser(String string) throws NamingException {
        return myParser;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public String composeName(String string, String string2) throws NamingException {
        Name name = this.composeName(new CompositeName(string), new CompositeName(string2));
        return name.toString();
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        Name name3 = (Name)name2.clone();
        name3.addAll(name);
        return name3;
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(5, 0.75f);
        }
        return this.myEnv.put(string, object);
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        if (this.myEnv == null) {
            return null;
        }
        return this.myEnv.remove(string);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(3, 0.75f);
        }
        return this.myEnv;
    }

    public void close() throws NamingException {
        this.myEnv = null;
    }

    private String getRelativeName(String string) {
        if (!this.myName.equals("")) {
            string = this.myName + "/" + string;
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class RepBindings
    implements NamingEnumeration {
        Enumeration names;
        Hashtable bindings;

        RepBindings(Hashtable hashtable) {
            this.bindings = hashtable;
            this.names = hashtable.keys();
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                String string = (String)this.names.nextElement();
                return new Binding(string, this.bindings.get(string));
            }
            return null;
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() throws NamingException {
            throw new OperationNotSupportedException("close() not implemented");
        }
    }

    class RepNames
    implements NamingEnumeration {
        Hashtable bindings;
        Enumeration names;

        RepNames(Hashtable hashtable) {
            this.bindings = hashtable;
            this.names = hashtable.keys();
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            if (this.names.hasMoreElements()) {
                String string = (String)this.names.nextElement();
                String string2 = this.bindings.get(string).getClass().getName();
                return new NameClassPair(string, string2);
            }
            return null;
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() throws NamingException {
            throw new OperationNotSupportedException("close() not implemented");
        }
    }
}

