/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.logging.LogDomains;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.ObjectIdentifier;

public class GSSUtils {
    private static Logger _logger;
    public static ObjectIdentifier GSSUP_MECH_OID;
    public static ObjectIdentifier GSS_NT_EXPORT_NAME_OID;
    public static ObjectIdentifier GSS_NT_SCOPED_USERNAME_OID;

    public static String dumpHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        while (n < byArray.length) {
            String string;
            int n2;
            if (n != 0 && n % 16 == 0) {
                stringBuffer.append("\n    ");
            }
            if ((n2 = byArray[n]) < 0) {
                n2 = 256 + n2;
            }
            if ((string = Integer.toHexString(n2)).length() == 1) {
                string = "0" + string;
            }
            stringBuffer.append(string + " ");
            ++n;
        }
        return stringBuffer.toString();
    }

    public static byte[] importName(ObjectIdentifier objectIdentifier, byte[] byArray) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Attempting to import mechanism independent name");
            _logger.log(Level.FINE, GSSUtils.dumpHex(byArray));
        }
        IOException iOException = new IOException("Invalid Name");
        if (byArray[0] != 4) {
            throw iOException;
        }
        if (byArray[1] != 1) {
            throw iOException;
        }
        int n = (byArray[2] << 8) + byArray[3];
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Mech OID length = " + n);
        }
        if (byArray.length < 4 + n + 4) {
            throw iOException;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 4, byArray2, 0, n);
        ObjectIdentifier objectIdentifier2 = GSSUtils.getOID(byArray2);
        if (!objectIdentifier2.equals(objectIdentifier)) {
            throw iOException;
        }
        int n2 = 4 + n;
        int n3 = (byArray[n2] << 24) + (byArray[n2 + 1] << 16) + (byArray[n2 + 2] << 8) + byArray[n2 + 3];
        n2 += 4;
        if (byArray.length != 4 + n + 4 + n3) {
            throw iOException;
        }
        byte[] byArray3 = new byte[byArray.length - n2];
        System.arraycopy(byArray, n2, byArray3, 0, byArray.length - n2);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Mechanism specific name:");
            _logger.log(Level.FINE, GSSUtils.dumpHex(byArray3));
            _logger.log(Level.FINE, "Successfully imported mechanism independent name");
        }
        return byArray3;
    }

    public static boolean verifyMechOID(ObjectIdentifier objectIdentifier, byte[] byArray) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Attempting to verify mechanism independent name");
            _logger.log(Level.FINE, GSSUtils.dumpHex(byArray));
        }
        IOException iOException = new IOException("Invalid Name");
        if (byArray[0] != 4) {
            throw iOException;
        }
        if (byArray[1] != 1) {
            throw iOException;
        }
        int n = (byArray[2] << 8) + byArray[3];
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Mech OID length = " + n);
        }
        if (byArray.length < 4 + n + 4) {
            throw iOException;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 4, byArray2, 0, n);
        ObjectIdentifier objectIdentifier2 = GSSUtils.getOID(byArray2);
        return objectIdentifier2.equals(objectIdentifier);
    }

    public static byte[] createExportedName(ObjectIdentifier objectIdentifier, byte[] byArray) throws IOException {
        byte[] byArray2 = GSSUtils.getDER(objectIdentifier);
        int n = 4 + byArray2.length + 4 + byArray.length;
        byte[] byArray3 = new byte[n];
        int n2 = 0;
        byArray3[0] = 4;
        byArray3[1] = 1;
        byArray3[2] = (byte)(byArray2.length & 0xFF00);
        byArray3[3] = (byte)(byArray2.length & 0xFF);
        n2 = 4;
        System.arraycopy(byArray2, 0, byArray3, n2, byArray2.length);
        n2 += byArray2.length;
        int n3 = byArray.length;
        byArray3[n2++] = (byte)(n3 & 0xFF000000);
        byArray3[n2++] = (byte)(n3 & 0xFF0000);
        byArray3[n2++] = (byte)(n3 & 0xFF00);
        byArray3[n2++] = (byte)(n3 & 0xFF);
        System.arraycopy(byArray, 0, byArray3, n2, n3);
        return byArray3;
    }

    public static byte[] getDER(ObjectIdentifier objectIdentifier) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Returning OID in DER format");
            _logger.log(Level.FINE, "    OID = " + objectIdentifier.toString());
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putOID(objectIdentifier);
        byte[] byArray = derOutputStream.toByteArray();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "    DER OID: " + GSSUtils.dumpHex(byArray));
        }
        return byArray;
    }

    public static ObjectIdentifier getOID(byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        ObjectIdentifier objectIdentifier = derInputStream.getOID();
        return objectIdentifier;
    }

    public static byte[] createMechIndToken(ObjectIdentifier objectIdentifier, byte[] byArray) throws IOException {
        byte[] byArray2 = GSSUtils.getDER(objectIdentifier);
        byte[] byArray3 = new byte[1 + GSSUtils.getDERLengthSize(byArray2.length + byArray.length) + byArray2.length + byArray.length];
        _logger.log(Level.FINE, "Going to create a mechanism independent token");
        int n = 0;
        byArray3[n++] = 96;
        n = GSSUtils.writeDERLength(byArray3, n, byArray2.length + byArray.length);
        System.arraycopy(byArray2, 0, byArray3, n, byArray2.length);
        System.arraycopy(byArray, 0, byArray3, n += byArray2.length, byArray.length);
        _logger.log(Level.FINE, "Mechanism independent token created: ");
        _logger.log(Level.FINE, GSSUtils.dumpHex(byArray3));
        return byArray3;
    }

    public static byte[] getMechToken(ObjectIdentifier objectIdentifier, byte[] byArray) {
        byte[] byArray2 = null;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Received mechanism independent token: ");
            _logger.log(Level.FINE, GSSUtils.dumpHex(byArray));
        }
        try {
            int n = GSSUtils.verifyTokenHeader(objectIdentifier, byArray);
            int n2 = byArray.length - n;
            byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Mechanism specific token : ");
                _logger.log(Level.FINE, GSSUtils.dumpHex(byArray2));
            }
        }
        catch (IOException iOException) {
            _logger.log(Level.SEVERE, "iiop.IOexception", iOException);
        }
        return byArray2;
    }

    private static int verifyTokenHeader(ObjectIdentifier objectIdentifier, byte[] byArray) throws IOException {
        int n = 0;
        _logger.log(Level.FINE, "Attempting to verify tokenheader in the mechanism independent token.");
        if (byArray[n++] != 96) {
            throw new IOException("Defective Token");
        }
        int n2 = GSSUtils.readDERLength(byArray, n);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Mech OID length + Mech specific length = " + n2);
        }
        n += GSSUtils.getDERLengthSize(n2);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Mechanism OID index : " + n);
        }
        if (byArray[n] != 6) {
            throw new IOException("Defective Token");
        }
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray.length - n);
        ObjectIdentifier objectIdentifier2 = GSSUtils.getOID(byArray2);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Comparing mech OID in token with the expected mech OID");
            _logger.log(Level.FINE, "mech OID: " + GSSUtils.dumpHex(GSSUtils.getDER(objectIdentifier2)));
            _logger.log(Level.FINE, "expected mech OID: " + GSSUtils.dumpHex(GSSUtils.getDER(objectIdentifier)));
        }
        if (!objectIdentifier2.equals(objectIdentifier)) {
            _logger.log(Level.FINE, "mech OID in token does not match expected mech OID");
            throw new IOException("Defective token");
        }
        int n3 = GSSUtils.getDER(objectIdentifier).length;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Mechanism specific token index : " + n + n3);
            _logger.log(Level.FINE, "Successfully verified header in the mechanism independent token.");
        }
        return n + n3;
    }

    static int getDERLengthSize(int n) {
        if (n < 128) {
            return 1;
        }
        if (n < 256) {
            return 2;
        }
        if (n < 65536) {
            return 3;
        }
        if (n < 0x1000000) {
            return 4;
        }
        return 5;
    }

    static int writeDERLength(byte[] byArray, int n, int n2) {
        if (n2 < 128) {
            byArray[n++] = (byte)n2;
        } else {
            byArray[n++] = (byte)(GSSUtils.getDERLengthSize(n2) + 127);
            if (n2 >= 0x1000000) {
                byArray[n++] = (byte)(n2 >> 24);
            }
            if (n2 >= 65536) {
                byArray[n++] = (byte)(n2 >> 16 & 0xFF);
            }
            if (n2 >= 256) {
                byArray[n++] = (byte)(n2 >> 8 & 0xFF);
            }
            byArray[n++] = (byte)(n2 & 0xFF);
        }
        return n;
    }

    static int readDERLength(byte[] byArray, int n) {
        int n2;
        int n3 = 0;
        if (((n2 = byArray[n++]) & 0x80) == 128) {
            int n4 = n2 & 0x7F;
            while (n4 != 0) {
                n3 = (n3 << 8) + (byArray[n++] & 0xFF);
                --n4;
            }
        } else {
            n3 = n2;
        }
        return n3;
    }

    public static void main(String[] stringArray) {
        try {
            byte[] byArray = new byte[]{-126, 1, -45};
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Length byte array : " + GSSUtils.dumpHex(byArray));
                _logger.log(Level.FINE, " Der length = " + GSSUtils.readDERLength(byArray, 0));
            }
            String string = "default";
            byte[] byArray2 = GSSUtils.createExportedName(GSSUP_MECH_OID, string.getBytes());
            byte[] byArray3 = GSSUtils.importName(GSSUP_MECH_OID, byArray2);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "BAR:" + new String(byArray3));
            }
            String string2 = "dummy_gss_export_sec_context";
            byte[] byArray4 = GSSUtils.createMechIndToken(GSSUP_MECH_OID, string2.getBytes());
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "FOO:" + GSSUtils.dumpHex(byArray4));
            }
            byte[] byArray5 = GSSUtils.getMechToken(GSSUP_MECH_OID, byArray4);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "BAR:" + GSSUtils.dumpHex(byArray5));
                _logger.log(Level.FINE, "BAR string: " + new String(byArray5));
            }
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "iiop.name_exception", exception);
        }
    }

    static {
        int n;
        _logger = null;
        _logger = LogDomains.getLogger("javax.enterprise.resource.corba");
        GSSUP_MECH_OID = null;
        GSS_NT_EXPORT_NAME_OID = null;
        GSS_NT_SCOPED_USERNAME_OID = null;
        ObjectIdentifier objectIdentifier = null;
        try {
            n = "oid:2.23.130.1.1.1".indexOf(58);
            objectIdentifier = new ObjectIdentifier("oid:2.23.130.1.1.1".substring(n + 1));
        }
        catch (IOException iOException) {
            objectIdentifier = null;
            _logger.log(Level.SEVERE, "iiop.IOexception", iOException);
        }
        GSSUP_MECH_OID = objectIdentifier;
        try {
            n = "oid:1.3.6.1.5.6.4".indexOf(58);
            objectIdentifier = new ObjectIdentifier("oid:1.3.6.1.5.6.4".substring(n + 1));
        }
        catch (IOException iOException) {
            objectIdentifier = null;
            _logger.log(Level.SEVERE, "iiop.IOexception", iOException);
        }
        GSS_NT_EXPORT_NAME_OID = objectIdentifier;
        try {
            n = "oid:2.23.130.1.2.1".indexOf(58);
            objectIdentifier = new ObjectIdentifier("oid:2.23.130.1.2.1".substring(n + 1));
        }
        catch (IOException iOException) {
            objectIdentifier = null;
            _logger.log(Level.SEVERE, "iiop.IOexception", iOException);
        }
        GSS_NT_SCOPED_USERNAME_OID = objectIdentifier;
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "GSSUP_MECH_OID: " + GSSUtils.dumpHex(GSSUtils.getDER(GSSUP_MECH_OID)));
                _logger.log(Level.FINE, "GSS_NT_EXPORT_NAME_OID: " + GSSUtils.dumpHex(GSSUtils.getDER(GSS_NT_EXPORT_NAME_OID)));
                _logger.log(Level.FINE, "GSS_NT_SCOPED_USERNAME_OID: " + GSSUtils.dumpHex(GSSUtils.getDER(GSS_NT_SCOPED_USERNAME_OID)));
            }
        }
        catch (IOException iOException) {
            _logger.log(Level.SEVERE, "iiop.IOexception", iOException);
        }
    }
}

