/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.persistence;

import com.sun.ejb.EJBUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public final class JDBCUtils {
    private static final boolean debug = false;

    public static void copyObjToDB(PreparedStatement preparedStatement, int n, Object object, int n2) throws SQLException {
        switch (n2) {
            case 1: {
                if (object == null) {
                    preparedStatement.setNull(n, n2);
                    break;
                }
                preparedStatement.setString(n, ((Character)object).toString());
                break;
            }
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                if (object == null) {
                    preparedStatement.setNull(n, n2);
                    break;
                }
                preparedStatement.setObject(n, object);
                break;
            }
            case -4: {
                if (object == null) {
                    preparedStatement.setNull(n, n2);
                    break;
                }
                preparedStatement.setBytes(n, (byte[])object);
                break;
            }
            case 12: {
                if (object == null) {
                    preparedStatement.setNull(n, n2);
                    break;
                }
                preparedStatement.setString(n, (String)object);
                break;
            }
            case 2: {
                if (object == null) {
                    preparedStatement.setNull(n, n2);
                    break;
                }
                preparedStatement.setBigDecimal(n, (BigDecimal)object);
                break;
            }
            case 91: {
                if (object == null) {
                    preparedStatement.setNull(n, n2);
                    break;
                }
                preparedStatement.setDate(n, (Date)object);
                break;
            }
            case 92: {
                if (object == null) {
                    preparedStatement.setNull(n, n2);
                    break;
                }
                preparedStatement.setTime(n, (Time)object);
                break;
            }
            case 93: {
                if (object == null) {
                    preparedStatement.setNull(n, n2);
                    break;
                }
                preparedStatement.setTimestamp(n, (Timestamp)object);
                break;
            }
            case 2000: {
                byte[] byArray;
                if (object == null) {
                    preparedStatement.setNull(n, -4);
                    break;
                }
                try {
                    byArray = EJBUtils.serializeObject(object);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Unable to serialize container-managed field." + exception);
                }
                preparedStatement.setBytes(n, byArray);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported JDBC type: " + n2);
            }
        }
    }

    public static void copyFieldToDB(final PreparedStatement preparedStatement, final int n, final Field field, final Object object, final int n2) throws SQLException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws SQLException {
                    JDBCUtils.copyFieldToDBInternal(preparedStatement, n, field, object, n2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (SQLException)privilegedActionException.getException();
        }
    }

    private static void copyFieldToDBInternal(PreparedStatement preparedStatement, int n, Field field, Object object, int n2) throws SQLException {
        Object object2 = null;
        boolean bl = field.getType().isPrimitive();
        try {
            switch (n2) {
                case 1: {
                    object2 = field.get(object);
                    if (object2 == null) {
                        preparedStatement.setNull(n, n2);
                        break;
                    }
                    preparedStatement.setString(n, ((Character)object2).toString());
                    break;
                }
                case 4: {
                    if (bl) {
                        preparedStatement.setInt(n, field.getInt(object));
                        break;
                    }
                    object2 = field.get(object);
                    if (object2 == null) {
                        preparedStatement.setNull(n, n2);
                        break;
                    }
                    preparedStatement.setInt(n, (Integer)object2);
                    break;
                }
                case -7: {
                    if (bl) {
                        preparedStatement.setBoolean(n, field.getBoolean(object));
                        break;
                    }
                    object2 = field.get(object);
                    if (object2 == null) {
                        preparedStatement.setNull(n, n2);
                        break;
                    }
                    preparedStatement.setBoolean(n, (Boolean)object2);
                    break;
                }
                case -6: {
                    if (bl) {
                        preparedStatement.setByte(n, field.getByte(object));
                        break;
                    }
                    object2 = field.get(object);
                    if (object2 == null) {
                        preparedStatement.setNull(n, n2);
                        break;
                    }
                    preparedStatement.setByte(n, (Byte)object2);
                    break;
                }
                case 5: {
                    if (bl) {
                        preparedStatement.setShort(n, field.getShort(object));
                        break;
                    }
                    object2 = field.get(object);
                    if (object2 == null) {
                        preparedStatement.setNull(n, n2);
                        break;
                    }
                    preparedStatement.setShort(n, (Short)object2);
                    break;
                }
                case -5: {
                    if (bl) {
                        preparedStatement.setLong(n, field.getLong(object));
                        break;
                    }
                    object2 = field.get(object);
                    if (object2 == null) {
                        preparedStatement.setNull(n, n2);
                        break;
                    }
                    preparedStatement.setLong(n, (Long)object2);
                    break;
                }
                case 7: {
                    if (bl) {
                        preparedStatement.setFloat(n, field.getFloat(object));
                        break;
                    }
                    object2 = field.get(object);
                    if (object2 == null) {
                        preparedStatement.setNull(n, n2);
                        break;
                    }
                    preparedStatement.setFloat(n, ((Float)object2).floatValue());
                    break;
                }
                case 8: {
                    if (bl) {
                        preparedStatement.setDouble(n, field.getDouble(object));
                        break;
                    }
                    object2 = field.get(object);
                    if (object2 == null) {
                        preparedStatement.setNull(n, n2);
                        break;
                    }
                    preparedStatement.setDouble(n, (Double)object2);
                    break;
                }
                case -4: {
                    object2 = field.get(object);
                    if (object2 == null) {
                        preparedStatement.setNull(n, n2);
                        break;
                    }
                    preparedStatement.setBytes(n, (byte[])object2);
                    break;
                }
                case 12: {
                    object2 = field.get(object);
                    if (object2 == null) {
                        preparedStatement.setNull(n, n2);
                        break;
                    }
                    preparedStatement.setString(n, (String)object2);
                    break;
                }
                case 2: {
                    object2 = field.get(object);
                    if (object2 == null) {
                        preparedStatement.setNull(n, n2);
                        break;
                    }
                    preparedStatement.setBigDecimal(n, (BigDecimal)object2);
                    break;
                }
                case 91: {
                    object2 = field.get(object);
                    if (object2 == null) {
                        preparedStatement.setNull(n, n2);
                        break;
                    }
                    preparedStatement.setDate(n, (Date)object2);
                    break;
                }
                case 92: {
                    object2 = field.get(object);
                    if (object2 == null) {
                        preparedStatement.setNull(n, n2);
                        break;
                    }
                    preparedStatement.setTime(n, (Time)object2);
                    break;
                }
                case 93: {
                    object2 = field.get(object);
                    if (object2 == null) {
                        preparedStatement.setNull(n, n2);
                        break;
                    }
                    preparedStatement.setTimestamp(n, (Timestamp)object2);
                    break;
                }
                case 2000: {
                    byte[] byArray;
                    object2 = field.get(object);
                    if (object2 == null) {
                        preparedStatement.setNull(n, -4);
                        break;
                    }
                    try {
                        byArray = EJBUtils.serializeObject(object2);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("Unable to serialize container-managed field." + exception);
                    }
                    preparedStatement.setBytes(n, byArray);
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported JDBC type: " + n2);
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Field not accessible: " + illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
    }

    public static void copyFieldFromDB(final ResultSet resultSet, final int n, final Field field, final Object object, final int n2) throws SQLException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws SQLException {
                    JDBCUtils.copyFieldFromDBInternal(resultSet, n, field, object, n2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (SQLException)privilegedActionException.getException();
        }
    }

    private static void copyFieldFromDBInternal(ResultSet resultSet, int n, Field field, Object object, int n2) throws SQLException {
        boolean bl = field.getType().isPrimitive();
        try {
            switch (n2) {
                case 4: {
                    if (bl) {
                        field.setInt(object, resultSet.getInt(n));
                        break;
                    }
                    int n3 = resultSet.getInt(n);
                    if (resultSet.wasNull()) {
                        field.set(object, null);
                        break;
                    }
                    field.set(object, new Integer(n3));
                    break;
                }
                case -7: {
                    if (bl) {
                        field.setBoolean(object, resultSet.getBoolean(n));
                        break;
                    }
                    boolean bl2 = resultSet.getBoolean(n);
                    if (resultSet.wasNull()) {
                        field.set(object, null);
                        break;
                    }
                    field.set(object, new Boolean(bl2));
                    break;
                }
                case -6: {
                    if (bl) {
                        field.setByte(object, resultSet.getByte(n));
                        break;
                    }
                    byte by = resultSet.getByte(n);
                    if (resultSet.wasNull()) {
                        field.set(object, null);
                        break;
                    }
                    field.set(object, new Byte(by));
                    break;
                }
                case 1: {
                    if (bl) {
                        field.setChar(object, resultSet.getString(n).charAt(0));
                        break;
                    }
                    String string = resultSet.getString(n);
                    if (string == null) {
                        field.set(object, null);
                        break;
                    }
                    field.set(object, new Character(string.charAt(0)));
                    break;
                }
                case 5: {
                    if (bl) {
                        field.setShort(object, resultSet.getShort(n));
                        break;
                    }
                    short s = resultSet.getShort(n);
                    if (resultSet.wasNull()) {
                        field.set(object, null);
                        break;
                    }
                    field.set(object, new Short(s));
                    break;
                }
                case -5: {
                    if (bl) {
                        field.setLong(object, resultSet.getLong(n));
                        break;
                    }
                    long l = resultSet.getLong(n);
                    if (resultSet.wasNull()) {
                        field.set(object, null);
                        break;
                    }
                    field.set(object, new Long(l));
                    break;
                }
                case 7: {
                    if (bl) {
                        field.setFloat(object, resultSet.getFloat(n));
                        break;
                    }
                    float f = resultSet.getFloat(n);
                    if (resultSet.wasNull()) {
                        field.set(object, null);
                        break;
                    }
                    field.set(object, new Float(f));
                    break;
                }
                case 8: {
                    if (bl) {
                        field.setDouble(object, resultSet.getDouble(n));
                        break;
                    }
                    double d = resultSet.getDouble(n);
                    if (resultSet.wasNull()) {
                        field.set(object, null);
                        break;
                    }
                    field.set(object, new Double(d));
                    break;
                }
                case -4: {
                    field.set(object, resultSet.getBytes(n));
                    break;
                }
                case 12: {
                    field.set(object, resultSet.getString(n));
                    break;
                }
                case 2: {
                    field.set(object, resultSet.getBigDecimal(n));
                    break;
                }
                case 91: {
                    field.set(object, resultSet.getDate(n));
                    break;
                }
                case 92: {
                    field.set(object, resultSet.getTime(n));
                    break;
                }
                case 93: {
                    field.set(object, resultSet.getTimestamp(n));
                    break;
                }
                case 2000: {
                    Object object2;
                    byte[] byArray = resultSet.getBytes(n);
                    if (resultSet.wasNull() || byArray.length == 0) {
                        object2 = null;
                    } else {
                        try {
                            object2 = EJBUtils.deserializeObject(byArray, field.getDeclaringClass().getClassLoader());
                        }
                        catch (Exception exception) {
                            throw new RuntimeException("Unable to deserialize field: " + exception);
                        }
                    }
                    field.set(object, object2);
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported JDBC type: " + n2);
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Field not accessible: " + illegalAccessException);
        }
    }

    public static Object getObjFromDB(ResultSet resultSet, int n, ClassLoader classLoader) throws SQLException {
        Object object;
        switch (n) {
            case 4: {
                object = new Integer(resultSet.getInt(1));
                break;
            }
            case -7: {
                object = new Boolean(resultSet.getBoolean(1));
                break;
            }
            case -6: {
                object = new Byte(resultSet.getByte(1));
                break;
            }
            case 1: {
                object = new Character(resultSet.getString(1).charAt(0));
                break;
            }
            case 5: {
                object = new Short(resultSet.getShort(1));
                break;
            }
            case -5: {
                object = new Long(resultSet.getLong(1));
                break;
            }
            case 7: {
                object = new Float(resultSet.getFloat(1));
                break;
            }
            case 8: {
                object = new Double(resultSet.getDouble(1));
                break;
            }
            case -4: {
                object = resultSet.getBytes(1);
                break;
            }
            case 12: {
                object = resultSet.getString(1);
                break;
            }
            case 2: {
                object = resultSet.getBigDecimal(1);
                break;
            }
            case 91: {
                object = resultSet.getDate(1);
                break;
            }
            case 92: {
                object = resultSet.getTime(1);
                break;
            }
            case 93: {
                object = resultSet.getTimestamp(1);
                break;
            }
            case 2000: {
                try {
                    object = EJBUtils.deserializeObject(resultSet.getBytes(1), classLoader);
                    break;
                }
                catch (Exception exception) {
                    throw new RuntimeException("Unable to deserialize object." + exception);
                }
            }
            default: {
                throw new RuntimeException("Unsupported JDBC type: " + n);
            }
        }
        return resultSet.wasNull() ? null : object;
    }
}

