/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.ejbql;

import com.sun.ejb.ejbql.AbstractSchemaName;
import com.sun.ejb.ejbql.BinaryOperator;
import com.sun.ejb.ejbql.BinaryOperatorExpression;
import com.sun.ejb.ejbql.CmrField;
import com.sun.ejb.ejbql.CollectionIdentificationVar;
import com.sun.ejb.ejbql.EjbQLQuery;
import com.sun.ejb.ejbql.Element;
import com.sun.ejb.ejbql.Expression;
import com.sun.ejb.ejbql.ExpressionBase;
import com.sun.ejb.ejbql.FromClause;
import com.sun.ejb.ejbql.IdentificationVar;
import com.sun.ejb.ejbql.Literal;
import com.sun.ejb.ejbql.NavigationExpression;
import com.sun.ejb.ejbql.NavigationOperator;
import com.sun.ejb.ejbql.NullExpression;
import com.sun.ejb.ejbql.Operator;
import com.sun.ejb.ejbql.OperatorExpression;
import com.sun.ejb.ejbql.RelationshipInfo;
import com.sun.ejb.ejbql.SelectClause;
import com.sun.ejb.ejbql.SelectField;
import com.sun.ejb.ejbql.Symbol;
import com.sun.ejb.ejbql.UnaryOperator;
import com.sun.ejb.ejbql.UnaryOperatorExpression;
import com.sun.ejb.ejbql.VisitorAdapter;
import com.sun.ejb.ejbql.WhereClause;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class CodeGeneratingVisitor
extends VisitorAdapter {
    private static final boolean debug = false;
    private EjbQLQuery query_;
    private StringBuffer sqlString_;
    private StringBuffer selectString_;
    private StringBuffer fromString_;
    private StringBuffer whereString_;
    private StringBuffer derivedConditionsString_;
    private Hashtable tableAliasPaths_;
    private Hashtable joinTableAliasPaths_;
    private Hashtable joinPathExprs_;
    private Hashtable fromClauseEntries_;
    private int tempTableAliasIndex_;
    private static final String SPACE = " ";
    private static final String PATH_EXPR_NAME_SEP = ".";
    private static final String TEMP_ALIAS_ROOT = "@tmp";
    private static final String ESCAPE_FUNCTION_BEGIN = "{fn ";
    private static final String ESCAPE_FUNCTION_END = "}";
    private int numSimpleConditionalExpr;

    public CodeGeneratingVisitor(EjbQLQuery ejbQLQuery) {
        super(1);
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.query_ = ejbQLQuery;
        this.selectString_ = new StringBuffer();
        this.fromString_ = new StringBuffer();
        this.whereString_ = new StringBuffer();
        this.derivedConditionsString_ = new StringBuffer();
        this.tableAliasPaths_ = new Hashtable();
        this.joinPathExprs_ = new Hashtable();
        this.joinTableAliasPaths_ = new Hashtable();
        this.fromClauseEntries_ = new Hashtable();
        AbstractSchemaName abstractSchemaName = this.query_.getAbstractSchema();
        ListIterator listIterator = this.query_.getFromClause().getChildren(this.getTraversalType());
        while (listIterator.hasNext()) {
            object4 = (IdentificationVar)listIterator.next();
            object3 = ((IdentificationVar)object4).getName();
            this.addTableToFromClause(((IdentificationVar)object4).getTableName(), this.surroundWithQuotes((String)object3));
        }
        object4 = this.query_.getFromClause().getChildren(this.getTraversalType());
        while (object4.hasNext()) {
            object3 = (IdentificationVar)object4.next();
            if (!((IdentificationVar)object3).isCollectionIdentVar()) continue;
            object2 = (CollectionIdentificationVar)object3;
            object = ((CollectionIdentificationVar)object2).getNavigationExpression();
            String string = this.getNavExprPrefix((NavigationExpression)object);
            String string2 = ((IdentificationVar)object3).getName();
            this.tableAliasPaths_.put(string, this.surroundWithQuotes(string2));
            this.processPathExpr((NavigationExpression)object);
        }
        this.numSimpleConditionalExpr = 0;
        if (this.query_.hasWhereClause()) {
            object3 = this.query_.getWhereClause();
            object2 = new SimpleConditionalExprVisitor();
            object = ((SimpleConditionalExprVisitor)object2).getSimpleConditionalExpressions((Element)object3);
            this.numSimpleConditionalExpr = object.size();
        }
    }

    public String generateSql() {
        this.tempTableAliasIndex_ = 1;
        this.query_.accept(this);
        if (this.whereString_.length() > 0) {
            this.whereString_.insert(0, "WHERE ");
            if (this.derivedConditionsString_.length() > 0) {
                this.derivedConditionsString_.insert(0, " AND ");
            }
        } else if (this.derivedConditionsString_.length() > 0) {
            this.derivedConditionsString_.insert(0, "WHERE ");
        }
        String string = this.selectString_.toString() + this.fromString_.toString() + this.whereString_.toString() + this.derivedConditionsString_.toString();
        return string;
    }

    private void processPathExpr(NavigationExpression navigationExpression) {
        this.processPathExpr(navigationExpression, this.derivedConditionsString_);
    }

    private void processPathExpr(NavigationExpression navigationExpression, StringBuffer stringBuffer) {
        ListIterator listIterator = navigationExpression.getChildren(this.getTraversalType());
        IdentificationVar identificationVar = (IdentificationVar)listIterator.next();
        String string = new String(identificationVar.getName());
        ExpressionBase expressionBase = identificationVar;
        String string2 = this.surroundWithQuotes(identificationVar.getName());
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        while (listIterator.hasNext()) {
            String string3;
            NavigationOperator navigationOperator = (NavigationOperator)listIterator.next();
            Symbol symbol = (Symbol)listIterator.next();
            if (symbol.isCmpField()) break;
            CmrField cmrField = (CmrField)symbol;
            if (!listIterator.hasNext() && !cmrField.hasJoinTable()) break;
            string = string + PATH_EXPR_NAME_SEP + symbol.getName();
            boolean bl = true;
            String string4 = null;
            if (this.tableAliasPaths_.containsKey(string)) {
                if (this.joinPathExprs_.containsKey(string)) {
                    bl = false;
                }
                string4 = (String)this.tableAliasPaths_.get(string);
            } else {
                string4 = this.generateTempTableAlias();
                this.tableAliasPaths_.put(string, string4);
                this.addTableToFromClause(symbol.getTableName(), string4);
            }
            RelationshipInfo relationshipInfo = new RelationshipInfo(cmrField);
            if (bl) {
                String string5 = null;
                if (cmrField.hasJoinTable()) {
                    string5 = this.generateTempTableAlias();
                    this.joinTableAliasPaths_.put(string, string5);
                    this.addTableToFromClause(relationshipInfo.getJoinTableName(), string5);
                }
                string3 = this.generateJoin(relationshipInfo, string2, string5, string4);
                this.joinPathExprs_.put(string, string3);
            } else {
                string3 = (String)this.joinPathExprs_.get(string);
            }
            if (n > 0) {
                stringBuffer2.append(" AND ");
            }
            ++n;
            stringBuffer2.append(string3);
            if (!listIterator.hasNext()) continue;
            expressionBase = cmrField;
            string2 = string4;
        }
        if (n > 0) {
            this.parenthesize(stringBuffer2);
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" AND ");
            }
            stringBuffer.append(stringBuffer2.toString());
        }
    }

    private int countJoins(NavigationExpression navigationExpression) {
        ListIterator listIterator = navigationExpression.getChildren(this.getTraversalType());
        IdentificationVar identificationVar = (IdentificationVar)listIterator.next();
        int n = 0;
        while (listIterator.hasNext()) {
            NavigationOperator navigationOperator = (NavigationOperator)listIterator.next();
            Symbol symbol = (Symbol)listIterator.next();
            if (symbol.isCmpField()) break;
            CmrField cmrField = (CmrField)symbol;
            if (!listIterator.hasNext() && !cmrField.hasJoinTable()) break;
            ++n;
        }
        return n;
    }

    public void visitSelectClause(SelectClause selectClause) {
        Object object;
        this.sqlString_ = this.selectString_;
        this.sqlString_.append("SELECT ");
        Expression expression = selectClause.getExpression();
        String string = null;
        Iterator iterator = null;
        if (expression.isOperatorExpression()) {
            object = (OperatorExpression)expression;
            Operator operator = object.getOperator();
            if (operator.isUnary()) {
                this.sqlString_.append("* ");
                return;
            }
            BinaryOperatorExpression binaryOperatorExpression = (BinaryOperatorExpression)object;
            NavigationExpression navigationExpression = (NavigationExpression)binaryOperatorExpression.getFirstExpression();
            SelectField selectField = (SelectField)binaryOperatorExpression.getSecondExpression();
            string = this.getTableAliasFromNavExpr(navigationExpression);
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(selectField.getFieldName());
            iterator = hashSet.iterator();
        }
        if (this.query_.hasDistinctResults()) {
            this.sqlString_.append("DISTINCT ");
        }
        if (string == null) {
            if (expression.isNavigationExpression()) {
                object = (NavigationExpression)expression;
                this.processPathExpr((NavigationExpression)object);
                string = this.getTableAliasFromNavExpr((NavigationExpression)object);
                iterator = ((NavigationExpression)object).getFieldNames();
                if (((NavigationExpression)object).endsInCmrField() && !((NavigationExpression)object).getLastExpressionCmr().hasJoinTable()) {
                    this.addNotNullChecks((NavigationExpression)object);
                }
            } else {
                object = (IdentificationVar)expression;
                string = this.getTableAliasFromIdentVar((IdentificationVar)object);
                iterator = ((IdentificationVar)object).getFieldNames();
            }
        }
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            this.sqlString_.append(string + PATH_EXPR_NAME_SEP + (String)object + SPACE);
            if (!iterator.hasNext()) continue;
            this.sqlString_.append(", ");
        }
    }

    public void visitFromClause(FromClause fromClause) {
    }

    public void visitWhereClause(WhereClause whereClause) {
        this.sqlString_ = this.whereString_;
        super.visitWhereClause(whereClause);
    }

    public void visitLikeExpression(OperatorExpression operatorExpression) {
        this.visitOperatorExpression(operatorExpression);
    }

    public void visitEmptyCollectionExpression(OperatorExpression operatorExpression) {
        UnaryOperatorExpression unaryOperatorExpression = (UnaryOperatorExpression)operatorExpression;
        UnaryOperator unaryOperator = (UnaryOperator)unaryOperatorExpression.getOperator();
        NavigationExpression navigationExpression = (NavigationExpression)unaryOperatorExpression.getExpression();
        String string = this.generateSubQuery(navigationExpression);
        this.sqlString_.append("( ");
        if (unaryOperator.equals(UnaryOperator.IS_EMPTY)) {
            this.sqlString_.append("NOT EXISTS ");
        } else {
            this.sqlString_.append("EXISTS ");
        }
        this.sqlString_.append("(" + string + ")");
        this.sqlString_.append(")");
    }

    public void visitNullComparisonExpression(OperatorExpression operatorExpression) {
        UnaryOperatorExpression unaryOperatorExpression = (UnaryOperatorExpression)operatorExpression;
        UnaryOperator unaryOperator = (UnaryOperator)unaryOperatorExpression.getOperator();
        NavigationExpression navigationExpression = (NavigationExpression)unaryOperatorExpression.getExpression();
        Symbol symbol = navigationExpression.getLastExpression();
        StringBuffer stringBuffer = new StringBuffer();
        if (symbol.isCmrField() && ((CmrField)symbol).hasJoinTable()) {
            String string = this.generateSubQuery(navigationExpression);
            if (unaryOperator.equals(UnaryOperator.IS_NULL)) {
                stringBuffer.append("NOT EXISTS ");
            } else {
                stringBuffer.append("EXISTS ");
            }
            stringBuffer.append("( " + string + " ) ");
        } else {
            if (this.exprNeedsIsolation(unaryOperatorExpression)) {
                String string = this.generateSimpleConditionSubQuery(unaryOperatorExpression);
                this.sqlString_.append(" EXISTS (" + string + ") ");
                return;
            }
            this.processPathExpr(navigationExpression, stringBuffer);
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" AND ");
            }
            String string = (String)unaryOperatorExpression.getPrintStrings().next();
            String string2 = this.getTableAliasFromNavExpr(navigationExpression);
            Iterator iterator = navigationExpression.getFieldNames();
            int n = 0;
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                ++n;
                stringBuffer.append(string2 + PATH_EXPR_NAME_SEP + string3 + SPACE);
                stringBuffer.append(string + SPACE);
                if (!iterator.hasNext()) continue;
                stringBuffer.append("AND ");
            }
        }
        this.parenthesize(stringBuffer);
        this.sqlString_.append(stringBuffer.toString());
    }

    private String generateSimpleConditionSubQuery(OperatorExpression operatorExpression) {
        EjbQLQuery ejbQLQuery = new EjbQLQuery(this.query_.getPersistenceDescriptor(), this.query_.getQueryMethod(), true);
        UnaryOperatorExpression unaryOperatorExpression = new UnaryOperatorExpression(new NullExpression(), UnaryOperator.SELECT_ALL);
        ejbQLQuery.setSelectClause(new SelectClause(unaryOperatorExpression));
        ejbQLQuery.setWhereClause(new WhereClause(operatorExpression));
        CodeGeneratingVisitor codeGeneratingVisitor = new CodeGeneratingVisitor(ejbQLQuery);
        String string = codeGeneratingVisitor.generateSql();
        return string;
    }

    private String generateSubQuery(NavigationExpression navigationExpression) {
        IdentificationVar identificationVar = navigationExpression.getFirstExpression();
        UnaryOperatorExpression unaryOperatorExpression = new UnaryOperatorExpression(identificationVar, UnaryOperator.SELECT_ALL);
        return this.generateSubQuery(navigationExpression, new SelectClause(unaryOperatorExpression));
    }

    private String generateSubQuery(NavigationExpression navigationExpression, SelectClause selectClause) {
        EjbQLQuery ejbQLQuery = new EjbQLQuery(this.query_.getPersistenceDescriptor(), this.query_.getQueryMethod(), true);
        IdentificationVar identificationVar = navigationExpression.getFirstExpression();
        ejbQLQuery.setSelectClause(selectClause);
        FromClause fromClause = ejbQLQuery.getFromClause();
        fromClause.addIdentVar(new CollectionIdentificationVar("@_" + identificationVar.getName(), navigationExpression));
        CodeGeneratingVisitor codeGeneratingVisitor = new CodeGeneratingVisitor(ejbQLQuery);
        String string = codeGeneratingVisitor.generateSql();
        return string;
    }

    public void visitInExpression(OperatorExpression operatorExpression) {
        BinaryOperatorExpression binaryOperatorExpression = (BinaryOperatorExpression)operatorExpression;
        if (this.exprNeedsIsolation(binaryOperatorExpression)) {
            String string = this.generateSimpleConditionSubQuery(binaryOperatorExpression);
            this.sqlString_.append(" EXISTS (" + string + ") ");
            return;
        }
        BinaryOperator binaryOperator = (BinaryOperator)binaryOperatorExpression.getOperator();
        NavigationExpression navigationExpression = (NavigationExpression)binaryOperatorExpression.getFirstExpression();
        Expression expression = binaryOperatorExpression.getSecondExpression();
        this.visitNavigationExpression(navigationExpression);
        ListIterator listIterator = expression.getChildren(this.getTraversalType());
        this.sqlString_.append((binaryOperator.equals(BinaryOperator.IN_STRINGS) ? "IN" : "NOT IN") + " (");
        while (listIterator.hasNext()) {
            Expression expression2 = (Expression)listIterator.next();
            expression2.accept(this);
            if (!listIterator.hasNext()) continue;
            this.sqlString_.append(" , ");
        }
        this.sqlString_.append(")");
    }

    public void visitMemberOfExpression(OperatorExpression operatorExpression) {
        Object object;
        BinaryOperatorExpression binaryOperatorExpression = (BinaryOperatorExpression)operatorExpression;
        BinaryOperator binaryOperator = (BinaryOperator)operatorExpression.getOperator();
        Expression expression = binaryOperatorExpression.getFirstExpression();
        NavigationExpression navigationExpression = (NavigationExpression)binaryOperatorExpression.getSecondExpression();
        if (expression.isNavigationExpression() && this.exprNeedsIsolation(binaryOperatorExpression, (NavigationExpression)expression)) {
            String string = this.generateSimpleConditionSubQuery(binaryOperatorExpression);
            this.sqlString_.append(" EXISTS (" + string + ") ");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        Iterator iterator = null;
        if (expression.isNavigationExpression()) {
            object = (NavigationExpression)expression;
            this.processPathExpr((NavigationExpression)object, stringBuffer);
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" AND ");
            }
            string = this.getTableAliasFromNavExpr((NavigationExpression)object);
            iterator = ((NavigationExpression)object).getFieldNames();
        } else if (expression.isIdentificationVar()) {
            object = (IdentificationVar)expression;
            string = this.getTableAliasFromIdentVar((IdentificationVar)object);
            iterator = ((IdentificationVar)object).getFieldNames();
        }
        object = navigationExpression.getFieldNames();
        while (object.hasNext()) {
            String string2 = string == null ? "?" : string + PATH_EXPR_NAME_SEP + iterator.next();
            stringBuffer.append(string2 + SPACE);
            stringBuffer.append(binaryOperator.equals(BinaryOperator.MEMBER_OF) ? "IN " : "NOT IN ");
            SelectField selectField = new SelectField((String)object.next());
            BinaryOperatorExpression binaryOperatorExpression2 = new BinaryOperatorExpression(navigationExpression, selectField, BinaryOperator.SELECT_FIELD);
            String string3 = this.generateSubQuery(navigationExpression, new SelectClause(binaryOperatorExpression2));
            stringBuffer.append(this.parenthesize(string3));
            if (!object.hasNext()) continue;
            stringBuffer.append(" AND ");
        }
        this.parenthesize(stringBuffer);
        this.sqlString_.append(stringBuffer.toString());
    }

    public void visitNavigationExpression(NavigationExpression navigationExpression) {
        this.processPathExpr(navigationExpression);
        String string = this.getTableAliasFromNavExpr(navigationExpression);
        String string2 = (String)navigationExpression.getFieldNames().next();
        this.sqlString_.append(string);
        this.sqlString_.append(NavigationOperator.CMP_OP.getPrintString());
        this.sqlString_.append(string2 + SPACE);
    }

    public void visitOperatorExpression(OperatorExpression operatorExpression) {
        Operator operator = operatorExpression.getOperator();
        Iterator iterator = operatorExpression.getPrintStrings();
        ListIterator listIterator = operatorExpression.getChildren(this.getTraversalType());
        if (this.exprNeedsIsolation(operatorExpression)) {
            String string = this.generateSimpleConditionSubQuery(operatorExpression);
            this.sqlString_.append(" EXISTS (" + string + ") ");
            return;
        }
        this.sqlString_.append("(");
        if (operator.isFunction()) {
            String string = (String)iterator.next();
            this.sqlString_.append(ESCAPE_FUNCTION_BEGIN);
            this.sqlString_.append(string);
            this.sqlString_.append("(");
            while (listIterator.hasNext()) {
                Expression expression = (Expression)listIterator.next();
                expression.accept(this);
                if (!listIterator.hasNext()) continue;
                this.sqlString_.append(" , ");
            }
            this.sqlString_.append(") }");
        } else if (operator.isUnary()) {
            UnaryOperator unaryOperator = (UnaryOperator)operator;
            Expression expression = (Expression)listIterator.next();
            String string = (String)iterator.next();
            if (unaryOperator.isPreOperator()) {
                this.sqlString_.append(string + SPACE);
                expression.accept(this);
            } else {
                expression.accept(this);
                this.sqlString_.append(SPACE + string);
            }
        } else {
            Expression expression;
            boolean bl = false;
            if (operator.equals(BinaryOperator.EQUAL) || operator.equals(BinaryOperator.NOT_EQUAL)) {
                expression = (BinaryOperatorExpression)operatorExpression;
                Expression expression2 = ((BinaryOperatorExpression)expression).getFirstExpression();
                Expression expression3 = ((BinaryOperatorExpression)expression).getSecondExpression();
                if (expression2.isIdentificationVar() || expression2.isNavigationExpression() && ((NavigationExpression)expression2).endsInCmrField()) {
                    this.generatePersistentObjectComparisonSQL((BinaryOperatorExpression)expression);
                    bl = true;
                }
            }
            if (!bl) {
                while (listIterator.hasNext()) {
                    expression = (Expression)listIterator.next();
                    expression.accept(this);
                    if (!iterator.hasNext()) continue;
                    this.sqlString_.append(SPACE + iterator.next() + SPACE);
                }
            }
        }
        this.sqlString_.append(")");
    }

    private boolean exprNeedsIsolation(OperatorExpression operatorExpression, NavigationExpression navigationExpression) {
        return operatorExpression.isSimpleCondition() && this.numSimpleConditionalExpr > 1 && !this.query_.isSubQuery() && this.countJoins(navigationExpression) > 0;
    }

    private boolean exprNeedsIsolation(OperatorExpression operatorExpression) {
        boolean bl = false;
        if (operatorExpression.isSimpleCondition() && this.numSimpleConditionalExpr > 1 && !this.query_.isSubQuery()) {
            NavigationExpressionVisitor navigationExpressionVisitor = new NavigationExpressionVisitor();
            List list = navigationExpressionVisitor.getNavigationExpressions(operatorExpression);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                NavigationExpression navigationExpression = (NavigationExpression)iterator.next();
                if (this.countJoins(navigationExpression) <= 0) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void visitLiteral(Literal literal) {
        this.sqlString_.append(literal.toSql() + SPACE);
    }

    public void visitSymbol(Symbol symbol) {
        this.sqlString_.append(symbol.toSql() + SPACE);
    }

    private String getTableAliasFromIdentVar(IdentificationVar identificationVar) {
        String string;
        if (identificationVar.isRangeIdentVar()) {
            string = this.surroundWithQuotes(identificationVar.getName());
        } else {
            CollectionIdentificationVar collectionIdentificationVar = (CollectionIdentificationVar)identificationVar;
            NavigationExpression navigationExpression = collectionIdentificationVar.getNavigationExpression();
            string = this.getTableAliasFromNavExpr(navigationExpression);
        }
        return string;
    }

    private String getTableAliasFromNavExpr(NavigationExpression navigationExpression) {
        String string = this.getNavExprPrefix(navigationExpression);
        String string2 = this.surroundWithQuotes(string);
        Symbol symbol = navigationExpression.getLastExpression();
        if (symbol.isCmrField() && ((CmrField)symbol).hasJoinTable()) {
            if (this.joinTableAliasPaths_.containsKey(string)) {
                string2 = (String)this.joinTableAliasPaths_.get(string);
            }
        } else if (this.tableAliasPaths_.containsKey(string)) {
            string2 = (String)this.tableAliasPaths_.get(string);
        }
        return string2;
    }

    private String getTableNameFromNavExpr(NavigationExpression navigationExpression) {
        String string = this.getTableAliasFromNavExpr(navigationExpression);
        return (String)this.fromClauseEntries_.get(string);
    }

    private String getNavExprPrefix(NavigationExpression navigationExpression) {
        ListIterator listIterator = navigationExpression.getChildren(this.getTraversalType());
        IdentificationVar identificationVar = (IdentificationVar)listIterator.next();
        StringBuffer stringBuffer = new StringBuffer(identificationVar.getName());
        while (listIterator.hasNext()) {
            NavigationOperator navigationOperator = (NavigationOperator)listIterator.next();
            Symbol symbol = (Symbol)listIterator.next();
            if (!listIterator.hasNext() && (!symbol.isCmrField() || !((CmrField)symbol).hasJoinTable())) continue;
            stringBuffer.append(PATH_EXPR_NAME_SEP + symbol.getName());
        }
        return stringBuffer.toString();
    }

    private void addNotNullChecks(NavigationExpression navigationExpression) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getTableAliasFromNavExpr(navigationExpression);
        Iterator iterator = navigationExpression.getFieldNames();
        String string2 = UnaryOperator.IS_NOT_NULL.getPrintString();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (stringBuffer.length() > 0) {
                stringBuffer.append("AND ");
            }
            stringBuffer.append(string + PATH_EXPR_NAME_SEP + string3 + SPACE + string2 + SPACE);
        }
        this.parenthesize(stringBuffer);
        if (this.derivedConditionsString_.length() > 0) {
            this.derivedConditionsString_.append(" AND ");
        }
        this.derivedConditionsString_.append(stringBuffer.toString());
    }

    /*
     * Unable to fully structure code
     */
    private String generateJoin(RelationshipInfo var1_1, String var2_2, String var3_3, String var4_4) {
        block4: {
            var5_5 = var1_1.getSourceFields();
            var6_6 = var1_1.getSinkFields();
            var7_7 = new StringBuffer();
            if (!var1_1.hasJoinTable()) ** GOTO lbl30
            var8_8 = var1_1.getJoinSourceFields();
            var9_9 = var1_1.getJoinSinkFields();
            if (var4_4 == null) ** GOTO lbl24
            while (var8_8.hasNext()) {
                this.join(var2_2, (String)var5_5.next(), var3_3, (String)var8_8.next(), var7_7);
                var7_7.append(" AND ");
            }
            while (var9_9.hasNext()) {
                this.join(var3_3, (String)var9_9.next(), var4_4, (String)var6_6.next(), var7_7);
                if (!var9_9.hasNext()) continue;
                var7_7.append(" AND ");
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                this.join(var2_2, (String)var5_5.next(), var3_3, (String)var8_8.next(), var7_7);
                if (!var8_8.hasNext()) continue;
                var7_7.append(" AND ");
lbl24:
                // 3 sources

                ** while (var8_8.hasNext())
            }
lbl25:
            // 1 sources

            break block4;
lbl-1000:
            // 1 sources

            {
                this.join(var2_2, (String)var5_5.next(), var4_4, (String)var6_6.next(), var7_7);
                if (!var5_5.hasNext()) continue;
                var7_7.append(" AND ");
lbl30:
                // 3 sources

                ** while (var5_5.hasNext())
            }
        }
        this.parenthesize(var7_7);
        return var7_7.toString();
    }

    private void join(String string, String string2, String string3, String string4, StringBuffer stringBuffer) {
        stringBuffer.append(string + PATH_EXPR_NAME_SEP + string2);
        stringBuffer.append(" = ");
        stringBuffer.append(string3 + PATH_EXPR_NAME_SEP + string4);
    }

    private void generatePersistentObjectComparisonSQL(BinaryOperatorExpression binaryOperatorExpression) {
        Object object;
        Expression expression = binaryOperatorExpression.getFirstExpression();
        Expression expression2 = binaryOperatorExpression.getSecondExpression();
        String string = null;
        String string2 = null;
        Iterator iterator = new HashSet().iterator();
        Iterator iterator2 = new HashSet().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        if (expression.isNavigationExpression()) {
            object = (NavigationExpression)expression;
            this.processPathExpr((NavigationExpression)object, stringBuffer2);
            string = this.getTableAliasFromNavExpr((NavigationExpression)object);
            iterator = ((NavigationExpression)object).getFieldNames();
        } else {
            object = (IdentificationVar)expression;
            string = this.getTableAliasFromIdentVar((IdentificationVar)object);
            iterator = ((IdentificationVar)object).getFieldNames();
        }
        if (expression2.isNavigationExpression()) {
            object = (NavigationExpression)expression2;
            this.processPathExpr((NavigationExpression)object, stringBuffer2);
            string2 = this.getTableAliasFromNavExpr((NavigationExpression)object);
            iterator2 = ((NavigationExpression)object).getFieldNames();
        } else if (expression2.isIdentificationVar()) {
            object = (IdentificationVar)expression2;
            string2 = this.getTableAliasFromIdentVar((IdentificationVar)object);
            iterator2 = ((IdentificationVar)object).getFieldNames();
        }
        object = (String)binaryOperatorExpression.getPrintStrings().next();
        int n = 0;
        while (iterator.hasNext() || iterator2.hasNext()) {
            if (n > 0) {
                stringBuffer.append("AND ");
            }
            ++n;
            String string3 = (String)iterator.next();
            stringBuffer.append(string + PATH_EXPR_NAME_SEP + string3 + SPACE);
            stringBuffer.append((String)object + SPACE);
            if (string2 == null) {
                stringBuffer.append("? ");
                continue;
            }
            String string4 = (String)iterator2.next();
            stringBuffer.append(string2 + PATH_EXPR_NAME_SEP + string4 + SPACE);
        }
        if (n > 1) {
            this.parenthesize(stringBuffer);
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append(" AND " + stringBuffer2.toString());
        }
        this.parenthesize(stringBuffer);
        this.sqlString_.append(stringBuffer.toString());
    }

    private String generateTempTableAlias() {
        String string = TEMP_ALIAS_ROOT + this.tempTableAliasIndex_;
        ++this.tempTableAliasIndex_;
        return this.surroundWithQuotes(string);
    }

    private String parenthesize(String string) {
        return "(" + string + ")";
    }

    private void parenthesize(StringBuffer stringBuffer) {
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, "(");
            stringBuffer.append(")");
        }
    }

    private String surroundWithQuotes(String string) {
        return "\"" + string + "\"";
    }

    private void addTableToFromClause(String string, String string2) {
        if (this.fromString_.length() > 0) {
            this.fromString_.append(", ");
        } else {
            this.fromString_.insert(0, "FROM ");
        }
        this.fromString_.append(string);
        if (!string.endsWith(SPACE)) {
            this.fromString_.append(SPACE);
        }
        this.fromString_.append(string2 + SPACE);
        this.fromClauseEntries_.put(string2, string);
    }

    private static class SimpleConditionalExprVisitor
    extends VisitorAdapter {
        private List simpleConditionalExpressions_ = new LinkedList();

        public SimpleConditionalExprVisitor() {
            super(1);
        }

        public List getSimpleConditionalExpressions(Element element) {
            this.simpleConditionalExpressions_ = new LinkedList();
            element.accept(this);
            return this.simpleConditionalExpressions_;
        }

        public void visitOperatorExpression(OperatorExpression operatorExpression) {
            if (operatorExpression.isSimpleCondition()) {
                this.simpleConditionalExpressions_.add(operatorExpression);
            } else {
                super.visitOperatorExpression(operatorExpression);
            }
        }
    }

    private static class NavigationExpressionVisitor
    extends VisitorAdapter {
        private List navigationExpressions_ = new LinkedList();

        public NavigationExpressionVisitor() {
            super(1);
        }

        public List getNavigationExpressions(Element element) {
            this.navigationExpressions_ = new LinkedList();
            element.accept(this);
            return this.navigationExpressions_;
        }

        public void visitNavigationExpression(NavigationExpression navigationExpression) {
            this.navigationExpressions_.add(navigationExpression);
        }
    }
}

