/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.javax.rmi;

import com.sun.corba.se.internal.util.RepositoryId;
import com.sun.corba.se.internal.util.Utility;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteStub;
import java.rmi.server.UnicastRemoteObject;
import javax.rmi.CORBA.PortableRemoteObjectDelegate;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.ObjectImpl;

public class PortableRemoteObject
implements PortableRemoteObjectDelegate {
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$io$Externalizable;

    public void exportObject(Remote remote) throws RemoteException {
        if (remote == null) {
            throw new NullPointerException("invalid argument");
        }
        if (Util.getTie((Remote)remote) != null) {
            throw new ExportException(remote.getClass().getName() + " already exported");
        }
        Tie tie = Utility.loadTie(remote);
        if (tie != null) {
            Util.registerTarget((Tie)tie, (Remote)remote);
        } else {
            UnicastRemoteObject.exportObject(remote);
        }
    }

    public Remote toStub(Remote remote) throws NoSuchObjectException {
        Remote remote2 = null;
        if (remote == null) {
            throw new NullPointerException("invalid argument");
        }
        if (remote instanceof Stub) {
            return remote;
        }
        if (remote instanceof RemoteStub) {
            return remote;
        }
        Tie tie = Util.getTie((Remote)remote);
        if (tie != null) {
            remote2 = Utility.loadStub(tie, null, null, true);
        } else if (Utility.loadTie(remote) == null) {
            remote2 = RemoteObject.toStub(remote);
        }
        if (remote2 == null) {
            throw new NoSuchObjectException("object not exported");
        }
        return remote2;
    }

    public void unexportObject(Remote remote) throws NoSuchObjectException {
        if (remote == null) {
            throw new NullPointerException("invalid argument");
        }
        if (remote instanceof Stub || remote instanceof RemoteStub) {
            throw new NoSuchObjectException("Can only unexport a server object.");
        }
        Tie tie = Util.getTie((Remote)remote);
        if (tie != null) {
            Util.unexportObject((Remote)remote);
        } else if (Utility.loadTie(remote) == null) {
            UnicastRemoteObject.unexportObject(remote, true);
        } else {
            throw new NoSuchObjectException("Object not exported.");
        }
    }

    public Object narrow(Object object, Class clazz) throws ClassCastException {
        Object object2 = null;
        if (object == null) {
            return null;
        }
        if (clazz == null) {
            throw new NullPointerException("invalid argument");
        }
        Class<?> clazz2 = object.getClass();
        try {
            String string;
            ObjectImpl objectImpl;
            if (clazz.isAssignableFrom(clazz2)) {
                object2 = object;
            } else if (clazz.isInterface() && clazz != (class$java$io$Serializable == null ? (class$java$io$Serializable = PortableRemoteObject.class$("java.io.Serializable")) : class$java$io$Serializable) && clazz != (class$java$io$Externalizable == null ? (class$java$io$Externalizable = PortableRemoteObject.class$("java.io.Externalizable")) : class$java$io$Externalizable) && (objectImpl = (ObjectImpl)object)._is_a(string = RepositoryId.createForAnyType(clazz))) {
                object2 = Utility.loadStub(objectImpl, clazz);
            }
        }
        catch (Exception exception) {
            object2 = null;
        }
        if (object2 == null) {
            throw new ClassCastException();
        }
        return object2;
    }

    public void connect(Remote remote, Remote remote2) throws RemoteException {
        boolean bl;
        if (remote == null || remote2 == null) {
            throw new NullPointerException("invalid argument");
        }
        ORB oRB = null;
        try {
            if (remote2 instanceof ObjectImpl) {
                oRB = ((ObjectImpl)((Object)remote2))._orb();
            } else {
                Tie tie = Util.getTie((Remote)remote2);
                if (tie == null) {
                    if (Utility.loadTie(remote2) != null) {
                        throw new RemoteException("'source' object not exported");
                    }
                } else {
                    oRB = tie.orb();
                }
            }
        }
        catch (SystemException systemException) {
            throw new RemoteException("'source' object not connected");
        }
        Tie tie = null;
        if (remote instanceof RemoteStub) {
            bl = false;
        } else if (remote instanceof Stub) {
            bl = true;
        } else {
            tie = Util.getTie((Remote)remote);
            if (tie != null) {
                bl = true;
            } else {
                if (Utility.loadTie(remote) != null) {
                    throw new RemoteException("'target' servant not exported");
                }
                bl = false;
            }
        }
        if (!bl) {
            if (oRB != null) {
                throw new RemoteException("'source' object exported to IIOP, 'target' is JRMP");
            }
        } else {
            if (oRB == null) {
                throw new RemoteException("'source' object is JRMP, 'target' is IIOP");
            }
            try {
                if (tie != null) {
                    try {
                        ORB oRB2 = tie.orb();
                        if (oRB2 == oRB) {
                            return;
                        }
                        throw new RemoteException("'target' object was already connected");
                    }
                    catch (SystemException systemException) {
                        tie.orb(oRB);
                    }
                } else {
                    ((Stub)remote).connect(oRB);
                }
            }
            catch (SystemException systemException) {
                throw new RemoteException("'target' object was already connected");
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

