/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.iiop;

import com.iplanet.ias.cis.connection.ConnectException;
import com.iplanet.ias.cis.connection.ServerConnection;
import com.iplanet.ias.corba.ee.internal.util.LogWrap;
import com.sun.corba.ee.internal.iiop.Connection;
import com.sun.corba.ee.internal.iiop.ConnectionTable;
import java.util.logging.Level;

public class ListenerThread
extends Thread {
    protected static final int MAX_CLEANUP_RETRIES = 5;
    protected ServerConnection serverConnection;
    protected ConnectionTable connectionTable;
    protected String connectionType;
    private boolean keepRunning = true;
    private boolean isDisabled = false;

    ListenerThread(ConnectionTable connectionTable, ThreadGroup threadGroup, ServerConnection serverConnection, String string) {
        super(threadGroup, "ORB Listener " + serverConnection.getServerEndpoint().getHostName() + ":" + serverConnection.getServerEndpoint().getPort());
        this.serverConnection = serverConnection;
        this.connectionTable = connectionTable;
        this.connectionType = string;
    }

    public ListenerThread(ConnectionTable connectionTable, ServerConnection serverConnection, String string) {
        super("ORB Listener " + serverConnection.getServerEndpoint().getHostName() + ":" + serverConnection.getServerEndpoint().getPort());
        this.serverConnection = serverConnection;
        this.connectionTable = connectionTable;
        this.connectionType = string;
    }

    protected void setDisabled(boolean bl) {
        this.isDisabled = bl;
    }

    public ServerConnection getConnection() {
        return this.serverConnection;
    }

    public void run() {
        int n = 0;
        while (this.keepRunning) {
            try {
                com.iplanet.ias.cis.connection.Connection connection = this.serverConnection.accept();
                connection.setTcpNoDelay(true);
                Connection connection2 = this.connectionTable.getConnection(connection, this.connectionType, this.isDisabled);
                n = 0;
                this.connectionTable.checkConnectionTable();
            }
            catch (ConnectException connectException) {
                LogWrap.logger.log(Level.WARNING, "", connectException);
                if (n == 5 || !this.connectionTable.cleanUp()) continue;
                ++n;
            }
            catch (Exception exception) {
                LogWrap.logger.log(Level.WARNING, "", exception);
            }
        }
    }

    synchronized void shutdown() {
        this.keepRunning = false;
        try {
            this.serverConnection.close();
        }
        catch (ConnectException connectException) {
            LogWrap.logger.log(Level.WARNING, "", connectException);
        }
    }
}

