/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.CosNaming;

import com.iplanet.ias.corba.ee.internal.util.LogWrap;
import com.sun.corba.ee.internal.orbutil.CorbaResourceUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;

final class BootstrapServiceProperties {
    private File propFile;
    private long fileModified;
    private Properties savedProps;
    private Properties allProps;

    public BootstrapServiceProperties(File file, Properties properties) {
        this.propFile = file;
        this.savedProps = properties;
        this.allProps = new Properties(this.savedProps);
    }

    public synchronized String get(String string) {
        this.check();
        return this.allProps.getProperty(string);
    }

    public synchronized String put(String string, String string2, boolean bl) {
        String string3;
        block4: {
            if (!bl) {
                return (String)this.allProps.put(string, string2);
            }
            string3 = (String)this.savedProps.put(string, string2);
            if (this.propFile == null) break block4;
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.propFile);
                this.savedProps.save(fileOutputStream, null);
                fileOutputStream.close();
                this.fileModified = this.propFile.lastModified();
            }
            catch (FileNotFoundException fileNotFoundException) {
                LogWrap.logger.log(Level.WARNING, CorbaResourceUtil.getText("bootstrap.filenotfound", this.propFile.getAbsolutePath()), fileNotFoundException);
            }
            catch (IOException iOException) {
                LogWrap.logger.log(Level.WARNING, CorbaResourceUtil.getText("bootstrap.exception", this.propFile.getAbsolutePath(), iOException.toString()), iOException);
            }
        }
        return string3;
    }

    public synchronized String[] keys() {
        this.check();
        String[] stringArray = null;
        int n = this.allProps.size() + this.savedProps.size();
        if (n > 0) {
            stringArray = new String[n];
            Enumeration<?> enumeration = this.allProps.propertyNames();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                stringArray[n2] = (String)enumeration.nextElement();
                ++n2;
            }
        }
        return stringArray;
    }

    protected void check() {
        block4: {
            if (this.propFile == null) {
                return;
            }
            long l = this.propFile.lastModified();
            if (l <= this.fileModified) break block4;
            try {
                FileInputStream fileInputStream = new FileInputStream(this.propFile);
                this.savedProps.clear();
                this.savedProps.load(fileInputStream);
                fileInputStream.close();
                this.fileModified = l;
            }
            catch (FileNotFoundException fileNotFoundException) {
                LogWrap.logger.log(Level.WARNING, CorbaResourceUtil.getText("bootstrap.filenotfound", this.propFile.getAbsolutePath()), fileNotFoundException);
            }
            catch (IOException iOException) {
                LogWrap.logger.log(Level.WARNING, CorbaResourceUtil.getText("bootstrap.exception", this.propFile.getAbsolutePath(), iOException.toString()), iOException);
            }
        }
    }
}

