/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.Activation;

import com.iplanet.ias.corba.ee.internal.util.LogWrap;
import com.sun.corba.ee.ActivationIDL.Activator;
import com.sun.corba.ee.ActivationIDL.ActivatorHelper;
import com.sun.corba.ee.ActivationIDL.ServerNotActive;
import com.sun.corba.ee.ActivationIDL.ServerNotRegistered;
import com.sun.corba.ee.internal.Activation.CommandHandler;
import com.sun.corba.ee.internal.Activation.ServerTool;
import com.sun.corba.ee.internal.orbutil.CorbaResourceUtil;
import java.io.PrintStream;
import java.util.logging.Level;
import org.omg.CORBA.ORB;

class ShutdownServer
implements CommandHandler {
    static final int illegalServerId = -1;

    ShutdownServer() {
    }

    public String getCommandName() {
        return "shutdown";
    }

    public void printCommandHelp(PrintStream printStream, boolean bl) {
        if (!bl) {
            printStream.println(CorbaResourceUtil.getText("servertool.shutdown"));
        } else {
            printStream.println(CorbaResourceUtil.getText("servertool.shutdown1"));
        }
    }

    public boolean processCommand(String[] stringArray, ORB oRB, PrintStream printStream) {
        int n = -1;
        try {
            if (stringArray.length == 2) {
                if (stringArray[0].equals("-serverid")) {
                    n = Integer.valueOf(stringArray[1]);
                } else if (stringArray[0].equals("-applicationName")) {
                    n = ServerTool.getServerIdForAlias(oRB, stringArray[1]);
                }
            }
            if (n == -1) {
                return true;
            }
            Activator activator = ActivatorHelper.narrow(oRB.resolve_initial_references("ServerActivator"));
            activator.shutdown(n);
            printStream.println(CorbaResourceUtil.getText("servertool.shutdown2"));
        }
        catch (ServerNotActive serverNotActive) {
            LogWrap.logger.log(Level.FINE, CorbaResourceUtil.getText("servertool.servernotrunning"), serverNotActive);
            printStream.println(CorbaResourceUtil.getText("servertool.servernotrunning"));
        }
        catch (ServerNotRegistered serverNotRegistered) {
            LogWrap.logger.log(Level.FINE, CorbaResourceUtil.getText("servertool.nosuchserver"), serverNotRegistered);
            printStream.println(CorbaResourceUtil.getText("servertool.nosuchserver"));
        }
        catch (Exception exception) {
            LogWrap.logger.log(Level.WARNING, "", exception);
        }
        return false;
    }
}

