/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.web.connector.nsapi;

import com.iplanet.ias.web.WebModule;
import com.iplanet.ias.web.connector.nsapi.NSAPIConnector;
import com.iplanet.ias.web.connector.nsapi.NSAPIRequest;
import com.iplanet.ias.web.session.SessionCookieConfig;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;
import org.apache.catalina.connector.HttpResponseBase;
import org.apache.catalina.util.CookieTools;
import org.apache.catalina.util.URL;

final class NSAPIResponse
extends HttpResponseBase {
    protected StringBuffer resultBuffer = new StringBuffer();

    public NSAPIResponse() {
        this.status = 0;
    }

    public void setClosing() {
        super.setClosing();
        ((NSAPIConnector)this.connector).setClosing();
    }

    public void flushBuffer() throws IOException {
        super.flushBuffer();
        this.output.flush();
    }

    public void setBufferSize(int n) {
        super.setBufferSize(n);
        NSAPIConnector nSAPIConnector = (NSAPIConnector)this.connector;
        nSAPIConnector.resize(n);
    }

    private boolean isEncodeable(String string) {
        String string2;
        int n;
        if (string == null) {
            return false;
        }
        if (string.startsWith("#")) {
            return false;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.request.getRequest();
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            return false;
        }
        if (httpServletRequest.isRequestedSessionIdFromCookie()) {
            return false;
        }
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        if (!httpServletRequest.getScheme().equalsIgnoreCase(uRL.getProtocol())) {
            return false;
        }
        if (!httpServletRequest.getServerName().equalsIgnoreCase(uRL.getHost())) {
            return false;
        }
        int n2 = httpServletRequest.getServerPort();
        if (n2 == -1) {
            n2 = "https".equals(httpServletRequest.getScheme()) ? 443 : 80;
        }
        if ((n = uRL.getPort()) == -1) {
            n = "https".equals(uRL.getProtocol()) ? 443 : 80;
        }
        if (n2 != n) {
            return false;
        }
        String string3 = this.getContext().getPath();
        return string3 == null || string3.length() <= 0 || (string2 = uRL.getFile()) != null && string2.startsWith(string3);
    }

    protected void sendHeaders() throws IOException {
        Object object;
        Object object2;
        Object object3;
        if (this.isCommitted()) {
            return;
        }
        if ("HTTP/0.9".equals(this.request.getRequest().getProtocol())) {
            this.committed = true;
            return;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.request.getRequest();
        HttpSession httpSession = httpServletRequest.getSession(false);
        int n = 0;
        Cookie cookie = null;
        if (httpSession != null && httpSession.isNew() && this.getContext() != null && this.getContext().getCookies()) {
            cookie = new Cookie("JSESSIONID", httpSession.getId());
            int n2 = -1;
            Object object4 = null;
            String string = null;
            String string2 = null;
            object3 = null;
            if (this.context != null) {
                object3 = ((WebModule)this.context).getSessionCookieConfig();
                object4 = this.context.getPath();
            }
            if (object3 != null) {
                n2 = ((SessionCookieConfig)object3).getMaxAge();
                object2 = ((SessionCookieConfig)object3).getPath();
                if (object2 != null) {
                    object4 = object2;
                }
                string = ((SessionCookieConfig)object3).getComment();
                string2 = ((SessionCookieConfig)object3).getDomain();
            }
            if (object4 == null || ((String)object4).length() == 0) {
                object4 = "/";
            }
            cookie.setMaxAge(n2);
            cookie.setPath((String)object4);
            if (string2 != null) {
                cookie.setDomain(string2);
            }
            if (httpServletRequest.isSecure()) {
                cookie.setSecure(true);
            }
            n = 1;
        }
        Object[] objectArray = null;
        int n3 = 0;
        int n4 = this.cookies.size();
        n += n4;
        int n5 = this.headers.size();
        if (n5 > 0) {
            object3 = this.headers.keySet().iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                object = (ArrayList)this.headers.get(object2);
                n += ((ArrayList)object).size();
            }
        }
        boolean bl = false;
        if (this.context != null) {
            bl = ((WebModule)this.context).getResponseCTForHeaders();
        }
        if (n > 0) {
            CharSequence charSequence;
            Object object5;
            Object object6;
            objectArray = new Object[n * 2];
            if (n5 > 0) {
                object2 = this.headers.keySet().iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    object6 = (ArrayList)this.headers.get(object);
                    object5 = ((ArrayList)object6).iterator();
                    while (object5.hasNext()) {
                        charSequence = (String)object5.next();
                        objectArray[n3++] = object;
                        objectArray[n3++] = bl ? (Object)((String)charSequence).getBytes(this.getCharacterEncoding()) : charSequence;
                    }
                }
            }
            if (cookie != null) {
                objectArray[n3++] = CookieTools.getCookieHeaderName(cookie);
                object2 = new StringBuffer();
                CookieTools.getUnencodedCookieHeaderValue(cookie, (StringBuffer)object2);
                objectArray[n3++] = bl ? (Object)((StringBuffer)object2).toString().getBytes(this.getCharacterEncoding()) : ((StringBuffer)object2).toString();
            }
            if (n4 > 0) {
                object2 = this.cookies.iterator();
                while (object2.hasNext()) {
                    object = (Cookie)object2.next();
                    object6 = CookieTools.getCookieHeaderName((Cookie)object);
                    if (this.context == null || ((WebModule)this.context).getEncodeCookies()) {
                        object5 = CookieTools.getCookieHeaderValue((Cookie)object);
                    } else {
                        charSequence = new StringBuffer();
                        CookieTools.getUnencodedCookieHeaderValue((Cookie)object, (StringBuffer)charSequence);
                        object5 = ((StringBuffer)charSequence).toString();
                    }
                    objectArray[n3++] = object6;
                    objectArray[n3++] = bl ? (Object)((String)object5).getBytes(this.getCharacterEncoding()) : object5;
                }
            }
        }
        object2 = (NSAPIConnector)this.connector;
        ((NSAPIConnector)object2).setAllResponseFields(this.status, this.filter(this.getMessage()), this.getContentType(), this.getContentLength(), objectArray, n3, bl);
        this.committed = true;
    }

    private String toAbsolute(String string) {
        if (string == null) {
            return string;
        }
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)this.request.getRequest();
            String string2 = HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest).toString();
            try {
                uRL = new URL(new URL(string2), string);
            }
            catch (MalformedURLException malformedURLException2) {
                throw new IllegalArgumentException(string);
            }
        }
        return uRL.toExternalForm();
    }

    private String toEncoded(String string, String string2, String string3) {
        StringBuffer stringBuffer;
        int n;
        if (string == null || string2 == null) {
            return string;
        }
        String string4 = string;
        String string5 = "";
        String string6 = "";
        int n2 = string.indexOf(63);
        if (n2 >= 0) {
            string4 = string.substring(0, n2);
            string5 = string.substring(n2);
        }
        if ((n = string4.indexOf(35)) >= 0) {
            string6 = string4.substring(n);
            string4 = string4.substring(0, n);
        }
        if ((stringBuffer = new StringBuffer(string4)).length() > 0) {
            stringBuffer.append(";jsessionid=");
            stringBuffer.append(string2);
        }
        stringBuffer.append(string6);
        stringBuffer.append(string5);
        if (string3 != null && string3.indexOf(":") == -1) {
            stringBuffer.append(":");
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    public String encodeRedirectURL(String string) {
        if (this.isEncodeable(this.toAbsolute(string))) {
            NSAPIRequest nSAPIRequest = (NSAPIRequest)this.request;
            return this.toEncoded(string, nSAPIRequest.getSession().getId(), nSAPIRequest.getJrouteId());
        }
        return string;
    }

    public String encodeURL(String string) {
        if (this.isEncodeable(this.toAbsolute(string))) {
            NSAPIRequest nSAPIRequest = (NSAPIRequest)this.request;
            return this.toEncoded(string, nSAPIRequest.getSession().getId(), nSAPIRequest.getJrouteId());
        }
        return string;
    }

    public String filter(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        this.resultBuffer.setLength(0);
        int n = 0;
        while (n < cArray.length) {
            switch (cArray[n]) {
                case '<': {
                    this.resultBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    this.resultBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    this.resultBuffer.append("&amp;");
                    break;
                }
                case '\"': {
                    this.resultBuffer.append("&quot;");
                    break;
                }
                case '\'': {
                    this.resultBuffer.append("\\'");
                    break;
                }
                case '\n': {
                    this.resultBuffer.append("\\n");
                    break;
                }
                case '\r': {
                    this.resultBuffer.append("\\r");
                    break;
                }
                default: {
                    this.resultBuffer.append(cArray[n]);
                }
            }
            ++n;
        }
        return this.resultBuffer.toString();
    }
}

