/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.zip;

import com.iplanet.ias.util.Assertion;
import com.iplanet.ias.util.diagnostics.Reporter;
import com.iplanet.ias.util.io.FileUtils;
import com.iplanet.ias.util.zip.ZipFileException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipFile {
    private File explodeDir = null;
    private ArrayList files = null;
    private static final String specialDir = "META-INF/";
    private byte[] buffer = new byte[16384];
    private ZipInputStream zipStream = null;

    public ZipFile(String string, String string2) throws ZipFileException {
        this(new File(string), new File(string2));
    }

    public ZipFile(InputStream inputStream, String string) throws ZipFileException {
        this(inputStream, new File(string));
    }

    public ZipFile(File file, File file2) throws ZipFileException {
        this.checkZipFile(file);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (IOException iOException) {
            throw new ZipFileException(iOException);
        }
        this.ctor(fileInputStream, file2);
    }

    public ZipFile(InputStream inputStream, File file) throws ZipFileException {
        this.ctor(inputStream, file);
    }

    public ArrayList recursiveExplode() throws ZipFileException {
        return ZipFile.doRecursiveExplode(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList explode() throws ZipFileException {
        this.files = new ArrayList();
        ZipInputStream zipInputStream = null;
        try {
            try {
                ZipEntry zipEntry;
                zipInputStream = this.zipStream;
                block7: while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    FileOutputStream fileOutputStream;
                    String string = zipEntry.getName();
                    File file = null;
                    if (this.isDirectory(string)) {
                        file = new File(this.explodeDir, string.substring(0, string.length() - 1));
                        file.mkdir();
                        continue;
                    }
                    file = new File(this.explodeDir, string);
                    File file2 = file.getParentFile();
                    if (file2.mkdirs()) {
                        Reporter.verbose("Created new directory:  " + file2);
                    }
                    if (file.delete()) {
                        Reporter.info("deleted pre-existing file: " + file);
                    }
                    if ((fileOutputStream = this.getOutputStream(string)) == null) continue;
                    int n = 0;
                    int n2 = zipInputStream.read(this.buffer);
                    while (true) {
                        if (n2 <= 0) {
                            fileOutputStream.close();
                            Reporter.verbose("Wrote " + n + " to " + string);
                            this.files.add(string);
                            continue block7;
                        }
                        fileOutputStream.write(this.buffer, 0, n2);
                        n += n2;
                        n2 = zipInputStream.read(this.buffer);
                    }
                }
            }
            catch (IOException iOException) {
                throw new ZipFileException(iOException);
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            Reporter.verbose("Closing zin...");
            try {
                zipInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new ZipFileException("Got an exception while trying to close Jar input stream: " + iOException);
            }
        }
        Reporter.verbose("Closing zin...");
        try {}
        catch (IOException iOException) {
            throw new ZipFileException("Got an exception while trying to close Jar input stream: " + iOException);
        }
        zipInputStream.close();
        Reporter.info("Successfully Exploded ZipFile to " + this.explodeDir.getPath());
        return this.files;
    }

    public static void extractJar(String string, JarFile jarFile, File file) throws ZipFileException {
        try {
            File file2 = file.getParentFile();
            if (!file2.exists()) {
                file2.mkdirs();
            }
            ZipEntry zipEntry = jarFile.getEntry(string);
            if (string == null) {
                throw new ZipFileException(string + " not found in " + jarFile.getName());
            }
            InputStream inputStream = jarFile.getInputStream(zipEntry);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            FileUtils.copy(inputStream, bufferedOutputStream);
        }
        catch (IOException iOException) {
            throw new ZipFileException(iOException);
        }
    }

    public ArrayList getFileList() {
        return this.files;
    }

    private static ArrayList doRecursiveExplode(ZipFile zipFile) throws ZipFileException {
        ArrayList arrayList = zipFile.explode();
        ArrayList arrayList2 = new ArrayList();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.endsWith(".jar")) continue;
            File file = new File(zipFile.explodeDir, string);
            ZipFile zipFile2 = new ZipFile(file, zipFile.explodeDir);
            arrayList2.addAll(ZipFile.doRecursiveExplode(zipFile2));
            iterator.remove();
            file.delete();
        }
        arrayList.addAll(arrayList2);
        return arrayList;
    }

    private void ctor(InputStream inputStream, File file) throws ZipFileException {
        ZipFile.insist(file != null);
        this.explodeDir = file;
        try {
            this.zipStream = new ZipInputStream(inputStream);
            this.checkExplodeDir();
        }
        catch (Throwable throwable) {
            throw new ZipFileException(throwable.toString());
        }
    }

    private boolean isDirectory(String string) {
        char c = string.charAt(string.length() - 1);
        return c == '/' || c == '\\';
    }

    private void checkZipFile(File file) throws ZipFileException {
        ZipFile.insist(file != null);
        String string = file.getPath();
        ZipFile.insist(file.exists(), "zipFile (" + string + ") doesn't exist");
        ZipFile.insist(!file.isDirectory(), "zipFile (" + string + ") is actually a directory!");
    }

    private void checkExplodeDir() throws ZipFileException {
        String string = this.explodeDir.getPath();
        this.explodeDir.mkdirs();
        ZipFile.insist(this.explodeDir.exists(), "Target Directory doesn't exist: " + string);
        ZipFile.insist(this.explodeDir.isDirectory(), "Target Directory isn't a directory: " + string);
        ZipFile.insist(this.explodeDir.canWrite(), "Can't write to Target Directory: " + string);
    }

    private static boolean isSpecial(String string) {
        return string.toUpperCase().startsWith(specialDir.toUpperCase());
    }

    private FileOutputStream getOutputStream(String string) throws ZipFileException {
        Assertion.check(this.explodeDir, "Programmer Error -- need to setup explodeDir");
        File file = new File(this.explodeDir, string);
        if (file.isDirectory()) {
            Reporter.warn("Weird!  A directory is listed as an entry in the jar file -- skipping...");
            return null;
        }
        try {
            return new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ZipFileException("filename: " + file.getPath() + "  " + fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new ZipFileException(iOException);
        }
    }

    private boolean isManifest(String string) {
        if (string.toLowerCase().endsWith("manifest.mf")) {
            return false;
        }
        return false;
    }

    private static void pr(String string) {
        System.out.println(string);
    }

    private static void insist(String string) throws ZipFileException {
        if (string == null || string.length() < 0) {
            throw new ZipFileException();
        }
    }

    private static void insist(String string, String string2) throws ZipFileException {
        if (string == null || string.length() < 0) {
            throw new ZipFileException(string2);
        }
    }

    private static void insist(boolean bl) throws ZipFileException {
        if (!bl) {
            throw new ZipFileException();
        }
    }

    private static void insist(boolean bl, String string) throws ZipFileException {
        if (!bl) {
            throw new ZipFileException(string);
        }
    }

    public static void main(String[] stringArray) {
        try {
            File file = new File("C:\\temp\\int03.jar");
            File file2 = new File("c:/temp/test_zip_explode");
            file2.mkdirs();
            ZipFile zipFile = new ZipFile(file, file2);
            ArrayList arrayList = zipFile.recursiveExplode();
            String[] stringArray2 = arrayList.toArray(new String[0]);
            Arrays.sort(stringArray2, String.CASE_INSENSITIVE_ORDER);
            int n = 0;
            while (n < stringArray2.length) {
                ZipFile.pr(stringArray2[n]);
                ++n;
            }
        }
        catch (ZipFileException zipFileException) {
            ZipFile.pr("ZipFileException: " + zipFileException);
        }
    }
}

