/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.pool;

import com.iplanet.ias.util.collection.DList;
import com.iplanet.ias.util.collection.DListNode;
import com.iplanet.ias.util.collection.FastStack;
import com.iplanet.ias.util.pool.AbstractPool;
import com.iplanet.ias.util.pool.ObjectFactory;
import com.iplanet.ias.util.pool.PoolException;
import com.iplanet.ias.util.scheduler.PeriodicallyServicable;
import com.sun.logging.LogDomains;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SoftObjectPool
extends AbstractPool
implements PeriodicallyServicable {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    protected DList list;
    protected int minSize;
    protected int initialSize;
    protected int maxLimit;
    protected long maxIdleTime;
    protected int maxStrongRefs;
    protected Boolean isBounded;

    public SoftObjectPool(ObjectFactory objectFactory, int n, int n2, long l, int n3) {
        this.factory = objectFactory;
        this.minSize = n;
        this.initialSize = n2;
        this.maxIdleTime = l;
        this.maxStrongRefs = n3;
        this.setMaxLimit(-1);
        this.initPool();
    }

    public SoftObjectPool(ObjectFactory objectFactory, int n, int n2, int n3, long l, int n4) {
        this.factory = objectFactory;
        this.minSize = n;
        this.maxIdleTime = l;
        this.initialSize = n2;
        this.maxStrongRefs = n4;
        this.setMaxLimit(n3);
        this.initPool();
    }

    public int getMaxLimit() {
        return this.maxLimit;
    }

    public void setMaxLimit(int n) {
        if (n <= 0 || n >= 0x7FFFFFFE) {
            this.isBounded = null;
        } else {
            this.isBounded = new Boolean(true);
            this.maxLimit = n;
        }
    }

    private void initPool() {
        this.list = new DList();
        this.collection = this.list;
        super.preload(this.minSize < this.initialSize ? this.initialSize : this.minSize);
        this.scheduler.addTimeRepeatableTask(this, (int)this.maxIdleTime);
    }

    protected boolean canCreate() {
        return this.isBounded == null ? true : this.createdCount < this.maxLimit;
    }

    protected Object checkin(Object object) {
        int n = this.list.size();
        long l = AbstractPool._clock.getTime();
        if (n < this.maxStrongRefs) {
            this.list.addAsLastNode(new TimeStampedSoftDListNode(object, l, object));
        } else {
            this.list.addAsLastNode(new TimeStampedSoftDListNode(new SoftReference<Object>(object), l, null));
        }
        return this;
    }

    private Object obtainObject(Object object) {
        Object object2 = null;
        int n = 0;
        int n2 = this.list.size();
        while (n2 > 0) {
            TimeStampedSoftDListNode timeStampedSoftDListNode = (TimeStampedSoftDListNode)this.list.getDListNodeAt(0);
            this.list.delink(timeStampedSoftDListNode);
            if (timeStampedSoftDListNode.isSoftRef == null) {
                SoftReference softReference = (SoftReference)timeStampedSoftDListNode.object;
                object2 = softReference.get();
                if (object2 != null) break;
                ++n;
            } else {
                object2 = timeStampedSoftDListNode.object;
                break;
            }
            --n2;
        }
        if (object2 == null) {
            try {
                object2 = this.factory.create(object);
                this.afterCreate(object2);
            }
            catch (PoolException poolException) {
                // empty catch block
            }
        }
        this.createdCount -= n;
        if (n == 1) {
            this.collection.notify();
        } else if (n > 1) {
            this.collection.notifyAll();
        }
        return object2;
    }

    protected Object checkout(Object object) {
        return this.obtainObject(object);
    }

    public void prolog() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void service() {
        Object object;
        int n = 0;
        long l = AbstractPool._clock.getTime();
        long l2 = l - this.maxIdleTime;
        TimeStampedSoftDListNode timeStampedSoftDListNode = null;
        FastStack fastStack = new FastStack();
        Collection collection = this.collection;
        synchronized (collection) {
            object = null;
            while (object == null) {
                timeStampedSoftDListNode = (TimeStampedSoftDListNode)this.list.getFirstDListNode();
                if (timeStampedSoftDListNode == null) {
                    object = new Object();
                    continue;
                }
                if (timeStampedSoftDListNode.timeStamp <= l2) {
                    this.list.delink(timeStampedSoftDListNode);
                    fastStack.push(timeStampedSoftDListNode.object);
                    ++n;
                    continue;
                }
                object = new Object();
            }
            this.createdCount -= n;
            int n2 = this.list.size() - this.minSize;
            super.preload(0 - n2);
            if (n != 0) {
                if (n == 1) {
                    this.collection.notify();
                } else {
                    this.collection.notifyAll();
                }
            }
        }
        while (!fastStack.isEmpty()) {
            object = fastStack.pop();
            this.beforeDestroy(object);
            this.factory.destroy(object);
        }
        _logger.log(Level.FINE, "Leaving service after killing " + n + " (idle) objects. Now size: " + this.list.size());
    }

    public void epilog() {
    }

    public long getFrequency() {
        return this.maxIdleTime;
    }

    public boolean getExecuteIfMissed() {
        return true;
    }

    public boolean getExecutionTolerance(long l) {
        return true;
    }

    public String toString() {
        return "";
    }

    class TimeStampedSoftDListNode
    extends DListNode {
        long timeStamp;
        Object isSoftRef;

        public TimeStampedSoftDListNode(Object object, long l, Object object2) {
            super(object);
            this.timeStamp = l;
            this.isSoftRef = object2;
            _logger.log(Level.FINE, this + ": created DListNode at: " + l);
        }

        public String toString() {
            return "TSDListNode: " + this.object + "; isSoftRef: " + this.isSoftRef;
        }
    }
}

