/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.pool;

import com.iplanet.ias.util.ApproximateClock;
import com.iplanet.ias.util.pool.ObjectFactory;
import com.iplanet.ias.util.pool.Pool;
import com.iplanet.ias.util.pool.PoolException;
import com.iplanet.ias.util.pool.PoolListener;
import com.iplanet.ias.util.pool.RequestInterruptedException;
import com.iplanet.ias.util.scheduler.PeriodicEventScheduler;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;

public abstract class AbstractPool
implements Pool {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    protected boolean bDebug = false;
    protected Collection collection;
    protected ArrayList listeners;
    protected ObjectFactory factory = null;
    protected int waitCount = 0;
    protected int createdCount = 0;
    protected Object onHold = null;
    protected Object closed = null;
    protected static ApproximateClock _clock = new ApproximateClock(15000L);
    protected PeriodicEventScheduler scheduler = PeriodicEventScheduler.getInstance();

    protected AbstractPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(boolean bl, Object object) throws InterruptedException, PoolException {
        Object object2;
        if (this.closed != null) {
            throw new PoolException("Pool closed. Cannot obtain object");
        }
        Collection collection = this.collection;
        synchronized (collection) {
            block16: {
                while (true) {
                    if (this.collection.size() > 0) {
                        object2 = this.checkout(object);
                        if (object2 != null) {
                            return object2;
                        }
                    } else if (this.canCreate()) {
                        ++this.createdCount;
                        break block16;
                    }
                    if (!bl) break;
                    try {
                        ++this.waitCount;
                        this.beforeWait(object);
                        this.collection.wait();
                        this.afterNotify(object);
                        --this.waitCount;
                    }
                    catch (InterruptedException interruptedException) {
                        throw new RequestInterruptedException("InterruptedException", interruptedException);
                    }
                }
                return null;
            }
        }
        try {
            object2 = this.factory.create(object);
        }
        catch (PoolException poolException) {
            Collection collection2 = this.collection;
            synchronized (collection2) {
                --this.createdCount;
            }
            throw poolException;
        }
        this.afterCreate(object2);
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(long l, Object object) throws InterruptedException, PoolException {
        Object object2;
        if (this.closed != null) {
            throw new PoolException("Pool closed. Cannot obtain object");
        }
        long l2 = _clock.getTime();
        long l3 = l;
        long l4 = l2;
        Collection collection = this.collection;
        synchronized (collection) {
            while (true) {
                if (this.collection.size() > 0) {
                    object2 = this.checkout(object);
                    if (object2 != null) {
                        return object2;
                    }
                } else if (this.canCreate()) {
                    ++this.createdCount;
                    break;
                }
                if (l3 > 0L) {
                    try {
                        ++this.waitCount;
                        this.beforeWait(object);
                        this.collection.wait();
                        this.afterNotify(object);
                        --this.waitCount;
                    }
                    catch (InterruptedException interruptedException) {
                        throw new RequestInterruptedException("InterruptedException", interruptedException);
                    }
                } else {
                    return null;
                }
                l2 = _clock.getTime();
                l3 = l2 - l4;
                l4 = l2;
            }
        }
        try {
            object2 = this.factory.create(object);
        }
        catch (PoolException poolException) {
            Collection collection2 = this.collection;
            synchronized (collection2) {
                --this.createdCount;
            }
            throw poolException;
        }
        this.afterCreate(object2);
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(Object object) {
        Collection collection = this.collection;
        synchronized (collection) {
            if (this.closed != null && this.waitCount == 0) {
                this.destroyObject(object);
                return;
            }
            this.checkin(object);
            if (this.waitCount > 0) {
                this.collection.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyObject(Object object) {
        this.beforeDestroy(object);
        this.factory.destroy(object);
        Collection collection = this.collection;
        synchronized (collection) {
            --this.createdCount;
            if (this.waitCount > 0) {
                this.collection.notify();
            }
        }
    }

    protected abstract Object checkin(Object var1);

    protected abstract Object checkout(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPoolListener(PoolListener poolListener) {
        AbstractPool abstractPool = this;
        synchronized (abstractPool) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
                this.listeners.add(poolListener);
                return true;
            }
            if (this.listeners.indexOf(poolListener) == -1) {
                this.listeners.add(poolListener);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePoolListener(PoolListener poolListener) {
        AbstractPool abstractPool = this;
        synchronized (abstractPool) {
            if (this.listeners == null) {
                return false;
            }
            return this.listeners.remove(poolListener);
        }
    }

    protected abstract boolean canCreate();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preload(int n) {
        if (n <= 0) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        int n2 = 0;
        while (n2 < n) {
            try {
                arrayList.add(this.factory.create(null));
            }
            catch (PoolException poolException) {
                // empty catch block
            }
            ++n2;
        }
        n = arrayList.size();
        Collection collection = this.collection;
        synchronized (collection) {
            int n3 = 0;
            while (n3 < n) {
                this.checkin(arrayList.get(n3));
                ++n3;
            }
            this.createdCount += n;
        }
    }

    public int size() {
        return this.collection.size();
    }

    public int destroyPoolObjects() {
        return this.destroyPoolObjects(this.collection.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int destroyPoolObjects(int n) {
        int n2;
        if (n <= 0) {
            return 0;
        }
        Object[] objectArray = this.collection.toArray();
        ArrayList<Object> arrayList = null;
        Collection collection = this.collection;
        synchronized (collection) {
            if (n > this.collection.size()) {
                n = this.collection.size();
            }
            arrayList = new ArrayList<Object>(n);
            n2 = 0;
            while (n2 < n) {
                arrayList.add(this.checkout(null));
                ++n2;
            }
            n = arrayList.size();
            this.createdCount -= n;
        }
        n2 = 0;
        while (n2 < n) {
            this.factory.destroy(arrayList.get(n2));
            ++n2;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.onClose();
        Collection collection = this.collection;
        synchronized (collection) {
            this.closed = "__Closed__";
            int n = this.collection.size() - this.waitCount;
            this.destroyPoolObjects(n);
        }
    }

    public boolean isClosed() {
        return this.closed != null;
    }

    public void afterCreate(Object object) {
        if (this.listeners != null) {
            int n = this.listeners.size();
            int n2 = 0;
            while (n2 < n) {
                ((PoolListener)this.listeners.get(n2)).afterCreate(object);
                ++n2;
            }
        }
    }

    public void beforeDestroy(Object object) {
        if (this.listeners != null) {
            int n = this.listeners.size();
            int n2 = 0;
            while (n2 < n) {
                ((PoolListener)this.listeners.get(n2)).beforeDestroy(object);
                ++n2;
            }
        }
    }

    public void beforeWait(Object object) {
        if (this.listeners != null) {
            int n = this.listeners.size();
            int n2 = 0;
            while (n2 < n) {
                ((PoolListener)this.listeners.get(n2)).beforeWait(object);
                ++n2;
            }
        }
    }

    public void afterNotify(Object object) {
        if (this.listeners != null) {
            int n = this.listeners.size();
            int n2 = 0;
            while (n2 < n) {
                ((PoolListener)this.listeners.get(n2)).afterNotify(object);
                ++n2;
            }
        }
    }

    public void onClose() {
        if (this.listeners != null) {
            int n = this.listeners.size();
            int n2 = 0;
            while (n2 < n) {
                ((PoolListener)this.listeners.get(n2)).onClose();
                ++n2;
            }
        }
    }
}

