/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.verifier.tests.connector.ias;

import com.iplanet.ias.tools.common.dd.connector.ResourceAdapter;
import com.iplanet.ias.tools.common.dd.connector.SunConnector;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorCheck;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest;

public class ASConnectorSteadyPool
extends ConnectorTest
implements ConnectorCheck {
    public Result check(ConnectorDescriptor connectorDescriptor) {
        Result result;
        block11: {
            result = this.getInitializedResult();
            ComponentNameConstructor componentNameConstructor = new ComponentNameConstructor(connectorDescriptor);
            boolean bl = false;
            SunConnector sunConnector = connectorDescriptor.getSunDescriptor();
            if (sunConnector == null) {
                result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable1", "NOT APPLICABLE [AS\ufffdCONNECTOR]: sun-ra.xml descriptor object could not be obtained"));
            } else {
                String string;
                ResourceAdapter resourceAdapter = sunConnector.getResourceAdapter();
                if (resourceAdapter == null) {
                    result.addErrorDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                    result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notRun", "NOT RUN [AS-EJB] : Could not create an SunEjbJar object"));
                }
                if ((string = resourceAdapter.getAttributeValue("steady-pool-size")).length() == 0) {
                    result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed1", "FAILED [AS-CONNECTOR resource-adapter] : steady-pool-size cannot be empty"));
                } else {
                    try {
                        int n = Integer.valueOf(string);
                        if (n < 0 || n > Integer.MAX_VALUE) {
                            result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed2", "FAILED [AS-CONNECTOR resource-adapter] : steady-pool-size cannot be {0}. It should be between 0 and {1}", new Object[]{new Integer(n), new Integer(Integer.MAX_VALUE)}));
                            break block11;
                        }
                        String string2 = resourceAdapter.getAttributeValue("max-pool-size");
                        int n2 = 0;
                        try {
                            n2 = Integer.valueOf(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed3", "FAILED [AS-CONNECTOR resource-adapter] : steady-pool-size should be less than max-pool-size and the value {0} for max-pool-size is not a valid Integer number", new Object[]{string2}));
                            return result;
                        }
                        if (n <= n2) {
                            result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "PASSED [AS-CONNECTOR resource-adapter] : steady-pool-size is {0}", new Object[]{new Integer(n)}));
                            break block11;
                        }
                        result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed4", "FAILED [AS-CONNECTOR resource-adapter] : steady-pool-size {0} should not be greater than max-pool-size {1}", new Object[]{string, string2}));
                    }
                    catch (NumberFormatException numberFormatException) {
                        Verifier.debug(numberFormatException);
                        result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed5", "FAILED [AS-CONNECTOR resource-adapter] : The value {0} for steady-pool-size is not a valid Integer number", new Object[]{string}));
                    }
                }
            }
        }
        return result;
    }
}

