/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.server;

import com.iplanet.ias.server.AbstractMonitor;
import com.iplanet.ias.server.MonitorListener;
import com.iplanet.ias.server.MonitorableEntry;
import com.iplanet.ias.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileFilter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

class AutoDeployMonitor
extends AbstractMonitor {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");
    private static AutoDeployMonitor _instance = null;
    private static ArchiveFilter _archiveFilter = null;
    private static final String SUCCESS_EXT = ".deployed";
    private static final String ERROR_EXT = ".notdeployed";

    private AutoDeployMonitor(long l) {
        super(l);
    }

    static AutoDeployMonitor getInstance(long l) {
        if (_instance == null) {
            _instance = new AutoDeployMonitor(l);
            _archiveFilter = new ArchiveFilter();
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            HashSet hashSet = this._monitoredEntries;
            synchronized (hashSet) {
                Iterator iterator = this._monitoredEntries.iterator();
                MonitorableEntry monitorableEntry = null;
                while (iterator.hasNext()) {
                    monitorableEntry = (MonitorableEntry)iterator.next();
                    File file = monitorableEntry.getMonitoredFile();
                    File[] fileArray = file.listFiles(_archiveFilter);
                    if (fileArray == null || fileArray.length == 0) {
                        return;
                    }
                    MonitorListener monitorListener = monitorableEntry.getListener();
                    int n = 0;
                    while (n < fileArray.length) {
                        File file2;
                        _logger.log(Level.FINE, "[AutoDeployMonitor] Found " + fileArray[n]);
                        boolean bl = monitorListener.deploy(monitorableEntry, fileArray[n]);
                        if (bl) {
                            file2 = new File(fileArray[n].getParentFile(), fileArray[n].getName() + SUCCESS_EXT);
                            fileArray[n].renameTo(file2);
                        } else {
                            file2 = new File(fileArray[n].getParentFile(), fileArray[n].getName() + ERROR_EXT);
                            fileArray[n].renameTo(file2);
                        }
                        ++n;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            _logger.log(Level.WARNING, "core.exception", throwable);
        }
    }

    private static class ArchiveFilter
    implements FileFilter {
        private ArchiveFilter() {
        }

        public boolean accept(File file) {
            return FileUtils.isEar(file) || FileUtils.isJar(file) || FileUtils.isWar(file) || FileUtils.isRar(file);
        }
    }
}

