/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.security.auth.realm.solaris;

import com.iplanet.ias.security.auth.realm.IASRealm;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.InvalidOperationException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;

public class SolarisRealm
extends IASRealm {
    public static final String AUTH_TYPE = "solaris";
    private HashMap groupCache;
    private Vector emptyVector;

    public synchronized void init(Properties properties) throws BadRealmException, NoSuchRealmException {
        String string = properties.getProperty("jaas-context");
        if (string == null) {
            IASRealm._logger.warning("realmconfig.noctx");
            String string2 = IASRealm.sm.getString("solarisrealm.nojaas");
            throw new BadRealmException(string2);
        }
        this.setProperty("jaas-context", string);
        IASRealm._logger.fine("SolarisRealm : jaas-context=" + string);
        this.groupCache = new HashMap();
        this.emptyVector = new Vector();
    }

    public String getAuthType() {
        return AUTH_TYPE;
    }

    public Enumeration getGroupNames(String string) throws InvalidOperationException, NoSuchUserException {
        Vector vector = (Vector)this.groupCache.get(string);
        if (vector == null) {
            vector = this.loadGroupNames(string);
        }
        return vector.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGroupNames(String string, String[] stringArray) {
        Vector<String> vector = null;
        if (stringArray == null) {
            vector = this.emptyVector;
        } else {
            vector = new Vector<String>(stringArray.length + 1);
            int n = 0;
            while (n < stringArray.length) {
                vector.add(stringArray[n]);
                ++n;
            }
        }
        SolarisRealm solarisRealm = this;
        synchronized (solarisRealm) {
            this.groupCache.put(string, vector);
        }
    }

    public String[] authenticate(String string, String string2) {
        String[] stringArray = SolarisRealm.nativeAuthenticate(string, string2);
        return stringArray;
    }

    private Vector loadGroupNames(String string) {
        String[] stringArray = SolarisRealm.nativeGetGroups(string);
        if (stringArray == null) {
            IASRealm._logger.fine("No groups returned for user: " + string);
        }
        this.setGroupNames(string, stringArray);
        return (Vector)this.groupCache.get(string);
    }

    private static native String[] nativeAuthenticate(String var0, String var1);

    private static native String[] nativeGetGroups(String var0);

    static {
        System.loadLibrary("solarisauth");
    }
}

