/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.loader;

import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.deployment.AppConfigEnvImpl;
import com.iplanet.ias.deployment.AppConfigException;
import com.iplanet.ias.instance.AppsManager;
import com.iplanet.ias.instance.EjbModulesManager;
import com.iplanet.ias.instance.InstanceFactory;
import com.iplanet.ias.util.io.FileUtils;
import com.sun.enterprise.deployment.ArchiveException;
import com.sun.enterprise.deployment.xml.ApplicationNode;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EJBClassPathUtils {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.classloading");
    private static final String MANIFEST_ENTRY = "META-INF" + File.separator + "MANIFEST.MF";

    public static String[] getEjbClasspath(String string, String string2) {
        AppsManager appsManager = null;
        try {
            appsManager = InstanceFactory.createAppsManager(string2);
        }
        catch (ConfigException configException) {
            _logger.log(Level.SEVERE, "ejb.config_excp", configException);
        }
        return EJBClassPathUtils.getEjbClasspath(string, appsManager);
    }

    public static String[] getEjbClasspath(String string, AppsManager appsManager) {
        String[] stringArray = null;
        List list = EJBClassPathUtils.getEjbClasspathList(string, appsManager);
        if (list.size() > 0) {
            stringArray = new String[list.size()];
            stringArray = list.toArray(stringArray);
        }
        return stringArray;
    }

    public static List getEjbClasspathList(String string, AppsManager appsManager) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string2 = appsManager.getLocation(string);
            List list = EJBClassPathUtils.getApplicationClassPath(string2, string);
            if (list.size() > 0) {
                arrayList.addAll(list);
            }
            arrayList.add(appsManager.getStubLocation(string));
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "ejb.classpath", exception);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "[EJBClassPathUtils] EJB Class Path for [" + string + "] is ...\n" + ((Object)arrayList).toString());
        }
        return arrayList;
    }

    public static String[] getEjbModuleClasspath(String string, EjbModulesManager ejbModulesManager) {
        String[] stringArray = null;
        List list = EJBClassPathUtils.getEjbModuleClasspathList(string, ejbModulesManager);
        if (list.size() > 0) {
            stringArray = new String[list.size()];
            stringArray = list.toArray(stringArray);
        }
        return stringArray;
    }

    public static List getEjbModuleClasspathList(String string, EjbModulesManager ejbModulesManager) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string2 = ejbModulesManager.getLocation(string);
            arrayList.add(string2);
            arrayList.add(ejbModulesManager.getStubLocation(string));
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "ejb.classpath", exception);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "[EJBClassPathUtils] EJB Class Path for [" + string + "] is ...\n" + ((Object)arrayList).toString());
        }
        return arrayList;
    }

    public static String[] getEjbModuleClasspath(String string, String string2) {
        EjbModulesManager ejbModulesManager = null;
        try {
            ejbModulesManager = InstanceFactory.createEjbModuleManager(string2);
        }
        catch (ConfigException configException) {
            _logger.log(Level.SEVERE, "ejb.config_excp", configException);
        }
        return EJBClassPathUtils.getEjbModuleClasspath(string, ejbModulesManager);
    }

    public static List getApplicationClassPath(String string, String string2) throws IOException, ArchiveException, AppConfigException {
        Object object;
        Object object2;
        String string3;
        ArrayList<String> arrayList = new ArrayList<String>();
        AppConfigEnvImpl appConfigEnvImpl = new AppConfigEnvImpl(string, string2, false);
        InputStream inputStream = appConfigEnvImpl.getApplicationXmlFile();
        ApplicationNode applicationNode = ApplicationNode.read(inputStream, false);
        applicationNode.getApplication(null, null);
        inputStream.close();
        Enumeration enumeration = applicationNode.getEjbBundleArchiveMap().keys();
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            String string4 = string + File.separator + FileUtils.makeFriendlyFilename(string3);
            arrayList.add(string4);
            object2 = EJBClassPathUtils.getManifest(string4);
            object = EJBClassPathUtils.getManifestClassPath((Manifest)object2, string);
            if (object.size() <= 0) continue;
            arrayList.addAll((Collection<String>)object);
        }
        object2 = applicationNode.getRarDescriptorArchiveMap().keys();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            string3 = string + File.separator + FileUtils.makeFriendlyFilename((String)object);
            arrayList.add(string3);
            Manifest manifest = EJBClassPathUtils.getManifest(string3);
            List list = EJBClassPathUtils.getManifestClassPath(manifest, string);
            if (list.size() <= 0) continue;
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private static Manifest getManifest(String string) {
        FileInputStream fileInputStream = null;
        Manifest manifest = null;
        try {
            fileInputStream = new FileInputStream(string + File.separator + MANIFEST_ENTRY);
            if (fileInputStream != null) {
                manifest = new Manifest(fileInputStream);
            }
        }
        catch (IOException iOException) {}
        return manifest;
    }

    private static List getManifestClassPath(Manifest manifest, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (manifest != null) {
            Attributes attributes = manifest.getMainAttributes();
            Iterator<Object> iterator = attributes.keySet().iterator();
            while (iterator.hasNext()) {
                Attributes.Name name = (Attributes.Name)iterator.next();
                if (!name.equals(Attributes.Name.CLASS_PATH)) continue;
                String string2 = (String)attributes.get(name);
                StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    arrayList.add(string + File.separator + string3);
                }
            }
        }
        return arrayList;
    }
}

