/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment.backend;

import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.deployment.ClientJarArchivist;
import com.iplanet.ias.deployment.backend.AppDD;
import com.iplanet.ias.deployment.backend.AppInfo;
import com.iplanet.ias.deployment.backend.ClientJarMaker;
import com.iplanet.ias.deployment.backend.ContextRootChecker;
import com.iplanet.ias.deployment.backend.Deployer;
import com.iplanet.ias.deployment.backend.DeploymentRequest;
import com.iplanet.ias.deployment.backend.IASDeploymentException;
import com.iplanet.ias.instance.ApplicationEnvironment;
import com.iplanet.ias.instance.AppsManager;
import com.iplanet.ias.util.StringUtils;
import com.iplanet.ias.util.i18n.StringManager;
import com.iplanet.ias.util.io.FileUtils;
import com.iplanet.ias.util.zip.ZipItem;
import java.io.File;
import java.util.Properties;

abstract class AppDeployerBase
extends Deployer {
    private ApplicationEnvironment appEnv;
    private AppsManager appMgr;
    private String appName;
    private boolean isReg;
    private File stubsDir;
    private File jspDir;
    private File appDir;
    private File clientJar;
    private AppInfo appInfo;
    private AppDD appDD = null;
    private static StringManager localStrings;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$iplanet$ias$deployment$backend$AppDeployerBase;

    AppDeployerBase(DeploymentRequest deploymentRequest) throws IASDeploymentException {
        super(deploymentRequest);
    }

    protected abstract File setAppDir() throws IASDeploymentException;

    protected void begin() throws IASDeploymentException {
        super.begin();
        try {
            this.appEnv = this.request.getAppEnv();
            if (this.appEnv == null) {
                String string = localStrings.getString("enterprise.deployment.backend.null_applicationenvironment_object");
                throw new IASDeploymentException(string);
            }
            this.appMgr = new AppsManager(this.getInstanceEnv());
            this.appName = this.request.getName();
            if (!StringUtils.ok((String)this.appName)) {
                String string = localStrings.getString("enterprise.deployment.backend.null_appname");
                throw new IASDeploymentException(string);
            }
            this.isReg = this.getAppMgr().isRegistered(this.getAppName());
            this.verify();
            this.appDir = this.setAppDir();
            this.request.setDeployedDirectory(this.appDir);
            this.createLockFile(this.appDir);
            this.setGeneratedDirs();
            this.appInfo = this.createAppInfo();
        }
        catch (IASDeploymentException iASDeploymentException) {
            throw iASDeploymentException;
        }
        catch (Exception exception) {
            throw new IASDeploymentException(exception);
        }
    }

    protected AppInfo createAppInfo() throws IASDeploymentException {
        AppInfo appInfo;
        if (!$assertionsDisabled && this.appDir == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.getAppName() == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.request.isUnDeploy()) {
            throw new AssertionError();
        }
        if (this.isDirectory()) {
            appInfo = new AppInfo(this.appDir, this.getAppName());
        } else {
            File file = this.request.getFileSource().getFile();
            if (!FileUtils.isEar(file)) {
                String string = localStrings.getString("enterprise.deployment.backend.attempt_to_deploy_non_ear_archive", file.getPath());
                throw new IASDeploymentException(string);
            }
            appInfo = new AppInfo(this.appDir, this.getAppName(), file);
        }
        return appInfo;
    }

    protected void prePopulateConfig() throws IASDeploymentException {
        try {
            this.getAppMgr().register(this.getAppInfo());
        }
        catch (Exception exception) {
            throw new IASDeploymentException(exception);
        }
    }

    protected void postPopulateConfig() throws ConfigException, IASDeploymentException {
        if (this.getAppMgr().isRegistered(this.getAppName())) {
            Properties properties = this.request.getOptionalAttributes();
            if (properties != null) {
                this.getAppMgr().setOptionalAttributes(this.getAppName(), properties);
            } else {
                this.getAppMgr().setEnable(this.getAppName(), true);
            }
        } else {
            String string = localStrings.getString("enterprise.deployment.backend.application_not_registered");
            throw new IASDeploymentException(string);
        }
        this.saveHotConfig();
    }

    protected final void saveColdConfig() throws ConfigException {
        this.getAppMgr().saveConfigContext();
    }

    protected final void verify() throws IASDeploymentException {
        if (!this.request.isApplication()) {
            String string = localStrings.getString("enterprise.deployment.backend.attempt_to_deploy_non_application");
            throw new IASDeploymentException(string);
        }
        if (this.request.isUnDeploy()) {
            if (!this.isReg) {
                String string = localStrings.getString("enterprise.deployment.backend.undeploy_error_application_not_registered");
                throw new IASDeploymentException(string);
            }
        } else if (this.request.isDeploy()) {
            if (this.isReg) {
                String string = localStrings.getString("enterprise.deployment.backend.deploy_error_application_exists");
                throw new IASDeploymentException(string);
            }
        } else if (this.request.isReDeploy() && !this.isReg) {
            String string = localStrings.getString("enterprise.deployment.backend.redeploy_error_application_does_not_exist");
            throw new IASDeploymentException(string);
        }
    }

    protected final void saveHotConfig() throws ConfigException {
        this.saveColdConfig();
        this.getAppMgr().applyServerXmlChanges();
    }

    protected final void createClientJar(ZipItem[] zipItemArray) throws IASDeploymentException {
        try {
            this.clientJar = new File(this.getAppDir(), this.getAppName() + "Client.jar");
            if (!this.request.isEar()) {
                ClientJarMaker clientJarMaker = new ClientJarMaker(this.getAppDir(), this.clientJar);
                clientJarMaker.createAppClient(zipItemArray);
            } else {
                File file = this.request.getFileSource().getFile();
                ClientJarArchivist clientJarArchivist = new ClientJarArchivist(file, this.clientJar);
                clientJarArchivist.createClientJar(zipItemArray);
            }
            this.request.setClientJar(this.clientJar);
        }
        catch (IASDeploymentException iASDeploymentException) {
            throw iASDeploymentException;
        }
        catch (Exception exception) {
            throw new IASDeploymentException(exception);
        }
    }

    protected final AppDD getAppDD() throws IASDeploymentException {
        if (this.appDD != null) {
            return this.appDD;
        }
        try {
            this.appDD = new AppDD(this.getAppDir());
        }
        catch (Exception exception) {
            throw new IASDeploymentException("Error creating AppDD instance: ", exception);
        }
        return this.appDD;
    }

    protected final void checkContextRoot() throws IASDeploymentException {
        this.getAppDD();
        String[] stringArray = this.appDD.getContextRoots();
        if (stringArray.length <= 0) {
            return;
        }
        ContextRootChecker contextRootChecker = new ContextRootChecker(this.getInstanceEnv(), stringArray, this.getAppMgr(), this.getAppName());
        contextRootChecker.check();
    }

    private final void setGeneratedDirs() throws IASDeploymentException {
        try {
            this.stubsDir = new File(this.getAppEnv().getAppStubPath());
            this.jspDir = new File(this.getAppEnv().getAppJSPPath());
            this.request.setJSPDirectory(this.jspDir);
            this.request.setStubsDirectory(this.stubsDir);
        }
        catch (Exception exception) {
            String string = localStrings.getString("enterprise.deployment.backend.error_getting_generated_dirs", exception);
            throw new IASDeploymentException(string);
        }
    }

    protected final ApplicationEnvironment getAppEnv() {
        return this.appEnv;
    }

    protected final AppsManager getAppMgr() {
        return this.appMgr;
    }

    protected final String getAppName() {
        return this.appName;
    }

    protected final File getStubsDir() {
        return this.stubsDir;
    }

    protected final File getJSPDir() {
        return this.jspDir;
    }

    protected final AppInfo getAppInfo() {
        return this.appInfo;
    }

    protected final File getAppDir() {
        return this.appDir;
    }

    protected final File getClientJar() {
        return this.clientJar;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$iplanet$ias$deployment$backend$AppDeployerBase == null ? (class$com$iplanet$ias$deployment$backend$AppDeployerBase = AppDeployerBase.class$("com.iplanet.ias.deployment.backend.AppDeployerBase")) : class$com$iplanet$ias$deployment$backend$AppDeployerBase).desiredAssertionStatus();
        localStrings = StringManager.getManager(class$com$iplanet$ias$deployment$backend$AppDeployerBase == null ? (class$com$iplanet$ias$deployment$backend$AppDeployerBase = AppDeployerBase.class$("com.iplanet.ias.deployment.backend.AppDeployerBase")) : class$com$iplanet$ias$deployment$backend$AppDeployerBase);
    }
}

