/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment;

import com.iplanet.ias.deployment.AppConfigEnv;
import com.iplanet.ias.deployment.AppConfigException;
import com.iplanet.ias.deployment.EjbModuleConfigEnv;
import com.iplanet.ias.deployment.backend.DeploymentLogger;
import com.iplanet.ias.deployment.xml.IASApplicationClientRuntimeDescriptorNode;
import com.iplanet.ias.deployment.xml.IASApplicationRuntimeDescriptorNode;
import com.iplanet.ias.deployment.xml.IASEjbRuntimeDescriptorNode;
import com.iplanet.ias.tools.common.dd.webapp.SunWebApp;
import com.iplanet.ias.util.i18n.StringManager;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.xml.ApplicationClientNode;
import com.sun.enterprise.deployment.xml.ApplicationNode;
import com.sun.enterprise.deployment.xml.ConnectorNode;
import com.sun.enterprise.deployment.xml.EjbBundleNode;
import com.sun.enterprise.deployment.xml.WebBundleNode;
import com.sun.enterprise.deployment.xml.XMLUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.logging.Logger;
import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.Document;

public class ApplicationXmlWriter {
    private static StringManager localStrings = StringManager.getManager(class$com$iplanet$ias$deployment$ApplicationXmlWriter == null ? (class$com$iplanet$ias$deployment$ApplicationXmlWriter = ApplicationXmlWriter.class$("com.iplanet.ias.deployment.ApplicationXmlWriter")) : class$com$iplanet$ias$deployment$ApplicationXmlWriter);
    private static final Logger _logger = DeploymentLogger.get();
    static /* synthetic */ Class class$com$iplanet$ias$deployment$ApplicationXmlWriter;

    public static void save(AppConfigEnv appConfigEnv, Application application) throws AppConfigException {
        _logger.fine("Saving the app descriptor....................");
        OutputStream outputStream = appConfigEnv.getApplicationIASXmlOutFile();
        XmlDocument xmlDocument = IASApplicationRuntimeDescriptorNode.getDocument(application);
        OutputStream outputStream2 = appConfigEnv.getApplicationXmlOutFile();
        XmlDocument xmlDocument2 = ApplicationNode.getDocument(application);
        try {
            XMLUtils.writeDocument((Document)xmlDocument2, outputStream2);
            outputStream2.close();
        }
        catch (IOException iOException) {
            String string = localStrings.getString("enterprise.deployment.application_dd_save_io_error");
            throw new AppConfigException(string, iOException);
        }
        try {
            XMLUtils.writeDocument((Document)xmlDocument, outputStream);
            outputStream.close();
        }
        catch (IOException iOException) {
            String string = localStrings.getString("enterprise.deployment.sun_application_dd_save_io_error");
            throw new AppConfigException(string, iOException);
        }
        ApplicationXmlWriter.saveEjbDescriptors(appConfigEnv, application);
        ApplicationXmlWriter.saveWebDescriptors(appConfigEnv, application);
        ApplicationXmlWriter.saveClientDescriptors(appConfigEnv, application);
        ApplicationXmlWriter.saveRarDescriptors(appConfigEnv, application);
    }

    public static void saveEjbModule(EjbModuleConfigEnv ejbModuleConfigEnv, Application application) throws AppConfigException, IOException {
        Iterator iterator = application.getEjbBundleDescriptors().iterator();
        while (iterator.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)iterator.next();
            OutputStream outputStream = ejbModuleConfigEnv.getXmlOutFile();
            XmlDocument xmlDocument = EjbBundleNode.getDocument(ejbBundleDescriptor);
            XMLUtils.writeDocument((Document)xmlDocument, outputStream);
            outputStream.close();
            OutputStream outputStream2 = ejbModuleConfigEnv.getIASXmlOutFile();
            XmlDocument xmlDocument2 = IASEjbRuntimeDescriptorNode.getDocument(ejbBundleDescriptor, application);
            XMLUtils.writeDocument((Document)xmlDocument2, outputStream2);
            outputStream2.close();
        }
    }

    private static void saveEjbDescriptors(AppConfigEnv appConfigEnv, Application application) throws AppConfigException {
        try {
            Iterator iterator = application.getEjbBundleDescriptors().iterator();
            while (iterator.hasNext()) {
                EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)iterator.next();
                String string = ejbBundleDescriptor.getArchivist().getArchiveUri();
                String string2 = ejbBundleDescriptor.getArchivist().getExternalDescriptorArchiveUri();
                OutputStream outputStream = appConfigEnv.getEjbModuleXmlOutFile(string, string2);
                XmlDocument xmlDocument = EjbBundleNode.getDocument(ejbBundleDescriptor);
                XMLUtils.writeDocument((Document)xmlDocument, outputStream);
                outputStream.close();
                OutputStream outputStream2 = appConfigEnv.getEjbModuleIASXmlOutFile(string, string2);
                XmlDocument xmlDocument2 = IASEjbRuntimeDescriptorNode.getDocument(ejbBundleDescriptor, application);
                XMLUtils.writeDocument((Document)xmlDocument2, outputStream2);
                outputStream2.close();
            }
        }
        catch (IOException iOException) {
            String string = localStrings.getString("enterprise.deployment.ejb_dd_save_io_error");
            throw new AppConfigException(string, iOException);
        }
    }

    private static void saveWebDescriptors(AppConfigEnv appConfigEnv, Application application) throws AppConfigException {
        try {
            Iterator iterator = application.getWebBundleDescriptors().iterator();
            while (iterator.hasNext()) {
                WebBundleDescriptor webBundleDescriptor = (WebBundleDescriptor)iterator.next();
                String string = webBundleDescriptor.getArchivist().getArchiveUri();
                String string2 = webBundleDescriptor.getArchivist().getExternalDescriptorArchiveUri();
                OutputStream outputStream = appConfigEnv.getWebModuleXmlOutFile(string, string2);
                XmlDocument xmlDocument = WebBundleNode.getDocument(webBundleDescriptor);
                XMLUtils.writeDocument((Document)xmlDocument, outputStream);
                outputStream.close();
                OutputStream outputStream2 = appConfigEnv.getWebModuleIASXmlOutFile(string, string2);
                SunWebApp sunWebApp = webBundleDescriptor.getIasWebApp();
                sunWebApp.write(outputStream2);
                outputStream2.close();
            }
        }
        catch (IOException iOException) {
            String string = localStrings.getString("enterprise.deployment.web_dd_save_io_error");
            throw new AppConfigException(string, iOException);
        }
    }

    private static void saveClientDescriptors(AppConfigEnv appConfigEnv, Application application) throws AppConfigException {
        try {
            Iterator iterator = application.getApplicationClientDescriptors().iterator();
            while (iterator.hasNext()) {
                ApplicationClientDescriptor applicationClientDescriptor = (ApplicationClientDescriptor)iterator.next();
                String string = applicationClientDescriptor.getArchivist().getArchiveUri();
                String string2 = applicationClientDescriptor.getArchivist().getExternalDescriptorArchiveUri();
                OutputStream outputStream = appConfigEnv.getClientModuleXmlOutFile(string, string2);
                XmlDocument xmlDocument = ApplicationClientNode.getDocument(applicationClientDescriptor);
                XMLUtils.writeDocument((Document)xmlDocument, outputStream);
                outputStream.close();
                OutputStream outputStream2 = appConfigEnv.getClientModuleIASXmlOutFile(string, string2);
                XmlDocument xmlDocument2 = IASApplicationClientRuntimeDescriptorNode.getDocument(applicationClientDescriptor);
                XMLUtils.writeDocument((Document)xmlDocument2, outputStream2);
                outputStream2.close();
            }
        }
        catch (IOException iOException) {
            String string = localStrings.getString("enterprise.deployment.appclient_dd_save_io_error");
            throw new AppConfigException(string, iOException);
        }
    }

    private static void saveRarDescriptors(AppConfigEnv appConfigEnv, Application application) throws AppConfigException {
        try {
            Iterator iterator = application.getRarDescriptors().iterator();
            while (iterator.hasNext()) {
                ConnectorDescriptor connectorDescriptor = (ConnectorDescriptor)iterator.next();
                String string = connectorDescriptor.getArchivist().getArchiveUri();
                String string2 = connectorDescriptor.getArchivist().getExternalDescriptorArchiveUri();
                OutputStream outputStream = appConfigEnv.getRarModuleXmlOutFile(string, string2);
                XmlDocument xmlDocument = ConnectorNode.getDocument(connectorDescriptor);
                XMLUtils.writeDocument((Document)xmlDocument, outputStream);
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            String string = localStrings.getString("enterprise.deployment.appclient_dd_save_io_error");
            throw new AppConfigException(string, iOException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

