/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.config.serverbeans;

import com.iplanet.ias.config.ConfigBean;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.StaleWriteConfigException;
import com.iplanet.ias.config.serverbeans.Acl;
import com.iplanet.ias.config.serverbeans.ElementProperty;
import com.iplanet.ias.config.serverbeans.HttpListener;
import com.iplanet.ias.config.serverbeans.HttpQos;
import com.iplanet.ias.config.serverbeans.Mime;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.iplanet.ias.config.serverbeans.VirtualServerClass;
import java.io.File;
import java.io.Serializable;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.GenBeans;

public class HttpService
extends ConfigBean
implements Serializable {
    static Vector comparators = new Vector();
    public static final String HTTP_LISTENER = "HttpListener";
    public static final String MIME = "Mime";
    public static final String ACL = "Acl";
    public static final String VIRTUAL_SERVER_CLASS = "VirtualServerClass";
    public static final String HTTP_QOS = "HttpQos";
    public static final String ELEMENT_PROPERTY = "ElementProperty";
    static /* synthetic */ Class class$com$iplanet$ias$config$serverbeans$HttpListener;
    static /* synthetic */ Class class$com$iplanet$ias$config$serverbeans$Mime;
    static /* synthetic */ Class class$com$iplanet$ias$config$serverbeans$Acl;
    static /* synthetic */ Class class$com$iplanet$ias$config$serverbeans$VirtualServerClass;
    static /* synthetic */ Class class$com$iplanet$ias$config$serverbeans$HttpQos;
    static /* synthetic */ Class class$com$iplanet$ias$config$serverbeans$ElementProperty;

    public HttpService() {
        this(Common.USE_DEFAULT_VALUES);
    }

    public HttpService(int n) {
        super(comparators, new GenBeans.Version(1, 0, 8));
        this.createProperty("http-listener", HTTP_LISTENER, 66098, class$com$iplanet$ias$config$serverbeans$HttpListener == null ? (class$com$iplanet$ias$config$serverbeans$HttpListener = HttpService.class$("com.iplanet.ias.config.serverbeans.HttpListener")) : class$com$iplanet$ias$config$serverbeans$HttpListener);
        this.createAttribute(HTTP_LISTENER, "id", "Id", 257, null, null);
        this.createAttribute(HTTP_LISTENER, "address", "Address", 257, null, null);
        this.createAttribute(HTTP_LISTENER, "port", "Port", 257, null, null);
        this.createAttribute(HTTP_LISTENER, "family", "Family", 513, null, null);
        this.createAttribute(HTTP_LISTENER, "acceptor-threads", "AcceptorThreads", 1, null, "1");
        this.createAttribute(HTTP_LISTENER, "blocking-enabled", "BlockingEnabled", 1, null, "false");
        this.createAttribute(HTTP_LISTENER, "security-enabled", "SecurityEnabled", 1, null, "false");
        this.createAttribute(HTTP_LISTENER, "default-virtual-server", "DefaultVirtualServer", 257, null, null);
        this.createAttribute(HTTP_LISTENER, "server-name", "ServerName", 257, null, null);
        this.createAttribute(HTTP_LISTENER, "enabled", "Enabled", 1, null, "true");
        this.createProperty("mime", MIME, 66098, class$com$iplanet$ias$config$serverbeans$Mime == null ? (class$com$iplanet$ias$config$serverbeans$Mime = HttpService.class$("com.iplanet.ias.config.serverbeans.Mime")) : class$com$iplanet$ias$config$serverbeans$Mime);
        this.createAttribute(MIME, "id", "Id", 257, null, null);
        this.createAttribute(MIME, "file", "File", 257, null, null);
        this.createProperty("acl", ACL, 66098, class$com$iplanet$ias$config$serverbeans$Acl == null ? (class$com$iplanet$ias$config$serverbeans$Acl = HttpService.class$("com.iplanet.ias.config.serverbeans.Acl")) : class$com$iplanet$ias$config$serverbeans$Acl);
        this.createAttribute(ACL, "id", "Id", 257, null, null);
        this.createAttribute(ACL, "file", "File", 257, null, null);
        this.createProperty("virtual-server-class", VIRTUAL_SERVER_CLASS, 66098, class$com$iplanet$ias$config$serverbeans$VirtualServerClass == null ? (class$com$iplanet$ias$config$serverbeans$VirtualServerClass = HttpService.class$("com.iplanet.ias.config.serverbeans.VirtualServerClass")) : class$com$iplanet$ias$config$serverbeans$VirtualServerClass);
        this.createAttribute(VIRTUAL_SERVER_CLASS, "id", "Id", 257, null, null);
        this.createAttribute(VIRTUAL_SERVER_CLASS, "config-file", "ConfigFile", 513, null, null);
        this.createAttribute(VIRTUAL_SERVER_CLASS, "default-object", "DefaultObject", 1, null, "default");
        this.createAttribute(VIRTUAL_SERVER_CLASS, "accept-language", "AcceptLanguage", 1, null, "false");
        this.createAttribute(VIRTUAL_SERVER_CLASS, "enabled", "Enabled", 1, null, "true");
        this.createProperty("http-qos", HTTP_QOS, 66064, class$com$iplanet$ias$config$serverbeans$HttpQos == null ? (class$com$iplanet$ias$config$serverbeans$HttpQos = HttpService.class$("com.iplanet.ias.config.serverbeans.HttpQos")) : class$com$iplanet$ias$config$serverbeans$HttpQos);
        this.createAttribute(HTTP_QOS, "bandwidth-limit", "BandwidthLimit", 513, null, null);
        this.createAttribute(HTTP_QOS, "enforce-bandwidth-limit", "EnforceBandwidthLimit", 1, null, "false");
        this.createAttribute(HTTP_QOS, "connection-limit", "ConnectionLimit", 513, null, null);
        this.createAttribute(HTTP_QOS, "enforce-connection-limit", "EnforceConnectionLimit", 1, null, "false");
        this.createProperty("property", ELEMENT_PROPERTY, 66096, class$com$iplanet$ias$config$serverbeans$ElementProperty == null ? (class$com$iplanet$ias$config$serverbeans$ElementProperty = HttpService.class$("com.iplanet.ias.config.serverbeans.ElementProperty")) : class$com$iplanet$ias$config$serverbeans$ElementProperty);
        this.createAttribute(ELEMENT_PROPERTY, "name", "Name", 257, null, null);
        this.createAttribute(ELEMENT_PROPERTY, "value", "Value", 257, null, null);
        this.initialize(n);
    }

    void initialize(int n) {
        this.setAttributeValue(ServerTags.QOS_METRICS_INTERVAL_IN_SECONDS, "30");
        this.setAttributeValue(ServerTags.QOS_RECOMPUTE_TIME_INTERVAL_IN_MILLIS, "100");
        this.setAttributeValue(ServerTags.QOS_ENABLED, "true");
    }

    public void setHttpListener(int n, HttpListener httpListener) {
        this.setValue(HTTP_LISTENER, n, httpListener);
    }

    public HttpListener getHttpListener(int n) {
        return (HttpListener)this.getValue(HTTP_LISTENER, n);
    }

    public void setHttpListener(HttpListener[] httpListenerArray) {
        this.setValue(HTTP_LISTENER, httpListenerArray);
    }

    public HttpListener[] getHttpListener() {
        return (HttpListener[])this.getValues(HTTP_LISTENER);
    }

    public int sizeHttpListener() {
        return this.size(HTTP_LISTENER);
    }

    public int addHttpListener(HttpListener httpListener) throws ConfigException {
        return this.addHttpListener(httpListener, true);
    }

    public int addHttpListener(HttpListener httpListener, boolean bl) throws ConfigException {
        HttpListener httpListener2 = this.getHttpListenerById(httpListener.getId());
        if (httpListener2 != null) {
            String string = ConfigBean.localStrings.getString("com.iplanet.ias.config.http_listener");
            throw new ConfigException(string);
        }
        return this.addValue(HTTP_LISTENER, httpListener, bl);
    }

    public int removeHttpListener(HttpListener httpListener) {
        return this.removeValue(HTTP_LISTENER, httpListener);
    }

    public int removeHttpListener(HttpListener httpListener, boolean bl) throws StaleWriteConfigException {
        return this.removeValue(HTTP_LISTENER, httpListener, bl);
    }

    public HttpListener getHttpListenerById(String string) {
        HttpListener[] httpListenerArray = this.getHttpListener();
        if (httpListenerArray == null) {
            return null;
        }
        int n = 0;
        while (n < httpListenerArray.length) {
            if (httpListenerArray[n].getAttributeValue(Common.convertName((String)ServerTags.ID)).equals(string)) {
                return httpListenerArray[n];
            }
            ++n;
        }
        return null;
    }

    public void setMime(int n, Mime mime) {
        this.setValue(MIME, n, mime);
    }

    public Mime getMime(int n) {
        return (Mime)this.getValue(MIME, n);
    }

    public void setMime(Mime[] mimeArray) {
        this.setValue(MIME, mimeArray);
    }

    public Mime[] getMime() {
        return (Mime[])this.getValues(MIME);
    }

    public int sizeMime() {
        return this.size(MIME);
    }

    public int addMime(Mime mime) throws ConfigException {
        return this.addMime(mime, true);
    }

    public int addMime(Mime mime, boolean bl) throws ConfigException {
        Mime mime2 = this.getMimeById(mime.getId());
        if (mime2 != null) {
            String string = ConfigBean.localStrings.getString("com.iplanet.ias.config.mime");
            throw new ConfigException(string);
        }
        return this.addValue(MIME, mime, bl);
    }

    public int removeMime(Mime mime) {
        return this.removeValue(MIME, mime);
    }

    public int removeMime(Mime mime, boolean bl) throws StaleWriteConfigException {
        return this.removeValue(MIME, mime, bl);
    }

    public Mime getMimeById(String string) {
        Mime[] mimeArray = this.getMime();
        if (mimeArray == null) {
            return null;
        }
        int n = 0;
        while (n < mimeArray.length) {
            if (mimeArray[n].getAttributeValue(Common.convertName((String)ServerTags.ID)).equals(string)) {
                return mimeArray[n];
            }
            ++n;
        }
        return null;
    }

    public void setAcl(int n, Acl acl) {
        this.setValue(ACL, n, acl);
    }

    public Acl getAcl(int n) {
        return (Acl)this.getValue(ACL, n);
    }

    public void setAcl(Acl[] aclArray) {
        this.setValue(ACL, aclArray);
    }

    public Acl[] getAcl() {
        return (Acl[])this.getValues(ACL);
    }

    public int sizeAcl() {
        return this.size(ACL);
    }

    public int addAcl(Acl acl) throws ConfigException {
        return this.addAcl(acl, true);
    }

    public int addAcl(Acl acl, boolean bl) throws ConfigException {
        return this.addAcl(acl, bl, false);
    }

    public int addAcl(Acl acl, boolean bl, boolean bl2) throws ConfigException {
        Acl acl2 = this.getAclById(acl.getId());
        if (acl2 != null) {
            Object object;
            if (bl2) {
                object = new File(acl.getFile());
                try {
                    ((File)object).delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            object = ConfigBean.localStrings.getString("com.iplanet.ias.config.acl");
            throw new ConfigException((String)object);
        }
        return this.addValue(ACL, acl, bl);
    }

    public int removeAcl(Acl acl) {
        return this.removeValue(ACL, acl);
    }

    public int removeAcl(Acl acl, boolean bl) throws StaleWriteConfigException {
        return this.removeValue(ACL, acl, bl);
    }

    public Acl getAclById(String string) {
        Acl[] aclArray = this.getAcl();
        if (aclArray == null) {
            return null;
        }
        int n = 0;
        while (n < aclArray.length) {
            if (aclArray[n].getAttributeValue(Common.convertName((String)ServerTags.ID)).equals(string)) {
                return aclArray[n];
            }
            ++n;
        }
        return null;
    }

    public void setVirtualServerClass(int n, VirtualServerClass virtualServerClass) {
        this.setValue(VIRTUAL_SERVER_CLASS, n, virtualServerClass);
    }

    public VirtualServerClass getVirtualServerClass(int n) {
        return (VirtualServerClass)this.getValue(VIRTUAL_SERVER_CLASS, n);
    }

    public void setVirtualServerClass(VirtualServerClass[] virtualServerClassArray) {
        this.setValue(VIRTUAL_SERVER_CLASS, virtualServerClassArray);
    }

    public VirtualServerClass[] getVirtualServerClass() {
        return (VirtualServerClass[])this.getValues(VIRTUAL_SERVER_CLASS);
    }

    public int sizeVirtualServerClass() {
        return this.size(VIRTUAL_SERVER_CLASS);
    }

    public int addVirtualServerClass(VirtualServerClass virtualServerClass) throws ConfigException {
        return this.addVirtualServerClass(virtualServerClass, true);
    }

    public int addVirtualServerClass(VirtualServerClass virtualServerClass, boolean bl) throws ConfigException {
        VirtualServerClass virtualServerClass2 = this.getVirtualServerClassById(virtualServerClass.getId());
        if (virtualServerClass2 != null) {
            String string = ConfigBean.localStrings.getString("com.iplanet.ias.config.virtual_server_class");
            throw new ConfigException(string);
        }
        return this.addValue(VIRTUAL_SERVER_CLASS, virtualServerClass, bl);
    }

    public int removeVirtualServerClass(VirtualServerClass virtualServerClass) {
        return this.removeValue(VIRTUAL_SERVER_CLASS, virtualServerClass);
    }

    public int removeVirtualServerClass(VirtualServerClass virtualServerClass, boolean bl) throws StaleWriteConfigException {
        return this.removeValue(VIRTUAL_SERVER_CLASS, virtualServerClass, bl);
    }

    public VirtualServerClass getVirtualServerClassById(String string) {
        VirtualServerClass[] virtualServerClassArray = this.getVirtualServerClass();
        if (virtualServerClassArray == null) {
            return null;
        }
        int n = 0;
        while (n < virtualServerClassArray.length) {
            if (virtualServerClassArray[n].getAttributeValue(Common.convertName((String)ServerTags.ID)).equals(string)) {
                return virtualServerClassArray[n];
            }
            ++n;
        }
        return null;
    }

    public void setHttpQos(HttpQos httpQos) {
        this.setValue(HTTP_QOS, httpQos);
    }

    public HttpQos getHttpQos() {
        return (HttpQos)this.getValue(HTTP_QOS);
    }

    public void setElementProperty(int n, ElementProperty elementProperty) {
        this.setValue(ELEMENT_PROPERTY, n, elementProperty);
    }

    public ElementProperty getElementProperty(int n) {
        return (ElementProperty)this.getValue(ELEMENT_PROPERTY, n);
    }

    public void setElementProperty(ElementProperty[] elementPropertyArray) {
        this.setValue(ELEMENT_PROPERTY, elementPropertyArray);
    }

    public ElementProperty[] getElementProperty() {
        return (ElementProperty[])this.getValues(ELEMENT_PROPERTY);
    }

    public int sizeElementProperty() {
        return this.size(ELEMENT_PROPERTY);
    }

    public int addElementProperty(ElementProperty elementProperty) throws ConfigException {
        return this.addElementProperty(elementProperty, true);
    }

    public int addElementProperty(ElementProperty elementProperty, boolean bl) throws ConfigException {
        ElementProperty elementProperty2 = this.getElementPropertyByName(elementProperty.getName());
        if (elementProperty2 != null) {
            String string = ConfigBean.localStrings.getString("com.iplanet.ias.config.element_property");
            throw new ConfigException(string);
        }
        return this.addValue(ELEMENT_PROPERTY, elementProperty, bl);
    }

    public int removeElementProperty(ElementProperty elementProperty) {
        return this.removeValue(ELEMENT_PROPERTY, elementProperty);
    }

    public int removeElementProperty(ElementProperty elementProperty, boolean bl) throws StaleWriteConfigException {
        return this.removeValue(ELEMENT_PROPERTY, elementProperty, bl);
    }

    public ElementProperty getElementPropertyByName(String string) {
        ElementProperty[] elementPropertyArray = this.getElementProperty();
        if (elementPropertyArray == null) {
            return null;
        }
        int n = 0;
        while (n < elementPropertyArray.length) {
            if (elementPropertyArray[n].getAttributeValue(Common.convertName((String)ServerTags.NAME)).equals(string)) {
                return elementPropertyArray[n];
            }
            ++n;
        }
        return null;
    }

    public String getQosMetricsIntervalInSeconds() {
        return this.getAttributeValue(ServerTags.QOS_METRICS_INTERVAL_IN_SECONDS);
    }

    public void setQosMetricsIntervalInSeconds(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.QOS_METRICS_INTERVAL_IN_SECONDS, string, bl);
    }

    public void setQosMetricsIntervalInSeconds(String string) {
        this.setAttributeValue(ServerTags.QOS_METRICS_INTERVAL_IN_SECONDS, string);
    }

    public String getQosRecomputeTimeIntervalInMillis() {
        return this.getAttributeValue(ServerTags.QOS_RECOMPUTE_TIME_INTERVAL_IN_MILLIS);
    }

    public void setQosRecomputeTimeIntervalInMillis(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.QOS_RECOMPUTE_TIME_INTERVAL_IN_MILLIS, string, bl);
    }

    public void setQosRecomputeTimeIntervalInMillis(String string) {
        this.setAttributeValue(ServerTags.QOS_RECOMPUTE_TIME_INTERVAL_IN_MILLIS, string);
    }

    public boolean isQosEnabled() {
        return ConfigBean.toBoolean(this.getAttributeValue(ServerTags.QOS_ENABLED));
    }

    public void setQosEnabled(boolean bl, boolean bl2) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.QOS_ENABLED, "" + bl, bl2);
    }

    public void setQosEnabled(boolean bl) {
        this.setAttributeValue(ServerTags.QOS_ENABLED, "" + bl);
    }

    protected String getRelativeXPath() {
        String string = null;
        string = "http-service";
        return string;
    }

    public boolean verify() {
        return true;
    }

    public static void addComparator(BeanComparator beanComparator) {
        comparators.add(beanComparator);
    }

    public static void removeComparator(BeanComparator beanComparator) {
        comparators.remove(beanComparator);
    }

    public static String getDefaultAttributeValue(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals(ServerTags.QOS_METRICS_INTERVAL_IN_SECONDS)) {
            return "30";
        }
        if (string.equals(ServerTags.QOS_RECOMPUTE_TIME_INTERVAL_IN_MILLIS)) {
            return "100";
        }
        if (string.equals(ServerTags.QOS_ENABLED)) {
            return "true";
        }
        return null;
    }

    public static String getDefaultQosMetricsIntervalInSeconds() {
        return "30";
    }

    public static String getDefaultQosRecomputeTimeIntervalInMillis() {
        return "100";
    }

    public static String getDefaultQosEnabled() {
        return "true";
    }

    public void dump(StringBuffer stringBuffer, String string) {
        ConfigBean configBean;
        stringBuffer.append(string);
        stringBuffer.append("HttpListener[" + this.sizeHttpListener() + "]");
        int n = 0;
        while (n < this.sizeHttpListener()) {
            stringBuffer.append(string + "\t");
            stringBuffer.append("#" + n + ":");
            configBean = this.getHttpListener(n);
            if (configBean != null) {
                configBean.dump(stringBuffer, string + "\t");
            } else {
                stringBuffer.append(string + "\tnull");
            }
            this.dumpAttributes(HTTP_LISTENER, n, stringBuffer, string);
            ++n;
        }
        stringBuffer.append(string);
        stringBuffer.append("Mime[" + this.sizeMime() + "]");
        int n2 = 0;
        while (n2 < this.sizeMime()) {
            stringBuffer.append(string + "\t");
            stringBuffer.append("#" + n2 + ":");
            configBean = this.getMime(n2);
            if (configBean != null) {
                configBean.dump(stringBuffer, string + "\t");
            } else {
                stringBuffer.append(string + "\tnull");
            }
            this.dumpAttributes(MIME, n2, stringBuffer, string);
            ++n2;
        }
        stringBuffer.append(string);
        stringBuffer.append("Acl[" + this.sizeAcl() + "]");
        int n3 = 0;
        while (n3 < this.sizeAcl()) {
            stringBuffer.append(string + "\t");
            stringBuffer.append("#" + n3 + ":");
            configBean = this.getAcl(n3);
            if (configBean != null) {
                configBean.dump(stringBuffer, string + "\t");
            } else {
                stringBuffer.append(string + "\tnull");
            }
            this.dumpAttributes(ACL, n3, stringBuffer, string);
            ++n3;
        }
        stringBuffer.append(string);
        stringBuffer.append("VirtualServerClass[" + this.sizeVirtualServerClass() + "]");
        int n4 = 0;
        while (n4 < this.sizeVirtualServerClass()) {
            stringBuffer.append(string + "\t");
            stringBuffer.append("#" + n4 + ":");
            configBean = this.getVirtualServerClass(n4);
            if (configBean != null) {
                configBean.dump(stringBuffer, string + "\t");
            } else {
                stringBuffer.append(string + "\tnull");
            }
            this.dumpAttributes(VIRTUAL_SERVER_CLASS, n4, stringBuffer, string);
            ++n4;
        }
        stringBuffer.append(string);
        stringBuffer.append(HTTP_QOS);
        configBean = this.getHttpQos();
        if (configBean != null) {
            configBean.dump(stringBuffer, string + "\t");
        } else {
            stringBuffer.append(string + "\tnull");
        }
        this.dumpAttributes(HTTP_QOS, 0, stringBuffer, string);
        stringBuffer.append(string);
        stringBuffer.append("ElementProperty[" + this.sizeElementProperty() + "]");
        int n5 = 0;
        while (n5 < this.sizeElementProperty()) {
            stringBuffer.append(string + "\t");
            stringBuffer.append("#" + n5 + ":");
            configBean = this.getElementProperty(n5);
            if (configBean != null) {
                configBean.dump(stringBuffer, string + "\t");
            } else {
                stringBuffer.append(string + "\tnull");
            }
            this.dumpAttributes(ELEMENT_PROPERTY, n5, stringBuffer, string);
            ++n5;
        }
    }

    public String dumpBeanNode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("HttpService\n");
        this.dump(stringBuffer, "\n  ");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

