/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.cis.channel.tcp;

import com.iplanet.ias.cis.channel.Channel;
import com.iplanet.ias.cis.channel.ChannelException;
import com.iplanet.ias.cis.channel.ChannelOptions;
import com.iplanet.ias.cis.channel.tcp.TCPChannelOptions;
import com.iplanet.ias.cis.connection.EndPoint;
import java.nio.ByteBuffer;

public abstract class TCPChannel
implements Channel {
    protected int bufSize = 16384;
    protected int fd;
    protected int localPort;
    protected int peerPort;
    protected String localIP;
    protected String peerIP;
    protected int tableIndex = -1;
    protected ByteBuffer sendBuffer;
    protected ByteBuffer recvBuffer;
    protected int inPollFlag;
    protected int outPollFlag;
    protected EndPoint peer = null;
    protected EndPoint local = null;
    protected TCPChannelOptions options = null;
    protected String type;

    protected TCPChannel() {
    }

    public ChannelOptions getChannelOptions() throws ChannelException {
        if (this.options == null) {
            this.options = new TCPChannelOptions(this.fd);
        }
        return this.options;
    }

    public EndPoint getLocalEndPoint() throws ChannelException {
        if (this.local == null) {
            this.local = EndPoint.getEndPoint(this.type, this.localIP, this.localPort);
        }
        return this.local;
    }

    public EndPoint getPeerEndPoint() throws ChannelException {
        if (this.peer == null) {
            this.peer = EndPoint.getEndPoint(this.type, this.peerIP, this.peerPort);
        }
        return this.peer;
    }

    public void setType(String string) {
        this.type = string;
    }

    public void setPollFlag(int n) throws ChannelException {
        this.inPollFlag = n;
    }

    public int getPollFlag() throws ChannelException {
        return this.inPollFlag;
    }

    public int getOutPollFlag() throws ChannelException {
        return this.outPollFlag;
    }

    public ByteBuffer getSendByteBuffer() throws ChannelException {
        return this.sendBuffer;
    }

    public ByteBuffer getRecvByteBuffer() throws ChannelException {
        return this.recvBuffer;
    }

    public void lock(int n, int n2) throws ChannelException {
    }

    public void unlock(int n) throws ChannelException {
    }

    public boolean isValid() throws ChannelException {
        return this.fd != 0;
    }

    public boolean isLocal() throws ChannelException {
        return false;
    }

    public abstract int send(byte[] var1, int var2, int var3) throws ChannelException;

    public abstract int sendFully(byte[] var1, int var2, int var3) throws ChannelException;

    public abstract int recv(byte[] var1, int var2, int var3, int var4) throws ChannelException;

    public abstract int recvFully(byte[] var1, int var2, int var3) throws ChannelException;

    public abstract int send(int var1, int var2) throws ChannelException;

    public abstract int send(ByteBuffer var1, int var2) throws ChannelException;

    public abstract int sendFully(int var1, int var2) throws ChannelException;

    public abstract int recv(int var1, int var2, int var3) throws ChannelException;

    public abstract int recv(ByteBuffer var1, int var2) throws ChannelException;

    public abstract int recvFully(int var1, int var2) throws ChannelException;

    public abstract void close() throws ChannelException;

    public abstract boolean isBlockingChannel() throws ChannelException;
}

