/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.utility.generator.io;

import com.sun.jdo.spi.persistence.utility.StringHelper;
import com.sun.jdo.spi.persistence.utility.generator.JavaClassWriter;
import com.sun.jdo.spi.persistence.utility.generator.io.FormattedWriter;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class IOJavaClassWriter
implements JavaClassWriter {
    private static final String FIELD = "FIELD";
    private static final String INITIALIZER = "INITIALIZER";
    private static final String CONSTRUCTOR = "CONSTRUCTOR";
    private static final String METHOD = "METHOD";
    private static final String INNER_CLASS = "INNER_CLASS";
    private static final String MIXED = "MIXED";
    private static final String COMMA_SEPARATOR = ", ";
    private boolean _maintainCategories;
    private String _superclass;
    private String _classDeclarationBlock;
    private List _interfaces = new ArrayList();
    private Map _members = new HashMap();

    public IOJavaClassWriter() {
        this(true);
    }

    public IOJavaClassWriter(boolean bl) {
        this._maintainCategories = bl;
    }

    public void setClassDeclaration(int n, String string, String[] stringArray) {
        FormattedWriter formattedWriter = new FormattedWriter();
        String string2 = Modifier.toString(n);
        formattedWriter.writeComments(stringArray);
        formattedWriter.writeln(string2 + (string2.length() > 0 ? " " : "") + "class " + string);
        this._classDeclarationBlock = formattedWriter.toString();
    }

    public void setSuperclass(String string) {
        this._superclass = string;
    }

    public void addInterface(String string) {
        if (!StringHelper.isEmpty(string)) {
            this._interfaces.add(string);
        }
    }

    public void addField(String string, int n, String string2, String string3, String[] stringArray) {
        FormattedWriter formattedWriter = new FormattedWriter();
        String string4 = Modifier.toString(n) + ' ' + string2 + ' ' + string;
        formattedWriter.writeComments(stringArray);
        formattedWriter.writeln(string4 + (string3 != null ? " = " + string3 : "") + ';');
        this.getMemberList(FIELD).add(formattedWriter.toString());
    }

    public void addInitializer(boolean bl, String[] stringArray, String[] stringArray2) {
        FormattedWriter formattedWriter = new FormattedWriter();
        int n = stringArray != null ? stringArray.length : 0;
        formattedWriter.writeComments(stringArray2);
        formattedWriter.writeln(bl ? "static" : "");
        formattedWriter.writeln("{");
        int n2 = 0;
        while (n2 < n) {
            formattedWriter.writeln(1, stringArray[n2]);
            ++n2;
        }
        formattedWriter.writeln("}");
        this.getMemberList(INITIALIZER).add(formattedWriter.toString());
    }

    public void addConstructor(String string, int n, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5) {
        this.addMethod(string, n, null, stringArray, stringArray2, stringArray3, stringArray4, stringArray5, this.getMemberList(CONSTRUCTOR));
    }

    public void addMethod(String string, int n, String string2, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5) {
        this.addMethod(string, n, string2, stringArray, stringArray2, stringArray3, stringArray4, stringArray5, this.getMemberList(METHOD));
    }

    public void addClass(JavaClassWriter javaClassWriter) {
        if (javaClassWriter != null) {
            this.getMemberList(INNER_CLASS).add(javaClassWriter);
        }
    }

    public String toString() {
        FormattedWriter formattedWriter = new FormattedWriter();
        this.writeClassDeclaration(formattedWriter);
        this.writeMembers(formattedWriter);
        formattedWriter.writeln("}");
        formattedWriter.writeln();
        return formattedWriter.toString();
    }

    private void addMethod(String string, int n, String string2, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, List list) {
        String string3 = IOJavaClassWriter.createMethodSignature(string, n, string2, stringArray, stringArray2, stringArray3);
        FormattedWriter formattedWriter = new FormattedWriter();
        int n2 = stringArray4 != null ? stringArray4.length : 0;
        formattedWriter.writeComments(stringArray5);
        if (string3.length() > 0) {
            formattedWriter.writeln(string3);
        }
        formattedWriter.writeln("{");
        int n3 = 0;
        while (n3 < n2) {
            formattedWriter.writeln(1, stringArray4[n3]);
            ++n3;
        }
        formattedWriter.writeln("}");
        list.add(formattedWriter.toString());
    }

    private static String createMethodSignature(String string, int n, String string2, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        int n2 = stringArray != null ? stringArray.length : 0;
        ArrayList arrayList = new ArrayList();
        FormattedWriter formattedWriter = new FormattedWriter();
        if (n != 0) {
            formattedWriter.write(Modifier.toString(n) + ' ');
        }
        formattedWriter.write((string2 != null ? string2 + " " : "") + string);
        formattedWriter.write(" (");
        int n3 = 0;
        while (n3 < n2) {
            IOJavaClassWriter.writeListElement(n3, n2, stringArray2[n3] + ' ' + stringArray[n3], formattedWriter);
            ++n3;
        }
        formattedWriter.write(")");
        int n4 = n2 = stringArray3 != null ? stringArray3.length : 0;
        if (n2 > 0) {
            formattedWriter.writeln();
            formattedWriter.write(1, "throws ");
            n3 = 0;
            while (n3 < n2) {
                IOJavaClassWriter.writeListElement(n3, n2, stringArray3[n3], formattedWriter);
                ++n3;
            }
        }
        return formattedWriter.toString();
    }

    private static void writeListElement(int n, int n2, String string, FormattedWriter formattedWriter) {
        int n3;
        int n4 = n3 = n == 0 ? 0 : 1;
        if (n == n2 - 1) {
            formattedWriter.write(n3, string);
        } else {
            formattedWriter.writeln(n3, string + COMMA_SEPARATOR);
        }
    }

    private List getMemberList(String string) {
        ArrayList arrayList = null;
        if (!this._maintainCategories) {
            string = MIXED;
        }
        if ((arrayList = (ArrayList)this._members.get(string)) == null) {
            arrayList = new ArrayList();
            this._members.put(string, arrayList);
        }
        return arrayList;
    }

    private void writeClassDeclaration(FormattedWriter formattedWriter) {
        formattedWriter.write(this._classDeclarationBlock);
        if (this._superclass != null) {
            formattedWriter.writeln(1, "extends " + this._superclass);
        }
        if (this._interfaces != null && this._interfaces.size() > 0) {
            formattedWriter.write(1, "implements ");
            formattedWriter.write(StringHelper.arrayToSeparatedList(this._interfaces, COMMA_SEPARATOR));
            formattedWriter.writeln();
        }
        formattedWriter.writeln("{");
    }

    private void writeMembers(FormattedWriter formattedWriter) {
        if (this._maintainCategories) {
            formattedWriter.writeList(1, this.getMemberList(FIELD));
            formattedWriter.writeList(1, this.getMemberList(INITIALIZER));
            formattedWriter.writeList(1, this.getMemberList(CONSTRUCTOR));
            formattedWriter.writeList(1, this.getMemberList(METHOD));
            formattedWriter.writeList(1, this.getMemberList(INNER_CLASS));
        } else {
            formattedWriter.writeList(1, this.getMemberList(MIXED), true);
        }
    }
}

